/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.persistable.DatabaseInfo;
import org.beigesoft.replicator.service.IDatabaseWriter;
import org.beigesoft.replicator.service.ISrvEntityWriter;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class DatabaseWriterXml<RS>
implements IDatabaseWriter {
    private ISrvEntityWriter srvEntityWriter;
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;

    @Override
    public final <T> int retrieveAndWriteEntities(Map<String, Object> pAddParam, Class<T> pEntityClass, Writer pWriter) throws Exception {
        String conditions = (String)pAddParam.get("conditions");
        int requestingDatabaseVersion = Integer.parseInt((String)pAddParam.get("requestingDatabaseVersion"));
        int databaseVersion = this.srvDatabase.getVersionDatabase();
        List<T> entities = null;
        int entitiesCount = 0;
        if (requestingDatabaseVersion == databaseVersion) {
            DatabaseInfo di;
            try {
                int requestedDatabaseId;
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                di = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, DatabaseInfo.class, "");
                String requestedDatabaseIdStr = (String)pAddParam.get("requestedDatabaseId");
                if (requestedDatabaseIdStr != null && (requestedDatabaseId = Integer.parseInt(requestedDatabaseIdStr)) != di.getDatabaseId()) {
                    String error = "Different requested database ID! required/is: " + requestedDatabaseId + "/" + di.getDatabaseId();
                    this.logger.error(null, DatabaseWriterXml.class, error);
                    pWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    pWriter.write("<message error=\"" + error + "\">\n");
                    pWriter.write("</message>\n");
                    int n = entitiesCount;
                    return n;
                }
                entities = conditions == null ? this.getSrvOrm().retrieveList(pAddParam, pEntityClass) : this.getSrvOrm().retrieveListWithConditions(pAddParam, pEntityClass, conditions);
                entitiesCount = entities.size();
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                this.srvDatabase.rollBackTransaction();
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
            this.logger.info(null, DatabaseWriterXml.class, "Start write entities of " + pEntityClass.getCanonicalName() + " count=" + entitiesCount);
            pWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pWriter.write("<message databaseId=\"" + di.getDatabaseId() + "\" databaseVersion=\"" + di.getDatabaseVersion() + "\" description=\"" + di.getDescription() + "\" entitiesCount=\"" + entitiesCount + "\">\n");
            for (T entity : entities) {
                this.srvEntityWriter.write(pAddParam, entity, pWriter);
            }
            pWriter.write("</message>\n");
            this.logger.info(null, DatabaseWriterXml.class, "Entities has been wrote");
        } else {
            this.logger.error(null, DatabaseWriterXml.class, "Send error message - Different database version!");
            pWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pWriter.write("<message error=\"Different database version!\">\n");
            pWriter.write("</message>\n");
        }
        return entitiesCount;
    }

    public final ISrvEntityWriter getSrvEntityWriter() {
        return this.srvEntityWriter;
    }

    public final void setSrvEntityWriter(ISrvEntityWriter pSrvEntityWriter) {
        this.srvEntityWriter = pSrvEntityWriter;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }
}

