/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.replicator.service;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.beigesoft.delegate.IDelegator;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.settings.IMngSettings;

public class SrvClearDatabase<RS>
implements IDelegator {
    private IMngSettings mngSettings;
    private ISrvDatabase<RS> srvDatabase;
    private ILogger logger;

    @Override
    public final void make(Map<String, Object> pAddParams) throws Exception {
        ArrayList classesArr = new ArrayList(this.mngSettings.getClasses());
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            this.logger.info(null, SrvClearDatabase.class, "Start clear database.");
            for (int i = classesArr.size() - 1; i >= 0; --i) {
                Class<?> entityClass = classesArr.get(i);
                this.srvDatabase.executeDelete(entityClass.getSimpleName().toUpperCase(), null);
            }
            this.srvDatabase.commitTransaction();
            Writer htmlWriter = (Writer)pAddParams.get("htmlWriter");
            if (htmlWriter != null) {
                htmlWriter.write("<h4>" + new Date().toString() + ", " + SrvClearDatabase.class.getSimpleName() + ", database has been cleared</h4>");
            }
            this.logger.info(null, SrvClearDatabase.class, "Finish clear database.");
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final IMngSettings getMngSettings() {
        return this.mngSettings;
    }

    public final void setMngSettings(IMngSettings pMngSettings) {
        this.mngSettings = pMngSettings;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

