/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.settings;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beigesoft.comparator.CmprEntryValueStringInt;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.properties.LinkedProperties;
import org.beigesoft.properties.UtlProperties;
import org.beigesoft.service.IUtlReflection;
import org.beigesoft.settings.IMngSettings;

public class MngSettings
implements IMngSettings {
    private ILogger logger;
    private IUtlReflection utlReflection;
    private UtlProperties utlProperties;
    private LinkedHashSet<Class<?>> classes;
    private Map<String, String> appSettings;
    private Map<Class<?>, Map<String, String>> classesSettings;
    private Map<Class<?>, Map<String, Map<String, String>>> fieldsSettings;
    private boolean isShowDebugMessages;

    @Override
    public final void loadConfiguration(String pDirName, String pFileName) throws Exception {
        this.isShowDebugMessages = this.logger.getIsShowDebugMessagesFor(this.getClass());
        String nameBaseXml = "/" + pDirName + "/" + pFileName;
        this.logger.info(null, MngSettings.class, "try to load: " + nameBaseXml);
        LinkedProperties props = this.utlProperties.loadPropertiesXml(nameBaseXml);
        if (props == null) {
            throw new ExceptionWithCode(1002, "There is no  base configuration file " + nameBaseXml);
        }
        this.retrieveAppSettings(pDirName, props);
        this.classes = new LinkedHashSet();
        String strClasses = props.getProperty("classes");
        if (strClasses == null) {
            throw new ExceptionWithCode(1002, "There is no property classes in base configuration file!");
        }
        this.logger.info(null, MngSettings.class, "classes: " + strClasses);
        LinkedHashSet<String> classesNames = this.utlProperties.evalPropsStringsSet(strClasses);
        for (String className : classesNames) {
            this.classes.add(Class.forName(className));
        }
        this.retrieveClasesSettings(pDirName, props);
        this.retrieveFieldsSettings(pDirName, props);
    }

    @Override
    public final List<Map.Entry<String, Map<String, String>>> sortRemoveIntVal(Set<Map.Entry<String, Map<String, String>>> pSetEntries, String pOrderKey) throws Exception {
        ArrayList<Map.Entry<String, Map<String, String>>> listEntries = new ArrayList<Map.Entry<String, Map<String, String>>>();
        for (Map.Entry<String, Map<String, String>> entry : pSetEntries) {
            Integer intVal = Integer.valueOf(entry.getValue().get(pOrderKey));
            if (intVal < 0) continue;
            listEntries.add(entry);
        }
        CmprEntryValueStringInt cmpr = new CmprEntryValueStringInt(pOrderKey);
        Collections.sort(listEntries, cmpr);
        return listEntries;
    }

    @Override
    public final List<Map.Entry<String, Map<String, String>>> makeFldPropLst(Class<?> pClass, String pOrderKey) throws Exception {
        Map<String, Map<String, String>> map = this.fieldsSettings.get(pClass);
        if (map == null) {
            throw new ExceptionWithCode(1002, "There is no entries of fields settings for " + pClass + " order key " + pOrderKey);
        }
        return this.sortRemoveIntVal(map.entrySet(), pOrderKey);
    }

    @Override
    public final Map<String, String> getAppSettings() {
        return this.appSettings;
    }

    @Override
    public final void setAppSettings(Map<String, String> pAppSettings) {
        this.appSettings = pAppSettings;
    }

    @Override
    public final LinkedHashSet<Class<?>> getClasses() {
        return this.classes;
    }

    @Override
    public final void setClasses(LinkedHashSet<Class<?>> pClasses) {
        this.classes = pClasses;
    }

    @Override
    public final Map<Class<?>, Map<String, String>> getClassesSettings() {
        return this.classesSettings;
    }

    @Override
    public final void setClassesSettings(Map<Class<?>, Map<String, String>> pClassSettings) {
        this.classesSettings = pClassSettings;
    }

    @Override
    public final Map<Class<?>, Map<String, Map<String, String>>> getFieldsSettings() {
        return this.fieldsSettings;
    }

    @Override
    public final void setFieldsSettings(Map<Class<?>, Map<String, Map<String, String>>> pFieldsSettings) {
        this.fieldsSettings = pFieldsSettings;
    }

    public final void retrieveAppSettings(String pDirName, LinkedProperties pProps) throws Exception {
        this.appSettings = new HashMap<String, String>();
        String subFolder = this.evalSubfolder(pProps);
        String nameAppStXml = "/" + pDirName + "/" + subFolder + "app-settings.xml";
        URL urlAppStXml = MngSettings.class.getResource(nameAppStXml);
        if (urlAppStXml != null) {
            LinkedProperties propAppStXml = this.utlProperties.loadPropertiesXml(nameAppStXml);
            for (String settingName : propAppStXml.stringPropertyNames()) {
                String settingVal = propAppStXml.getProperty(settingName);
                if (this.isShowDebugMessages) {
                    this.logger.debug(null, MngSettings.class, "add app setting: " + settingName + " - " + settingVal);
                }
                this.appSettings.put(settingName, settingVal);
            }
        }
    }

    public final void retrieveClasesSettings(String pDirName, LinkedProperties pProps) throws Exception {
        this.classesSettings = new HashMap();
        HashMap<String, LinkedProperties> javaTypeToStMap = new HashMap<String, LinkedProperties>();
        String subFolder = this.evalSubfolder(pProps);
        String strClasses = pProps.getProperty("settingsKeysForClasses");
        if (strClasses == null) {
            throw new ExceptionWithCode(1002, "There is no property settingsKeysForClasses in base configuration file!");
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, MngSettings.class, "classes settings keys: " + strClasses);
        }
        LinkedHashSet<String> settingsNames = this.utlProperties.evalPropsStringsSet(strClasses);
        for (String string : settingsNames) {
            LinkedProperties propJaTyToCs = this.utlProperties.loadPropertiesXml("/" + pDirName + "/" + subFolder + "classTypeToCs" + "/" + string + ".xml");
            if (propJaTyToCs == null) continue;
            if (this.isShowDebugMessages) {
                this.logger.debug(null, MngSettings.class, "add class setting file: " + string + " in " + "classTypeToCs");
            }
            javaTypeToStMap.put(string, propJaTyToCs);
        }
        for (Class clazz : this.classes) {
            HashMap<String, String> classSettings = new HashMap<String, String>();
            LinkedProperties propsClassToSetting = this.utlProperties.loadPropertiesXml("/" + pDirName + "/" + subFolder + "forClassToCs" + "/" + clazz.getSimpleName() + ".xml");
            if (propsClassToSetting != null && this.isShowDebugMessages) {
                this.logger.debug(null, MngSettings.class, "add class setting file: " + clazz.getSimpleName() + " in " + "forClassToCs");
            }
            for (String settingName : settingsNames) {
                LinkedProperties jaTyToCsProp;
                if (propsClassToSetting != null) {
                    this.putValueIfExist(propsClassToSetting, settingName, settingName, classSettings, clazz.getSimpleName());
                }
                if (classSettings.containsKey(settingName) || (jaTyToCsProp = (LinkedProperties)javaTypeToStMap.get(settingName)) == null) continue;
                this.putValueIfExistByType(jaTyToCsProp, clazz, settingName, classSettings, clazz.getSimpleName());
            }
            this.classesSettings.put(clazz, classSettings);
        }
    }

    public final void putValueIfExistByType(LinkedProperties pProps, Class<?> pClazzKey, String pSettingName, Map<String, String> pSettings, String pDebugMsg) throws Exception {
        if (!this.putValueIfExist(pProps, pClazzKey.getCanonicalName(), pSettingName, pSettings, pDebugMsg)) {
            for (String javaTypeName : pProps.getOrderedKeys()) {
                Class<?> javaTypeClass = Class.forName(javaTypeName);
                if (!javaTypeClass.isAssignableFrom(pClazzKey)) continue;
                String settingVal = this.utlProperties.evalPropVal(pProps, javaTypeName);
                if (this.isShowDebugMessages) {
                    this.logger.debug(null, MngSettings.class, pDebugMsg + " add setting by type : " + pSettingName + " - " + settingVal);
                }
                pSettings.put(pSettingName, settingVal);
            }
        }
    }

    public final boolean putValueIfExist(LinkedProperties pProps, String pPropKey, String pSettingName, Map<String, String> pSettings, String pDebugMsg) {
        String settingValue = pProps.getProperty(pPropKey);
        if (settingValue != null) {
            if (this.utlProperties.constNull().equals(settingValue)) {
                settingValue = null;
            }
            if (this.isShowDebugMessages) {
                this.logger.debug(null, MngSettings.class, pDebugMsg + " add setting : " + pSettingName + " - " + settingValue);
            }
            pSettings.put(pSettingName, settingValue);
            return true;
        }
        return false;
    }

    public final String evalSubfolder(LinkedProperties pProps) {
        String subFolder = this.utlProperties.evalPropVal(pProps, "useSubFolder");
        subFolder = subFolder == null ? "" : subFolder + "/";
        return subFolder;
    }

    public final void retrieveFieldsSettings(String pDirName, LinkedProperties pProps) throws Exception {
        String strFields;
        this.fieldsSettings = new HashMap();
        String subFolder = this.evalSubfolder(pProps);
        HashMap<String, LinkedProperties> javaTypeToStMap = new HashMap<String, LinkedProperties>();
        HashMap<String, LinkedProperties> fieldNameToStMap = new HashMap<String, LinkedProperties>();
        HashMap<String, LinkedProperties> fldNmJaTyToFsMap = new HashMap<String, LinkedProperties>();
        HashMap<String, LinkedProperties> fldNmClassTyToFsMap = new HashMap<String, LinkedProperties>();
        String excludedFieldsStr = pProps.getProperty("excludeFields");
        LinkedHashSet<String> excludedFields = null;
        if (excludedFieldsStr != null) {
            excludedFields = this.utlProperties.evalPropsStringsSet(excludedFieldsStr);
        }
        if ((strFields = pProps.getProperty("settingsKeysForFields")) == null) {
            throw new ExceptionWithCode(1002, "There is no property settingsKeysForFields in base configuration file!");
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, MngSettings.class, "fields settings keys: " + strFields);
        }
        LinkedHashSet<String> settingsNames = this.utlProperties.evalPropsStringsSet(strFields);
        for (String string : settingsNames) {
            LinkedProperties propFldNmToSt;
            LinkedProperties propJaTyToSt = this.utlProperties.loadPropertiesXml("/" + pDirName + "/" + subFolder + "fieldTypeToFs" + "/" + string + ".xml");
            if (propJaTyToSt != null) {
                if (this.isShowDebugMessages) {
                    this.logger.debug(null, MngSettings.class, "add field setting file: " + string + " in " + "fieldTypeToFs");
                }
                javaTypeToStMap.put(string, propJaTyToSt);
            }
            if ((propFldNmToSt = this.utlProperties.loadPropertiesXml("/" + pDirName + "/" + subFolder + "fieldNameToFs" + "/" + string + ".xml")) == null) continue;
            if (this.isShowDebugMessages) {
                this.logger.debug(null, MngSettings.class, "add field setting file: " + string + " in " + "fieldNameToFs");
            }
            fieldNameToStMap.put(string, propFldNmToSt);
        }
        for (Class clazz : this.classes) {
            HashMap<String, HashMap<String, String>> fieldsDescriptor = new HashMap<String, HashMap<String, String>>();
            LinkedProperties propsClassToSetting = this.utlProperties.loadPropertiesXml("/" + pDirName + "/" + subFolder + "forClassToFs" + "/" + clazz.getSimpleName() + ".xml");
            Field[] fields = this.getUtlReflection().retrieveFields(clazz);
            if (propsClassToSetting != null && this.isShowDebugMessages) {
                this.logger.debug(null, MngSettings.class, "add field setting file: " + clazz.getSimpleName() + " in " + "forClassToFs");
            }
            for (Field field : fields) {
                String strExldFldForClass = this.getClassesSettings().get(clazz).get("excludeFields");
                if (Collection.class.isAssignableFrom(field.getType()) || strExldFldForClass != null && strExldFldForClass.contains(field.getName()) || excludedFields != null && excludedFields.contains(field.getName())) continue;
                HashMap<String, String> fldSettings = new HashMap<String, String>();
                for (String settingName : settingsNames) {
                    LinkedProperties propFldNmToFs;
                    if (propsClassToSetting != null) {
                        this.putValueIfExist(propsClassToSetting, field.getName() + settingName, settingName, fldSettings, "final for " + clazz.getSimpleName() + "->" + field.getName());
                    }
                    if (fldSettings.containsKey(settingName)) continue;
                    LinkedProperties propJaTyToFs = (LinkedProperties)javaTypeToStMap.get(settingName);
                    if (propJaTyToFs != null) {
                        Class<?> fieldType = field.getType();
                        this.putValueIfExistByType(propJaTyToFs, fieldType, settingName, fldSettings, "1st for " + clazz.getSimpleName() + "->" + field.getName());
                    }
                    if ((propFldNmToFs = (LinkedProperties)fieldNameToStMap.get(settingName)) != null) {
                        this.putValueIfExist(propFldNmToFs, field.getName(), settingName, fldSettings, "2nd for " + clazz.getSimpleName() + "->" + field.getName());
                    }
                    String nmFlJavaTypeToFs = "/" + pDirName + "/" + subFolder + "fieldNameFieldTypeToFs" + "/" + field.getName() + settingName + ".xml";
                    LinkedProperties propFldNmJaTyToFs = this.evalProps(fldNmJaTyToFsMap, field.getName() + settingName, nmFlJavaTypeToFs);
                    if (propFldNmJaTyToFs != null) {
                        Class<?> fieldType = field.getType();
                        this.putValueIfExistByType(propFldNmJaTyToFs, fieldType, settingName, fldSettings, "3d for " + clazz.getSimpleName() + "->" + field.getName());
                    }
                    String nmFlClassTypeToFs = "/" + pDirName + "/" + subFolder + "fieldNameClassTypeToFs" + "/" + field.getName() + settingName + ".xml";
                    LinkedProperties propFldNmClassTyToFs = this.evalProps(fldNmClassTyToFsMap, field.getName() + settingName, nmFlClassTypeToFs);
                    if (propFldNmClassTyToFs == null) continue;
                    this.putValueIfExistByType(propFldNmClassTyToFs, clazz, settingName, fldSettings, "4th for " + clazz.getSimpleName() + "->" + field.getName());
                }
                if (Enum.class.isAssignableFrom(field.getType())) {
                    StringBuffer sbEnumVals = new StringBuffer();
                    boolean isFirst = true;
                    for (Object enm : field.getType().getEnumConstants()) {
                        if (!isFirst) {
                            sbEnumVals.append(",");
                        } else {
                            isFirst = false;
                        }
                        sbEnumVals.append(enm.toString());
                    }
                    fldSettings.put("enumValues", sbEnumVals.toString());
                }
                fieldsDescriptor.put(field.getName(), fldSettings);
            }
            this.fieldsSettings.put(clazz, fieldsDescriptor);
        }
    }

    public final LinkedProperties evalProps(Map<String, LinkedProperties> propsMap, String pKey, String pFileName) throws Exception {
        LinkedProperties result = propsMap.get(pKey);
        if (result == null && (result = this.utlProperties.loadPropertiesXml(pFileName)) != null) {
            if (this.isShowDebugMessages) {
                this.logger.debug(null, MngSettings.class, "added setting file: " + pFileName);
            }
            propsMap.put(pKey, result);
        }
        return result;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final IUtlReflection getUtlReflection() {
        return this.utlReflection;
    }

    public final void setUtlReflection(IUtlReflection pUtlReflection) {
        this.utlReflection = pUtlReflection;
    }

    public final UtlProperties getUtlProperties() {
        return this.utlProperties;
    }

    public final void setUtlProperties(UtlProperties pUtlProperties) {
        this.utlProperties = pUtlProperties;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

