/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingHmtx;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerHmtx
implements ITableMaker<TableForEmbeddingHmtx> {
    private ILogger logger;
    private boolean isShowDebugMessages;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingHmtx pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        int i;
        int numGlyphs = pUsedCids.get(pUsedCids.size() - 1).charValue() + '\u0001';
        pTde.setOffset(pOs.getSize());
        int widthsLen = Math.min(numGlyphs, pTfe.getTtf().getHhea().getNumOfLongHorMetrics());
        char chz = '\u0000';
        short shz = 0;
        for (i = 0; i < widthsLen; ++i) {
            if (pGls.get(i) != null) {
                pOs.writeUInt16(pTfe.getTtf().getHmtx().getWidths()[i], pTde, pCurrLongChksum);
                pOs.writeSInt16(pTfe.getTtf().getHmtx().getLeftSideBearing()[i], pTde, pCurrLongChksum);
                continue;
            }
            pOs.writeUInt16(chz, pTde, pCurrLongChksum);
            pOs.writeSInt16(shz, pTde, pCurrLongChksum);
        }
        for (i = widthsLen; i < numGlyphs; ++i) {
            if (pGls.get(i) != null) {
                pOs.writeSInt16(pTfe.getTtf().getHmtx().getLeftSideBearingAdd()[i - widthsLen], pTde, pCurrLongChksum);
                continue;
            }
            pOs.writeSInt16(shz, pTde, pCurrLongChksum);
        }
        int mod4 = (int)pTde.getLength() % 4;
        if (mod4 != 0) {
            pOs.addZeroBytesToCheksum(4 - mod4, pTde, pCurrLongChksum);
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TableMakerHmtx.class, "hmtx added zeros to checksum " + (4 - mod4));
            }
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TableMakerHmtx.class, "Added hmtx checksum/offset/length " + pTde.getChecksum() + "/" + pTde.getOffset() + "/" + pTde.getLength());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

