/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.ttf.model.Glyph;
import org.beigesoft.ttf.model.TableForEmbeddingMaxp;
import org.beigesoft.ttf.model.TtfTableDirEntry;
import org.beigesoft.ttf.service.ITableMaker;
import org.beigesoft.ttf.service.TtfInputStream;
import org.beigesoft.ttf.service.TtfOutputStream;

public class TableMakerMaxp
implements ITableMaker<TableForEmbeddingMaxp> {
    private ILogger logger;
    private boolean isShowDebugMessages;

    @Override
    public final void makeTable(TtfInputStream pIs, TtfOutputStream pOs, TableForEmbeddingMaxp pTfe, TtfTableDirEntry pTde, long[] pCurrLongChksum, List<Character> pUsedCids, Map<Integer, Glyph> pGls) throws Exception {
        int numGlyphs = pUsedCids.get(pUsedCids.size() - 1).charValue() + '\u0001';
        pTde.setOffset(pOs.getSize());
        pTde.setLength(0L);
        pOs.writeByteArr(pTfe.getMaxp().getVersion(), pTde, pCurrLongChksum);
        pOs.writeUInt16(numGlyphs, pTde, pCurrLongChksum);
        pOs.writeByteArr(pTfe.getMaxp().getTail(), pTde, pCurrLongChksum);
        int mod4 = (int)pTde.getLength() % 4;
        if (mod4 != 0) {
            pOs.addZeroBytesToCheksum(4 - mod4, pTde, pCurrLongChksum);
            if (this.isShowDebugMessages) {
                this.logger.debug(null, TableMakerMaxp.class, "maxp added zeros to checksum " + (4 - mod4));
            }
        }
        if (this.isShowDebugMessages) {
            this.logger.debug(null, TableMakerMaxp.class, "Added maxp checksum/offset/length " + pTde.getChecksum() + "/" + pTde.getOffset() + "/" + pTde.getLength());
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsShowDebugMessages() {
        return this.isShowDebugMessages;
    }

    public final void setIsShowDebugMessages(boolean pIsShowDebugMessages) {
        this.isShowDebugMessages = pIsShowDebugMessages;
    }
}

