/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.io.IOException;
import org.beigesoft.ttf.service.ITtfInputStream;

public class TtfBufferInputStream
implements ITtfInputStream {
    private long currentOffset = 0L;
    private final long offsetData;
    private byte[] buffer;

    public TtfBufferInputStream(byte[] pBuffer, long pOffsetData) {
        this.buffer = pBuffer;
        this.offsetData = pOffsetData;
    }

    @Override
    public final int read() throws IOException {
        int byte1 = this.buffer[(int)this.currentOffset];
        ++this.currentOffset;
        return byte1 &= 0xFF;
    }

    @Override
    public final int read(byte[] pBuffer) throws IOException {
        if (this.currentOffset + (long)pBuffer.length > (long)(this.buffer.length - 1)) {
            throw new IOException("Cant copy array array len/offset/buffer len: " + pBuffer.length + "/" + this.currentOffset + "/" + this.buffer.length);
        }
        for (int i = 0; i < pBuffer.length; ++i) {
            pBuffer[i] = this.buffer[(int)this.currentOffset];
            ++this.currentOffset;
        }
        return pBuffer.length;
    }

    @Override
    public final int readUInt16() throws IOException {
        int byte1 = this.buffer[(int)this.currentOffset];
        byte1 &= 0xFF;
        ++this.currentOffset;
        int byte2 = this.buffer[(int)this.currentOffset];
        ++this.currentOffset;
        return (byte1 <<= 8) | (byte2 &= 0xFF);
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readUInt16();
    }

    @Override
    public final short readFWord() throws IOException {
        return this.readSInt16();
    }

    @Override
    public final int readUFWord() throws IOException {
        return this.readUInt16();
    }

    @Override
    public final short readSInt16() throws IOException {
        return (short)this.readUInt16();
    }

    @Override
    public final int readUInt8() throws IOException {
        return this.read();
    }

    @Override
    public final byte readByte() throws IOException {
        return (byte)this.readUInt8();
    }

    @Override
    public final float readFixed() throws IOException {
        float result = this.readSInt16();
        result = (float)((double)result + (double)this.readUInt16() / 65536.0);
        return result;
    }

    @Override
    public final long readUInt32() throws IOException {
        int byte1 = this.buffer[(int)this.currentOffset];
        byte1 &= 0xFF;
        ++this.currentOffset;
        int byte2 = this.buffer[(int)this.currentOffset];
        byte2 &= 0xFF;
        ++this.currentOffset;
        int byte3 = this.buffer[(int)this.currentOffset];
        byte3 &= 0xFF;
        ++this.currentOffset;
        int byte4 = this.buffer[(int)this.currentOffset];
        ++this.currentOffset;
        long lbyte1 = byte1;
        long lbyte2 = byte2 << 16;
        long lbyte3 = byte3 << 8;
        long lbyte4 = byte4 &= 0xFF;
        return (lbyte1 <<= 24) | lbyte2 | lbyte3 | lbyte4;
    }

    @Override
    public final byte[] readTag() throws IOException {
        int byte1 = this.buffer[(int)this.currentOffset];
        byte1 &= 0xFF;
        ++this.currentOffset;
        int byte2 = this.buffer[(int)this.currentOffset];
        byte2 &= 0xFF;
        ++this.currentOffset;
        int byte3 = this.buffer[(int)this.currentOffset];
        ++this.currentOffset;
        int byte4 = this.buffer[(int)this.currentOffset];
        ++this.currentOffset;
        byte[] result = new byte[]{(byte)byte1, (byte)byte2, (byte)(byte3 &= 0xFF), (byte)(byte4 &= 0xFF)};
        return result;
    }

    @Override
    public final int[] readUInt16Arr(int pCount) throws IOException {
        int[] result = new int[pCount];
        for (int i = 0; i < pCount; ++i) {
            result[i] = this.readUInt16();
        }
        return result;
    }

    @Override
    public final int[] readUInt8Arr(int pCount) throws IOException {
        int[] result = new int[pCount];
        for (int i = 0; i < pCount; ++i) {
            result[i] = this.readUInt8();
        }
        return result;
    }

    @Override
    public final long readLongDateTime() throws IOException {
        int byte1 = this.buffer[(int)this.currentOffset];
        byte1 &= 0xFF;
        ++this.currentOffset;
        int byte2 = this.buffer[(int)this.currentOffset];
        byte2 &= 0xFF;
        ++this.currentOffset;
        int byte3 = this.buffer[(int)this.currentOffset];
        byte3 &= 0xFF;
        ++this.currentOffset;
        int byte4 = this.buffer[(int)this.currentOffset];
        byte4 &= 0xFF;
        ++this.currentOffset;
        int byte5 = this.buffer[(int)this.currentOffset];
        byte5 &= 0xFF;
        ++this.currentOffset;
        int byte6 = this.buffer[(int)this.currentOffset];
        byte6 &= 0xFF;
        ++this.currentOffset;
        int byte7 = this.buffer[(int)this.currentOffset];
        byte7 &= 0xFF;
        ++this.currentOffset;
        int byte8 = this.buffer[(int)this.currentOffset];
        byte8 &= 0xFF;
        ++this.currentOffset;
        long lbyte1 = byte1;
        lbyte1 <<= 56;
        long lbyte2 = byte2;
        lbyte2 <<= 48;
        long lbyte3 = byte3;
        lbyte3 <<= 40;
        long lbyte4 = byte4;
        lbyte4 <<= 32;
        long lbyte5 = byte5;
        long lbyte6 = byte6;
        long lbyte7 = byte7;
        long lbyte8 = byte8;
        return lbyte1 | lbyte2 | lbyte3 | lbyte4 | (lbyte5 <<= 24) | (lbyte6 <<= 16) | (lbyte7 <<= 8) | lbyte8;
    }

    @Override
    public final void skip(int pCount) throws IOException {
        if (this.currentOffset + (long)pCount > (long)(this.buffer.length - 1)) {
            throw new IOException("Cant skip count/offset/buffer len: " + pCount + "/" + this.currentOffset + "/" + this.buffer.length);
        }
        this.currentOffset += (long)pCount;
    }

    @Override
    public final void goAhead(long pOffset) throws IOException {
        if (this.offsetData + this.currentOffset > pOffset) {
            throw new IOException("This offset has passed already requested/current: " + pOffset + "/" + (this.offsetData + this.currentOffset));
        }
        if (pOffset - this.offsetData > (long)(this.buffer.length - 1)) {
            throw new IOException("Cant get to offsetTo/current/buffer len: " + pOffset + "/" + (this.offsetData + this.currentOffset) + "/" + this.buffer.length);
        }
        this.currentOffset = pOffset - this.offsetData;
    }

    @Override
    public final void close() throws IOException {
        this.currentOffset = 0L;
    }

    @Override
    public final long getOffset() {
        return this.offsetData + this.currentOffset;
    }

    public final void setCurrentOffset(long pCurrentOffset) {
        this.currentOffset = pCurrentOffset;
    }

    public final long getOffsetData() {
        return this.offsetData;
    }

    public final byte[] getBuffer() {
        return this.buffer;
    }
}

