/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ttf.service;

import java.io.IOException;
import java.io.InputStream;
import org.beigesoft.ttf.service.ITtfInputStream;

public class TtfInputStream
implements ITtfInputStream {
    private long currentOffset = 0L;
    private final InputStream inputStream;

    public TtfInputStream(InputStream pInputStream) {
        this.inputStream = pInputStream;
    }

    @Override
    public final int read() throws IOException {
        int byte1 = this.inputStream.read();
        ++this.currentOffset;
        return byte1;
    }

    @Override
    public final int read(byte[] pBuffer) throws IOException {
        int total = this.inputStream.read(pBuffer);
        if (total == -1) {
            throw new IOException("Cant read anything to array!");
        }
        if (total != pBuffer.length) {
            while (total != pBuffer.length) {
                int byte1 = this.inputStream.read();
                if (byte1 < 0) {
                    throw new IOException("Cant read full array! required/read/offsetStart: " + pBuffer.length + "/" + total + "/" + this.currentOffset);
                }
                pBuffer[total] = (byte)byte1;
                ++total;
            }
        }
        this.currentOffset += (long)total;
        return total;
    }

    @Override
    public final int readUInt16() throws IOException {
        int byte1 = this.inputStream.read();
        int byte2 = this.inputStream.read();
        this.currentOffset += 2L;
        return (byte1 <<= 8) | byte2;
    }

    @Override
    public final char readChar() throws IOException {
        return (char)this.readUInt16();
    }

    @Override
    public final short readFWord() throws IOException {
        return this.readSInt16();
    }

    @Override
    public final int readUFWord() throws IOException {
        return this.readUInt16();
    }

    @Override
    public final short readSInt16() throws IOException {
        return (short)this.readUInt16();
    }

    @Override
    public final int readUInt8() throws IOException {
        return this.read();
    }

    @Override
    public final byte readByte() throws IOException {
        return (byte)this.readUInt8();
    }

    @Override
    public final float readFixed() throws IOException {
        float result = this.readSInt16();
        result = (float)((double)result + (double)this.readUInt16() / 65536.0);
        return result;
    }

    @Override
    public final long readUInt32() throws IOException {
        int byte1 = this.inputStream.read();
        int byte2 = this.inputStream.read();
        int byte3 = this.inputStream.read();
        int byte4 = this.inputStream.read();
        long lbyte1 = byte1;
        long lbyte2 = byte2 << 16;
        long lbyte3 = byte3 << 8;
        long lbyte4 = byte4;
        this.currentOffset += 4L;
        return (lbyte1 <<= 24) | lbyte2 | lbyte3 | lbyte4;
    }

    @Override
    public final byte[] readTag() throws IOException {
        int byte1 = this.inputStream.read();
        int byte2 = this.inputStream.read();
        int byte3 = this.inputStream.read();
        int byte4 = this.inputStream.read();
        byte[] result = new byte[]{(byte)byte1, (byte)byte2, (byte)byte3, (byte)byte4};
        this.currentOffset += 4L;
        return result;
    }

    @Override
    public final int[] readUInt16Arr(int pCount) throws IOException {
        int[] result = new int[pCount];
        for (int i = 0; i < pCount; ++i) {
            result[i] = this.readUInt16();
        }
        return result;
    }

    @Override
    public final int[] readUInt8Arr(int pCount) throws IOException {
        int[] result = new int[pCount];
        for (int i = 0; i < pCount; ++i) {
            result[i] = this.readUInt8();
        }
        return result;
    }

    @Override
    public final long readLongDateTime() throws IOException {
        int byte1 = this.inputStream.read();
        int byte2 = this.inputStream.read();
        int byte3 = this.inputStream.read();
        int byte4 = this.inputStream.read();
        int byte5 = this.inputStream.read();
        int byte6 = this.inputStream.read();
        int byte7 = this.inputStream.read();
        int byte8 = this.inputStream.read();
        long lbyte1 = byte1;
        lbyte1 <<= 56;
        long lbyte2 = byte2;
        lbyte2 <<= 48;
        long lbyte3 = byte3;
        lbyte3 <<= 40;
        long lbyte4 = byte4;
        lbyte4 <<= 32;
        long lbyte5 = byte5;
        long lbyte6 = byte6;
        long lbyte7 = byte7;
        long lbyte8 = byte8;
        this.currentOffset += 8L;
        return lbyte1 | lbyte2 | lbyte3 | lbyte4 | (lbyte5 <<= 24) | (lbyte6 <<= 16) | (lbyte7 <<= 8) | lbyte8;
    }

    @Override
    public final void skip(int pCount) throws IOException {
        for (int i = 0; i < pCount; ++i) {
            int byte1 = this.inputStream.read();
            if (byte1 == -1) {
                throw new IOException("Cant get to offsetTo/current: " + pCount + "/" + this.currentOffset);
            }
            ++this.currentOffset;
        }
    }

    @Override
    public final void goAhead(long pOffset) throws IOException {
        if (this.currentOffset > pOffset) {
            throw new IOException("This offset has passed already requested/current: " + pOffset + "/" + this.currentOffset);
        }
        while (this.currentOffset < pOffset) {
            int rez = this.inputStream.read();
            if (rez == -1) {
                throw new IOException("Cant get to offsetTo/current: " + pOffset + "/" + this.currentOffset);
            }
            ++this.currentOffset;
        }
    }

    @Override
    public final void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public final long getOffset() {
        return this.currentOffset;
    }

    public final InputStream getInputStream() {
        return this.inputStream;
    }
}

