/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.web.listener;

import com.zaxxer.hikari.HikariDataSource;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.log.ILogger;

public class WebContextCleaner
implements ServletContextListener {
    @Override
    public final void contextDestroyed(ServletContextEvent sce) {
        try {
            IFactoryAppBeans factoryAppBeans = (IFactoryAppBeans)sce.getServletContext().getAttribute("IFactoryAppBeans");
            if (factoryAppBeans != null) {
                HikariDataSource ds = (HikariDataSource)factoryAppBeans.lazyGet("DataSource");
                ILogger logger = (ILogger)factoryAppBeans.lazyGet("ILogger");
                logger.info(null, WebContextCleaner.class, "Try to shutdown HikariDataSource and release app-beans...");
                if (ds != null) {
                    ds.close();
                    logger.info(null, WebContextCleaner.class, "HikariDataSource is shutdown!");
                } else {
                    logger.info(null, WebContextCleaner.class, "HikariDataSource was NULL!!!");
                }
                factoryAppBeans.releaseBeans();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void contextInitialized(ServletContextEvent sce) {
    }
}

