/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvEntitiesPage;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.persistable.CatalogGs;
import org.beigesoft.webstore.persistable.GoodsCatalogs;
import org.beigesoft.webstore.service.ISrvTradingSettings;

public class PrcAssignGoodsToCatalog<RS>
implements IProcessor {
    private ISrvOrm<RS> srvOrm;
    private ISrvEntitiesPage srvEntitiesPage;
    private ISrvTradingSettings srvTradingSettings;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        HashSet filterAppearance = new HashSet();
        pAddParam.put("filterAppearance", filterAppearance);
        this.srvEntitiesPage.revealPageFilterData(pAddParam, pRequestData, InvItem.class);
        StringBuffer sbWhere = (StringBuffer)pAddParam.get("sbWhere");
        if (sbWhere.length() == 0) {
            throw new ExceptionWithCode(1003, "filter_must_be_not_empty");
        }
        String goodsCatalogAction = pRequestData.getParameter("goodsCatalogAction");
        if (!"add".equals(goodsCatalogAction) && !"remove".equals(goodsCatalogAction)) {
            throw new ExceptionWithCode(1003, "wrong_action");
        }
        Long catalogId = Long.valueOf(pRequestData.getParameter(CatalogGs.class.getSimpleName() + ".itsId"));
        if (catalogId == null) {
            throw new ExceptionWithCode(1003, "catalog_must_be_not_empty");
        }
        CatalogGs catalogOfGoods = this.srvOrm.retrieveEntityById(pAddParam, CatalogGs.class, catalogId);
        if (catalogOfGoods == null) {
            throw new ExceptionWithCode(1003, "catalog_must_be_not_empty");
        }
        if (catalogOfGoods.getHasSubcatalogs().booleanValue()) {
            throw new ExceptionWithCode(1003, "catalog_must_not_has_subcatalog");
        }
        String whereStr = sbWhere.toString();
        Integer rowCount = this.srvOrm.evalRowCountWhere(pAddParam, InvItem.class, whereStr);
        if (rowCount > this.srvTradingSettings.lazyGetTradingSettings(pAddParam).getMaxQuantityOfBulkItems()) {
            throw new ExceptionWithCode(1001, "filtered_list_size_exceed_max_bulk");
        }
        Integer totalItems = Integer.valueOf(pRequestData.getParameter("totalItems"));
        if (!rowCount.equals(totalItems)) {
            throw new ExceptionWithCode(1001, "filtered_list_has_changed");
        }
        List<InvItem> goodsList = this.srvOrm.retrieveListWithConditions(pAddParam, InvItem.class, "where " + whereStr);
        for (InvItem goods : goodsList) {
            GoodsCatalogs gc = new GoodsCatalogs();
            gc.setItsCatalog(catalogOfGoods);
            gc.setGoods(goods);
            if ("add".equals(goodsCatalogAction)) {
                this.srvOrm.insertEntity(pAddParam, gc);
                continue;
            }
            this.srvOrm.deleteEntity(pAddParam, gc);
        }
        pRequestData.setAttribute("goodsCatalogAction", goodsCatalogAction);
        pRequestData.setAttribute("filterAppearance", filterAppearance);
        pRequestData.setAttribute("totalItems", totalItems);
        pRequestData.setAttribute("goodsList", goodsList);
        pRequestData.setAttribute("catalogOfGoods", catalogOfGoods);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvEntitiesPage getSrvEntitiesPage() {
        return this.srvEntitiesPage;
    }

    public final void setSrvEntitiesPage(ISrvEntitiesPage pSrvEntitiesPage) {
        this.srvEntitiesPage = pSrvEntitiesPage;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }
}

