/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.ESpecificsItemType;
import org.beigesoft.webstore.persistable.CartItem;
import org.beigesoft.webstore.persistable.GoodsAvailable;
import org.beigesoft.webstore.persistable.GoodsPrice;
import org.beigesoft.webstore.persistable.GoodsSpecific;
import org.beigesoft.webstore.persistable.ShoppingCart;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvShoppingCart;
import org.beigesoft.webstore.service.ISrvTradingSettings;

public class PrcDetailPage<RS>
implements IProcessor {
    private ILogger logger;
    private ISrvOrm<RS> srvOrm;
    private ISrvTradingSettings srvTradingSettings;
    private ISrvShoppingCart srvShoppingCart;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        String itemTypeStr = pRequestData.getParameter("itemType");
        if (!EShopItemType.GOODS.toString().equals(itemTypeStr)) {
            throw new Exception("Detail page not yet implemented for item type: " + itemTypeStr);
        }
        this.processInvItem(pAddParam, pRequestData);
    }

    public final void processInvItem(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        ShoppingCart shoppingCart;
        Long itemId = Long.valueOf(pRequestData.getParameter("itemId"));
        List<GoodsSpecific> gsList = this.retrieveGoodsSpecifics(pAddParam, itemId);
        int miIdx = -1;
        for (int i = 0; i < gsList.size(); ++i) {
            if (!gsList.get(i).getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) continue;
            pRequestData.setAttribute("gsMainImage", gsList.get(i));
            miIdx = i;
            break;
        }
        if (miIdx != -1) {
            gsList.remove(miIdx);
        }
        GoodsPrice goodsPrice = this.retrieveGoodsPrice(pAddParam, itemId);
        List<GoodsAvailable> gaList = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsAvailable.class, " where goods=" + itemId);
        if (pRequestData.getAttribute("shoppingCart") == null && (shoppingCart = this.srvShoppingCart.getShoppingCart(pAddParam, pRequestData, false)) != null) {
            pRequestData.setAttribute("shoppingCart", shoppingCart);
        }
        if (pRequestData.getAttribute("shoppingCart") != null && (shoppingCart = (ShoppingCart)pRequestData.getAttribute("shoppingCart")).getItsItems() != null) {
            String itemTypeStr = pRequestData.getParameter("itemType");
            for (CartItem ci : shoppingCart.getItsItems()) {
                if (ci.getIsDisabled().booleanValue() || !ci.getItemId().equals(itemId) || !ci.getItemType().toString().equals(itemTypeStr)) continue;
                pRequestData.setAttribute("cartItem", ci);
                break;
            }
        }
        pRequestData.setAttribute("gsList", gsList);
        pRequestData.setAttribute("gaList", gaList);
        pRequestData.setAttribute("goodsPrice", goodsPrice);
    }

    public final GoodsPrice retrieveGoodsPrice(Map<String, Object> pAddParam, Long pItemId) throws Exception {
        TradingSettings ts = this.srvTradingSettings.lazyGetTradingSettings(pAddParam);
        if (ts.getIsUsePriceForCustomer().booleanValue()) {
            throw new Exception("Method price depends of customer's category not yet implemented!");
        }
        List<GoodsPrice> lst = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsPrice.class, " where goods=" + pItemId);
        if (lst.size() == 1) {
            return lst.get(0);
        }
        String itemName = lst.size() > 0 ? lst.get(0).getGoods().getItsName() : "?";
        this.logger.error(null, PrcDetailPage.class, "It must be only goods price for goods: ID/Name/prices count" + pItemId + "/" + itemName + "/" + lst.size());
        return null;
    }

    public final List<GoodsSpecific> retrieveGoodsSpecifics(Map<String, Object> pAddParam, Long pItemId) throws Exception {
        pAddParam.put("GoodsSpecificspecificsdeepLevel", 4);
        HashSet<String> goodsFldNms = new HashSet<String>();
        goodsFldNms.add("itsId");
        goodsFldNms.add("itsName");
        pAddParam.put("InvItemneededFields", goodsFldNms);
        HashSet<String> soiFldNms = new HashSet<String>();
        soiFldNms.add("itsId");
        soiFldNms.add("itsName");
        soiFldNms.add("isShowInList");
        soiFldNms.add("itsType");
        soiFldNms.add("itsGroop");
        soiFldNms.add("chooseableSpecificsType");
        pAddParam.put("SpecificsOfItemneededFields", soiFldNms);
        HashSet<String> soigFldNms = new HashSet<String>();
        soigFldNms.add("itsId");
        soigFldNms.add("itsName");
        soigFldNms.add("templateStart");
        soigFldNms.add("templateEnd");
        soigFldNms.add("templateDetail");
        pAddParam.put("SpecificsOfItemGroupneededFields", soigFldNms);
        HashSet<String> chsptpFldNms = new HashSet<String>();
        chsptpFldNms.add("itsId");
        chsptpFldNms.add("htmlTemplate");
        pAddParam.put("ChooseableSpecificsTypeneededFields", chsptpFldNms);
        List<GoodsSpecific> result = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsSpecific.class, " where GOODSSPECIFIC.GOODS =" + pItemId + " order by SPECIFICS.ITSINDEX");
        pAddParam.remove("GoodsSpecificspecificsdeepLevel");
        pAddParam.remove("InvItemneededFields");
        pAddParam.remove("SpecificsOfItemneededFields");
        pAddParam.remove("SpecificsOfItemGroupneededFields");
        pAddParam.remove("ChooseableSpecificsTypeneededFields");
        return result;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }

    public final ISrvShoppingCart getSrvShoppingCart() {
        return this.srvShoppingCart;
    }

    public final void setSrvShoppingCart(ISrvShoppingCart pSrvShoppingCart) {
        this.srvShoppingCart = pSrvShoppingCart;
    }
}

