/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.persistable.BuyerPriceCategory;
import org.beigesoft.webstore.persistable.CartItem;
import org.beigesoft.webstore.persistable.GoodsPrice;
import org.beigesoft.webstore.persistable.GoodsPriceId;
import org.beigesoft.webstore.persistable.ShoppingCart;
import org.beigesoft.webstore.persistable.TradingSettings;
import org.beigesoft.webstore.service.ISrvShoppingCart;
import org.beigesoft.webstore.service.ISrvTradingSettings;

public class PrcItemInCart<RS>
implements IProcessor {
    private String queryCartTotals;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvAccSettings srvAccSettings;
    private ISrvTradingSettings srvTradingSettings;
    private ISrvShoppingCart srvShoppingCart;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        TradingSettings tradingSettings = this.getSrvTradingSettings().lazyGetTradingSettings(pAddParam);
        ShoppingCart shoppingCart = this.srvShoppingCart.getShoppingCart(pAddParam, pRequestData, true);
        CartItem cartItem = null;
        String cartItemItsIdStr = pRequestData.getParameter("cartItemItsId");
        String cartItemQuantityStr = pRequestData.getParameter("cartItemQuantity");
        String cartItemAvailableQuantityStr = pRequestData.getParameter("cartItemAvailableQuantity");
        BigDecimal cartItemQuantity = new BigDecimal(cartItemQuantityStr);
        BigDecimal cartItemAvailableQuantity = new BigDecimal(cartItemAvailableQuantityStr);
        String cartItemIdStr = pRequestData.getParameter("cartItemId");
        String cartItemTypeStr = pRequestData.getParameter("cartItemType");
        Long cartItemId = Long.valueOf(cartItemIdStr);
        EShopItemType cartItemType = ((EShopItemType[])EShopItemType.class.getEnumConstants())[Integer.parseInt(cartItemTypeStr)];
        if (cartItemItsIdStr != null) {
            Iterator<CartItem> cartItemItsId = Long.valueOf(cartItemItsIdStr);
            cartItem = this.findCartItemById(shoppingCart, (Long)((Object)cartItemItsId));
        } else {
            if (shoppingCart.getItsItems() == null) {
                shoppingCart.setItsItems(new ArrayList<CartItem>());
                cartItem = this.createCartItem(shoppingCart);
            } else {
                for (CartItem ci : shoppingCart.getItsItems()) {
                    if (ci.getIsDisabled().booleanValue() || !ci.getItemType().equals((Object)cartItemType) || !ci.getItemId().equals(cartItemId)) continue;
                    cartItem = ci;
                    break;
                }
                if (cartItem == null) {
                    for (CartItem ci : shoppingCart.getItsItems()) {
                        if (!ci.getIsDisabled().booleanValue()) continue;
                        cartItem = ci;
                        cartItem.setIsDisabled(false);
                        break;
                    }
                }
                if (cartItem == null) {
                    cartItem = this.createCartItem(shoppingCart);
                }
            }
            cartItem.setItemId(cartItemId);
            cartItem.setItemType(cartItemType);
            BigDecimal price = null;
            if (tradingSettings.getIsUsePriceForCustomer().booleanValue()) {
                List<BuyerPriceCategory> buyerPrCats = this.getSrvOrm().retrieveListWithConditions(pAddParam, BuyerPriceCategory.class, "where BUYER=" + shoppingCart.getBuyer().getItsId());
                for (BuyerPriceCategory buyerPrCat : buyerPrCats) {
                    if (!cartItemType.equals((Object)EShopItemType.GOODS)) continue;
                    InvItem goods = new InvItem();
                    goods.setItsId(cartItemId);
                    GoodsPriceId gpId = new GoodsPriceId();
                    gpId.setGoods(goods);
                    gpId.setPriceCategory(buyerPrCat.getPriceCategory());
                    GoodsPrice goodsPrice = new GoodsPrice();
                    goodsPrice.setItsId(gpId);
                    goodsPrice = this.getSrvOrm().retrieveEntity(pAddParam, goodsPrice);
                    if (goodsPrice == null) continue;
                    price = goodsPrice.getItsPrice();
                    cartItem.setItsName(goodsPrice.getGoods().getItsName());
                    break;
                }
            }
            if (price == null) {
                if (cartItemType.equals((Object)EShopItemType.GOODS)) {
                    List<GoodsPrice> goodsPrices = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsPrice.class, "where GOODS=" + cartItemId);
                    if (goodsPrices.size() == 0) {
                        throw new ExceptionWithCode(1001, "requested_item_has_no_price");
                    }
                    if (goodsPrices.size() > 1) {
                        throw new ExceptionWithCode(1001, "requested_item_has_several_prices");
                    }
                    price = goodsPrices.get(0).getItsPrice();
                    cartItem.setItsName(goodsPrices.get(0).getGoods().getItsName());
                } else {
                    throw new ExceptionWithCode(1000, "add_service_se_not_impl");
                }
            }
            cartItem.setItsPrice(price);
        }
        cartItem.setTotalTaxes(BigDecimal.ZERO);
        cartItem.setItsQuantity(cartItemQuantity);
        cartItem.setAvailableQuantity(cartItemAvailableQuantity);
        cartItem.setSubtotal(cartItem.getItsPrice().multiply(cartItem.getItsQuantity()));
        cartItem.setItsTotal(cartItem.getSubtotal().add(cartItem.getTotalTaxes()));
        if (cartItem.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, cartItem);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, cartItem);
        }
        String query = this.lazyGetQueryCartTotals();
        query = query.replace(":CARTID", shoppingCart.getItsId().getItsId().toString());
        String[] columns = new String[]{"ITSTOTAL", "TOTALITEMS"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        AccSettings accSettings = this.getSrvAccSettings().lazyGetAccSettings(pAddParam);
        shoppingCart.setItsTotal(BigDecimal.valueOf(totals[0]).setScale((int)accSettings.getPricePrecision(), accSettings.getRoundingMode()));
        shoppingCart.setTotalItems(totals[1].intValue());
        this.getSrvOrm().updateEntity(pAddParam, shoppingCart);
        pRequestData.setAttribute("shoppingCart", shoppingCart);
        String processorName = pRequestData.getParameter("nmPrcRedirect");
        IProcessor proc = this.processorsFactory.lazyGet(pAddParam, processorName);
        proc.process(pAddParam, pRequestData);
    }

    public final CartItem findCartItemById(ShoppingCart pShoppingCart, Long pCartItemItsId) throws Exception {
        CartItem cartItem = null;
        for (CartItem ci : pShoppingCart.getItsItems()) {
            if (!ci.getItsId().equals(pCartItemItsId)) continue;
            if (ci.getIsDisabled().booleanValue()) {
                throw new ExceptionWithCode(1001, "requested_item_disabled");
            }
            cartItem = ci;
            break;
        }
        if (cartItem == null) {
            throw new ExceptionWithCode(1001, "requested_item_not_found");
        }
        return cartItem;
    }

    public final CartItem createCartItem(ShoppingCart pShoppingCart) {
        CartItem cartItem = new CartItem();
        cartItem.setIsNew(true);
        cartItem.setIsDisabled(false);
        cartItem.setItsOwner(pShoppingCart);
        pShoppingCart.getItsItems().add(cartItem);
        return cartItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcItemInCart.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcItemInCart.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String lazyGetQueryCartTotals() throws Exception {
        if (this.queryCartTotals == null) {
            String flName = "/webstore/cartTotals.sql";
            this.queryCartTotals = this.loadString(flName);
        }
        return this.queryCartTotals;
    }

    public final void setQueryCartTotals(String pQueryCartTotals) {
        this.queryCartTotals = pQueryCartTotals;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvTradingSettings getSrvTradingSettings() {
        return this.srvTradingSettings;
    }

    public final void setSrvTradingSettings(ISrvTradingSettings pSrvTradingSettings) {
        this.srvTradingSettings = pSrvTradingSettings;
    }

    public final ISrvShoppingCart getSrvShoppingCart() {
        return this.srvShoppingCart;
    }

    public final void setSrvShoppingCart(ISrvShoppingCart pSrvShoppingCart) {
        this.srvShoppingCart = pSrvShoppingCart;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }
}

