/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.webstore.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.comparator.CmprHasVersion;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.webstore.model.EShopItemType;
import org.beigesoft.webstore.model.ESpecificsItemType;
import org.beigesoft.webstore.persistable.GoodsAvailable;
import org.beigesoft.webstore.persistable.GoodsInListLuv;
import org.beigesoft.webstore.persistable.GoodsPrice;
import org.beigesoft.webstore.persistable.GoodsSpecific;
import org.beigesoft.webstore.persistable.HtmlTemplate;
import org.beigesoft.webstore.persistable.ItemInList;
import org.beigesoft.webstore.persistable.SettingsAdd;
import org.beigesoft.webstore.persistable.SpecificsOfItemGroup;
import org.beigesoft.webstore.service.ISrvSettingsAdd;

public class PrcRefreshGoodsInList<RS>
implements IProcessor {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ISrvSettingsAdd srvSettingsAdd;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        this.retrieveStartData(pAddParam);
        SettingsAdd settingsAdd = (SettingsAdd)pAddParam.get("settingsAdd");
        pAddParam.remove("settingsAdd");
        GoodsInListLuv goodsInListLuv = (GoodsInListLuv)pAddParam.get("goodsInListLuv");
        pAddParam.remove("goodsInListLuv");
        List<GoodsSpecific> outdatedGoodsSpecific = this.retrieveOutdatedGoodsSpecific(pAddParam, goodsInListLuv);
        this.updateForGoodsSpecificList(pAddParam, outdatedGoodsSpecific, settingsAdd, goodsInListLuv);
        pRequestData.setAttribute("totalUpdatedGdSp", outdatedGoodsSpecific.size());
        List<GoodsPrice> outdatedGoodsPrice = this.retrieveOutdatedGoodsPrice(pAddParam, goodsInListLuv);
        this.updateForGoodsPriceList(pAddParam, outdatedGoodsPrice, settingsAdd, goodsInListLuv);
        pRequestData.setAttribute("totalUpdatedGdPr", outdatedGoodsPrice.size());
        List<GoodsAvailable> outdatedGoodsAvailable = this.retrieveOutdatedGoodsAvailable(pAddParam, goodsInListLuv);
        this.updateForGoodsAvailableList(pAddParam, outdatedGoodsAvailable, settingsAdd, goodsInListLuv);
        pRequestData.setAttribute("totalUpdatedGdAv", outdatedGoodsAvailable.size());
    }

    public final void retrieveStartData(Map<String, Object> pAddParam) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            SettingsAdd settingsAdd = this.getSrvSettingsAdd().lazyGetSettingsAdd(pAddParam);
            GoodsInListLuv goodsInListLuv = this.getSrvOrm().retrieveEntityById(pAddParam, GoodsInListLuv.class, 1L);
            if (goodsInListLuv == null) {
                goodsInListLuv = new GoodsInListLuv();
                goodsInListLuv.setItsId(1L);
                this.getSrvOrm().insertEntity(pAddParam, goodsInListLuv);
            }
            pAddParam.put("settingsAdd", settingsAdd);
            pAddParam.put("goodsInListLuv", goodsInListLuv);
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final List<GoodsAvailable> retrieveOutdatedGoodsAvailable(Map<String, Object> pAddParam, GoodsInListLuv pGoodsInListLuv) throws Exception {
        List<GoodsAvailable> result = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            String tblNm = GoodsAvailable.class.getSimpleName().toUpperCase();
            String verCond = pGoodsInListLuv.getGoodsAvailableLuv() != null ? " where " + tblNm + ".ITSVERSION>" + pGoodsInListLuv.getGoodsAvailableLuv().toString() : "";
            result = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsAvailable.class, verCond + " order by " + tblNm + ".ITSVERSION");
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        return result;
    }

    public final void updateForGoodsAvailable(Map<String, Object> pAddParam, GoodsAvailable pOutdGdAv) throws Exception {
        String whereStr = "where ITSTYPE=0 and ITEMID=" + pOutdGdAv.getGoods().getItsId();
        ItemInList itemInList = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, ItemInList.class, whereStr);
        if (itemInList == null) {
            itemInList = this.createItemInList(pAddParam, pOutdGdAv.getGoods());
        }
        itemInList.setAvailableQuantity(pOutdGdAv.getItsQuantity());
        if (itemInList.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, itemInList);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, itemInList);
        }
    }

    public final void updateForGoodsAvailableList(Map<String, Object> pAddParam, List<GoodsAvailable> pOutdGdAvList, SettingsAdd pSettingsAdd, GoodsInListLuv pGoodsInListLuv) throws Exception {
        if (pOutdGdAvList.size() == 0) {
            return;
        }
        int steps = pOutdGdAvList.size() / pSettingsAdd.getRecordsPerTransaction();
        int currentStep = 1;
        Long lastUpdatedVersion = null;
        do {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                int stepLen = Math.min(pOutdGdAvList.size(), currentStep * pSettingsAdd.getRecordsPerTransaction());
                for (int i = (currentStep - 1) * pSettingsAdd.getRecordsPerTransaction(); i < stepLen; ++i) {
                    GoodsAvailable goodsSpecific = pOutdGdAvList.get(i);
                    this.updateForGoodsAvailable(pAddParam, goodsSpecific);
                    lastUpdatedVersion = goodsSpecific.getItsVersion();
                }
                pGoodsInListLuv.setGoodsAvailableLuv(lastUpdatedVersion);
                this.getSrvOrm().updateEntity(pAddParam, pGoodsInListLuv);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        } while (currentStep++ < steps);
    }

    public final List<GoodsPrice> retrieveOutdatedGoodsPrice(Map<String, Object> pAddParam, GoodsInListLuv pGoodsInListLuv) throws Exception {
        List<GoodsPrice> result = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            String tblNm = GoodsPrice.class.getSimpleName().toUpperCase();
            String verCond = pGoodsInListLuv.getGoodsPriceLuv() != null ? " where " + tblNm + ".ITSVERSION>" + pGoodsInListLuv.getGoodsPriceLuv().toString() : "";
            result = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsPrice.class, verCond + " order by " + tblNm + ".ITSVERSION");
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        return result;
    }

    public final void updateForGoodsPrice(Map<String, Object> pAddParam, GoodsPrice pOutdGdPr) throws Exception {
        String whereStr = "where ITSTYPE=0 and ITEMID=" + pOutdGdPr.getGoods().getItsId();
        ItemInList itemInList = this.getSrvOrm().retrieveEntityWithConditions(pAddParam, ItemInList.class, whereStr);
        if (itemInList == null) {
            itemInList = this.createItemInList(pAddParam, pOutdGdPr.getGoods());
        }
        itemInList.setItsPrice(pOutdGdPr.getItsPrice());
        itemInList.setPreviousPrice(pOutdGdPr.getPreviousPrice());
        if (itemInList.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, itemInList);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, itemInList);
        }
    }

    public final void updateForGoodsPriceList(Map<String, Object> pAddParam, List<GoodsPrice> pOutdGdPrList, SettingsAdd pSettingsAdd, GoodsInListLuv pGoodsInListLuv) throws Exception {
        if (pOutdGdPrList.size() == 0) {
            return;
        }
        int steps = pOutdGdPrList.size() / pSettingsAdd.getRecordsPerTransaction();
        int currentStep = 1;
        Long lastUpdatedVersion = null;
        do {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                int stepLen = Math.min(pOutdGdPrList.size(), currentStep * pSettingsAdd.getRecordsPerTransaction());
                for (int i = (currentStep - 1) * pSettingsAdd.getRecordsPerTransaction(); i < stepLen; ++i) {
                    GoodsPrice goodsSpecific = pOutdGdPrList.get(i);
                    this.updateForGoodsPrice(pAddParam, goodsSpecific);
                    lastUpdatedVersion = goodsSpecific.getItsVersion();
                }
                pGoodsInListLuv.setGoodsPriceLuv(lastUpdatedVersion);
                this.getSrvOrm().updateEntity(pAddParam, pGoodsInListLuv);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        } while (currentStep++ < steps);
    }

    public final List<GoodsSpecific> retrieveOutdatedGoodsSpecific(Map<String, Object> pAddParam, GoodsInListLuv pGoodsInListLuv) throws Exception {
        List<GoodsSpecific> result = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            String verCondGs = "";
            if (pGoodsInListLuv.getGoodsSpecificLuv() != null) {
                verCondGs = " where GOODSSPECIFIC.GOODS in  (select distinct  GOODS from GOODSSPECIFIC join SPECIFICSOFITEM on GOODSSPECIFIC.SPECIFICS=SPECIFICSOFITEM.ITSID where GOODSSPECIFIC.ITSVERSION>" + pGoodsInListLuv.getGoodsSpecificLuv().toString() + ")";
            }
            pAddParam.put("GoodsSpecificspecificsdeepLevel", 3);
            HashSet<String> goodsFldNms = new HashSet<String>();
            goodsFldNms.add("itsId");
            goodsFldNms.add("itsName");
            pAddParam.put("InvItemneededFields", goodsFldNms);
            HashSet<String> soiFldNms = new HashSet<String>();
            soiFldNms.add("itsId");
            soiFldNms.add("itsName");
            soiFldNms.add("isShowInList");
            soiFldNms.add("itsType");
            soiFldNms.add("itsGroop");
            soiFldNms.add("chooseableSpecificsType");
            pAddParam.put("SpecificsOfItemneededFields", soiFldNms);
            HashSet<String> soigFldNms = new HashSet<String>();
            soigFldNms.add("itsId");
            soigFldNms.add("itsName");
            soigFldNms.add("templateStart");
            soigFldNms.add("templateEnd");
            soigFldNms.add("templateDetail");
            pAddParam.put("SpecificsOfItemGroupneededFields", soigFldNms);
            HashSet<String> chsptpFldNms = new HashSet<String>();
            chsptpFldNms.add("itsId");
            chsptpFldNms.add("htmlTemplate");
            pAddParam.put("ChooseableSpecificsTypeneededFields", chsptpFldNms);
            result = this.getSrvOrm().retrieveListWithConditions(pAddParam, GoodsSpecific.class, verCondGs + " order by GOODS.ITSID, SPECIFICS.ITSINDEX");
            pAddParam.remove("GoodsSpecificspecificsdeepLevel");
            pAddParam.remove("InvItemneededFields");
            pAddParam.remove("SpecificsOfItemneededFields");
            pAddParam.remove("SpecificsOfItemGroupneededFields");
            pAddParam.remove("ChooseableSpecificsTypeneededFields");
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        ArrayList<InvItem> goodsForSpecifics = new ArrayList<InvItem>();
        HashSet<Long> htmlTemplatesIds = new HashSet<Long>();
        InvItem currItem = null;
        for (GoodsSpecific gs : result) {
            if (gs.getSpecifics().getChooseableSpecificsType() != null && gs.getSpecifics().getChooseableSpecificsType().getHtmlTemplate() != null) {
                htmlTemplatesIds.add(gs.getSpecifics().getChooseableSpecificsType().getHtmlTemplate().getItsId());
            }
            if (gs.getSpecifics().getItsGroop() != null) {
                if (gs.getSpecifics().getItsGroop().getTemplateStart() != null) {
                    htmlTemplatesIds.add(gs.getSpecifics().getItsGroop().getTemplateStart().getItsId());
                }
                if (gs.getSpecifics().getItsGroop().getTemplateEnd() != null) {
                    htmlTemplatesIds.add(gs.getSpecifics().getItsGroop().getTemplateEnd().getItsId());
                }
                if (gs.getSpecifics().getItsGroop().getTemplateStart() != null) {
                    htmlTemplatesIds.add(gs.getSpecifics().getItsGroop().getTemplateDetail().getItsId());
                }
            }
            if (currItem == null || !gs.getGoods().getItsId().equals(currItem.getItsId())) {
                currItem = gs.getGoods();
                currItem.setItsVersion(gs.getItsVersion());
                goodsForSpecifics.add(currItem);
                continue;
            }
            if (currItem.getItsVersion() >= gs.getItsVersion()) continue;
            currItem.setItsVersion(gs.getItsVersion());
        }
        CmprHasVersion cmp = new CmprHasVersion();
        Collections.sort(goodsForSpecifics, cmp);
        pAddParam.put("goodsForSpecifics", goodsForSpecifics);
        pAddParam.put("htmlTemplatesIds", htmlTemplatesIds);
        return result;
    }

    public final void updateForGoodsSpecific(Map<String, Object> pAddParam, GoodsSpecific pOutdGdSp, ItemInList pItemInList, SpecificsOfItemGroup pSpecificsOfItemGroupWas) throws Exception {
        if ((pSpecificsOfItemGroupWas != null && pOutdGdSp.getSpecifics().getItsGroop() == null || pSpecificsOfItemGroupWas != null && pOutdGdSp.getSpecifics().getItsGroop() != null && !pOutdGdSp.getSpecifics().getItsGroop().getItsId().equals(pSpecificsOfItemGroupWas.getItsId())) && pSpecificsOfItemGroupWas.getTemplateStart() != null) {
            pItemInList.setSpecificInList(pItemInList.getSpecificInList() + pSpecificsOfItemGroupWas.getTemplateEnd().getHtmlTemplate());
        }
        if ((pSpecificsOfItemGroupWas == null && pOutdGdSp.getSpecifics().getItsGroop() != null || pSpecificsOfItemGroupWas != null && pOutdGdSp.getSpecifics().getItsGroop() != null && !pOutdGdSp.getSpecifics().getItsGroop().getItsId().equals(pSpecificsOfItemGroupWas.getItsId())) && pOutdGdSp.getSpecifics().getItsGroop().getTemplateStart() != null) {
            if (pItemInList.getSpecificInList() == null) {
                pItemInList.setSpecificInList(pOutdGdSp.getSpecifics().getItsGroop().getTemplateStart().getHtmlTemplate());
            } else {
                pItemInList.setSpecificInList(pItemInList.getSpecificInList() + pOutdGdSp.getSpecifics().getItsGroop().getTemplateStart().getHtmlTemplate());
            }
        }
        String spNm = null;
        String spVal = null;
        String spFull = null;
        if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.IMAGE)) {
            pItemInList.setImageUrl(pOutdGdSp.getStringValue1());
        } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.TEXT)) {
            spNm = pOutdGdSp.getSpecifics().getItsName();
            spVal = pOutdGdSp.getStringValue1();
        } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.BIGDECIMAL)) {
            spNm = pOutdGdSp.getSpecifics().getItsName();
            spVal = pOutdGdSp.getNumericValue1().toString();
            if (pOutdGdSp.getStringValue1() != null) {
                spVal = spVal + " " + pOutdGdSp.getStringValue1();
            }
        } else if (pOutdGdSp.getSpecifics().getItsType().equals((Object)ESpecificsItemType.INTEGER)) {
            spNm = pOutdGdSp.getSpecifics().getItsName();
            spVal = pOutdGdSp.getLongValue1().toString();
            if (pOutdGdSp.getStringValue1() != null) {
                spVal = spVal + " " + pOutdGdSp.getStringValue1();
            }
        } else if (pOutdGdSp.getSpecifics().getChooseableSpecificsType() != null) {
            if (pOutdGdSp.getSpecifics().getChooseableSpecificsType().getHtmlTemplate() != null) {
                spFull = pOutdGdSp.getSpecifics().getChooseableSpecificsType().getHtmlTemplate().getHtmlTemplate().replace(":VALUE1", pOutdGdSp.getStringValue2()).replace(":VALUE2", pOutdGdSp.getStringValue1());
            } else {
                spNm = pOutdGdSp.getStringValue2();
                spVal = pOutdGdSp.getStringValue1();
            }
        }
        if (spVal != null) {
            spFull = pOutdGdSp.getSpecifics().getItsGroop() != null && pOutdGdSp.getSpecifics().getItsGroop().getTemplateDetail() != null ? pOutdGdSp.getSpecifics().getItsGroop().getTemplateDetail().getHtmlTemplate().replace(":VALUE1", spNm).replace(":VALUE2", spVal) : "<b> " + spNm + ": </b>" + spVal + ".";
        }
        if (spFull != null) {
            if (pItemInList.getSpecificInList() == null) {
                pItemInList.setSpecificInList(spFull);
            } else {
                pItemInList.setSpecificInList(pItemInList.getSpecificInList() + spFull);
            }
        }
    }

    public final void updateForGoodsSpecificList(Map<String, Object> pAddParam, List<GoodsSpecific> pOutdGdSpList, SettingsAdd pSettingsAdd, GoodsInListLuv pGoodsInListLuv) throws Exception {
        if (pOutdGdSpList.size() == 0) {
            return;
        }
        List goodsForSpecifics = (List)pAddParam.get("goodsForSpecifics");
        pAddParam.remove("goodsForSpecifics");
        Set htmlTemplatesIds = (Set)pAddParam.get("htmlTemplatesIds");
        pAddParam.remove("htmlTemplatesIds");
        List<HtmlTemplate> htmlTemplates = null;
        List<ItemInList> itemsInList = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            StringBuffer whereStr = new StringBuffer("where ITSTYPE=0 and ITEMID in (");
            boolean isFirst = true;
            for (InvItem gd : goodsForSpecifics) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    whereStr.append(", ");
                }
                whereStr.append(gd.getItsId().toString());
            }
            whereStr.append(")");
            itemsInList = this.getSrvOrm().retrieveListWithConditions(pAddParam, ItemInList.class, whereStr.toString());
            if (htmlTemplatesIds.size() > 0) {
                whereStr = new StringBuffer("where ITSID in (");
                isFirst = true;
                for (Long id : htmlTemplatesIds) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        whereStr.append(", ");
                    }
                    whereStr.append(id.toString());
                }
                whereStr.append(")");
                htmlTemplates = this.getSrvOrm().retrieveListWithConditions(pAddParam, HtmlTemplate.class, whereStr.toString());
            }
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        if (htmlTemplates != null && htmlTemplates.size() > 0) {
            for (GoodsSpecific gs : pOutdGdSpList) {
                if (gs.getSpecifics().getChooseableSpecificsType() != null && gs.getSpecifics().getChooseableSpecificsType().getHtmlTemplate() != null) {
                    gs.getSpecifics().getChooseableSpecificsType().setHtmlTemplate(this.findTemplate(htmlTemplates, gs.getSpecifics().getChooseableSpecificsType().getHtmlTemplate().getItsId()));
                }
                if (gs.getSpecifics().getItsGroop() == null) continue;
                if (gs.getSpecifics().getItsGroop().getTemplateStart() != null) {
                    gs.getSpecifics().getItsGroop().setTemplateStart(this.findTemplate(htmlTemplates, gs.getSpecifics().getItsGroop().getTemplateStart().getItsId()));
                }
                if (gs.getSpecifics().getItsGroop().getTemplateEnd() != null) {
                    gs.getSpecifics().getItsGroop().setTemplateEnd(this.findTemplate(htmlTemplates, gs.getSpecifics().getItsGroop().getTemplateEnd().getItsId()));
                }
                if (gs.getSpecifics().getItsGroop().getTemplateStart() == null) continue;
                gs.getSpecifics().getItsGroop().setTemplateDetail(this.findTemplate(htmlTemplates, gs.getSpecifics().getItsGroop().getTemplateDetail().getItsId()));
            }
        }
        int steps = goodsForSpecifics.size() / pSettingsAdd.getRecordsPerTransaction();
        int currentStep = 1;
        Long lastUpdatedVersion = null;
        do {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                int stepLen = Math.min(goodsForSpecifics.size(), currentStep * pSettingsAdd.getRecordsPerTransaction());
                for (int i = (currentStep - 1) * pSettingsAdd.getRecordsPerTransaction(); i < stepLen; ++i) {
                    InvItem goods = (InvItem)goodsForSpecifics.get(i);
                    ItemInList itemInList = this.findItemInListFor(itemsInList, goods);
                    if (itemInList == null) {
                        itemInList = this.createItemInList(pAddParam, goods);
                    }
                    int j = this.findFirstIdxFor(pOutdGdSpList, goods);
                    SpecificsOfItemGroup specificsOfItemGroupWas = null;
                    itemInList.setDetailsMethod(null);
                    do {
                        if (pOutdGdSpList.get(j).getSpecifics().getIsShowInList().booleanValue()) {
                            this.updateForGoodsSpecific(pAddParam, pOutdGdSpList.get(j), itemInList, specificsOfItemGroupWas);
                            specificsOfItemGroupWas = pOutdGdSpList.get(j).getSpecifics().getItsGroop();
                            continue;
                        }
                        itemInList.setDetailsMethod(1);
                    } while (++j < pOutdGdSpList.size() && pOutdGdSpList.get(j).getGoods().getItsId().equals(goods.getItsId()));
                    if (itemInList.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pAddParam, itemInList);
                    } else {
                        this.getSrvOrm().updateEntity(pAddParam, itemInList);
                    }
                    lastUpdatedVersion = goods.getItsVersion();
                }
                pGoodsInListLuv.setGoodsSpecificLuv(lastUpdatedVersion);
                this.getSrvOrm().updateEntity(pAddParam, pGoodsInListLuv);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                if (!this.srvDatabase.getIsAutocommit()) {
                    this.srvDatabase.rollBackTransaction();
                }
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        } while (currentStep++ < steps);
    }

    protected final ItemInList findItemInListFor(List<ItemInList> pGoodsList, InvItem pGoods) {
        for (int j = 0; j < pGoodsList.size(); ++j) {
            if (!pGoodsList.get(j).getItemId().equals(pGoods.getItsId())) continue;
            return pGoodsList.get(j);
        }
        return null;
    }

    protected final int findFirstIdxFor(List<GoodsSpecific> pOutdGdSpList, InvItem pGoods) {
        int j = 0;
        while (!pOutdGdSpList.get(j).getGoods().getItsId().equals(pGoods.getItsId())) {
            ++j;
        }
        return j;
    }

    protected final HtmlTemplate findTemplate(List<HtmlTemplate> pHtmlTemplates, Long pId) throws Exception {
        for (HtmlTemplate tmpl : pHtmlTemplates) {
            if (!tmpl.getItsId().equals(pId)) continue;
            return tmpl;
        }
        throw new Exception("Algorithm error/or template deleted: template not found for ID" + pId);
    }

    protected final ItemInList createItemInList(Map<String, Object> pAddParam, InvItem pGoods) throws Exception {
        ItemInList itemInList = new ItemInList();
        itemInList.setIsNew(true);
        itemInList.setItsType(EShopItemType.GOODS);
        itemInList.setItemId(pGoods.getItsId());
        itemInList.setItsName(pGoods.getItsName());
        itemInList.setAvailableQuantity(BigDecimal.ZERO);
        return itemInList;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvSettingsAdd getSrvSettingsAdd() {
        return this.srvSettingsAdd;
    }

    public final void setSrvSettingsAdd(ISrvSettingsAdd pSrvSettingsAdd) {
        this.srvSettingsAdd = pSrvSettingsAdd;
    }
}

