/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.zlib;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.beigesoft.zlib.IZLibStreamer;

public class ZLibStreamer
implements IZLibStreamer {
    private int bufferSize = 1024;

    @Override
    public final void compress(Map<String, Object> pAddParam, InputStream pToCompress, OutputStream pCompressed) throws Exception {
        int mayRead = pToCompress.available();
        if (mayRead > 0) {
            byte[] buf = new byte[Math.min(mayRead, this.bufferSize)];
            DeflaterOutputStream dfos = new DeflaterOutputStream(pCompressed);
            int amountRead = pToCompress.read(buf);
            while (amountRead != -1) {
                dfos.write(buf, 0, amountRead);
                amountRead = pToCompress.read(buf);
            }
            dfos.flush();
            dfos.finish();
        }
    }

    @Override
    public final void decompress(Map<String, Object> pAddParam, InputStream pToDecompress, OutputStream pDecompressed) throws Exception {
        int mayRead = pToDecompress.available();
        if (mayRead > 0) {
            byte[] buf = new byte[Math.min(mayRead, this.bufferSize)];
            InflaterOutputStream ifos = new InflaterOutputStream(pDecompressed);
            int amountRead = pToDecompress.read(buf);
            while (amountRead != -1) {
                ifos.write(buf, 0, amountRead);
                amountRead = pToDecompress.read(buf);
            }
            ifos.flush();
            ifos.finish();
        }
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int pBufferSize) {
        this.bufferSize = pBufferSize;
    }
}

