/*
 * Decompiled with CFR 0.152.
 */
package ajava.beans;

import ajava.beans.BeanDescriptor;
import ajava.beans.BeanInfo;
import ajava.beans.EventSetDescriptor;
import ajava.beans.IndexedPropertyDescriptor;
import ajava.beans.MethodDescriptor;
import ajava.beans.PropertyDescriptor;
import ajava.beans.SimpleBeanInfo;
import ajava.beans.ThreadGroupContext;
import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

class GenericBeanInfo
extends SimpleBeanInfo {
    private BeanDescriptor beanDescriptor;
    private EventSetDescriptor[] events;
    private int defaultEvent;
    private PropertyDescriptor[] properties;
    private int defaultProperty;
    private MethodDescriptor[] methods;
    private Reference<BeanInfo> targetBeanInfoRef;

    public GenericBeanInfo(BeanDescriptor beanDescriptor, EventSetDescriptor[] events, int defaultEvent, PropertyDescriptor[] properties, int defaultProperty, MethodDescriptor[] methods, BeanInfo targetBeanInfo) {
        this.beanDescriptor = beanDescriptor;
        this.events = events;
        this.defaultEvent = defaultEvent;
        this.properties = properties;
        this.defaultProperty = defaultProperty;
        this.methods = methods;
        this.targetBeanInfoRef = targetBeanInfo != null ? new SoftReference<BeanInfo>(targetBeanInfo) : null;
    }

    GenericBeanInfo(GenericBeanInfo old) {
        int i;
        int len;
        this.beanDescriptor = new BeanDescriptor(old.beanDescriptor);
        if (old.events != null) {
            len = old.events.length;
            this.events = new EventSetDescriptor[len];
            for (i = 0; i < len; ++i) {
                this.events[i] = new EventSetDescriptor(old.events[i]);
            }
        }
        this.defaultEvent = old.defaultEvent;
        if (old.properties != null) {
            len = old.properties.length;
            this.properties = new PropertyDescriptor[len];
            for (i = 0; i < len; ++i) {
                PropertyDescriptor oldp = old.properties[i];
                this.properties[i] = oldp instanceof IndexedPropertyDescriptor ? new IndexedPropertyDescriptor((IndexedPropertyDescriptor)oldp) : new PropertyDescriptor(oldp);
            }
        }
        this.defaultProperty = old.defaultProperty;
        if (old.methods != null) {
            len = old.methods.length;
            this.methods = new MethodDescriptor[len];
            for (i = 0; i < len; ++i) {
                this.methods[i] = new MethodDescriptor(old.methods[i]);
            }
        }
        this.targetBeanInfoRef = old.targetBeanInfoRef;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.defaultProperty;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    @Override
    public int getDefaultEventIndex() {
        return this.defaultEvent;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public Image getIcon(int iconKind) {
        BeanInfo targetBeanInfo = this.getTargetBeanInfo();
        if (targetBeanInfo != null) {
            return targetBeanInfo.getIcon(iconKind);
        }
        return super.getIcon(iconKind);
    }

    private BeanInfo getTargetBeanInfo() {
        if (this.targetBeanInfoRef == null) {
            return null;
        }
        BeanInfo targetBeanInfo = this.targetBeanInfoRef.get();
        if (targetBeanInfo == null && (targetBeanInfo = (BeanInfo)ThreadGroupContext.getContext().getBeanInfoFinder().find(this.beanDescriptor.getBeanClass())) != null) {
            this.targetBeanInfoRef = new SoftReference<BeanInfo>(targetBeanInfo);
        }
        return targetBeanInfo;
    }
}

