/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.jasper.Constants;

public class ELContextImpl
extends ELContext {
    private static final FunctionMapper NullFunctionMapper = new FunctionMapper(){

        @Override
        public Method resolveFunction(String prefix, String localName) {
            return null;
        }
    };
    private static final ELResolver DefaultResolver;
    private final ELResolver resolver;
    private FunctionMapper functionMapper = NullFunctionMapper;
    private VariableMapper variableMapper;

    public ELContextImpl() {
        this(ELContextImpl.getDefaultResolver());
    }

    public ELContextImpl(ELResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public ELResolver getELResolver() {
        return this.resolver;
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    @Override
    public VariableMapper getVariableMapper() {
        if (this.variableMapper == null) {
            this.variableMapper = new VariableMapperImpl();
        }
        return this.variableMapper;
    }

    public void setFunctionMapper(FunctionMapper functionMapper) {
        this.functionMapper = functionMapper;
    }

    public void setVariableMapper(VariableMapper variableMapper) {
        this.variableMapper = variableMapper;
    }

    public static ELResolver getDefaultResolver() {
        if (Constants.IS_SECURITY_ENABLED) {
            CompositeELResolver defaultResolver = new CompositeELResolver();
            defaultResolver.add(new MapELResolver());
            defaultResolver.add(new ResourceBundleELResolver());
            defaultResolver.add(new ListELResolver());
            defaultResolver.add(new ArrayELResolver());
            defaultResolver.add(new BeanELResolver());
            return defaultResolver;
        }
        return DefaultResolver;
    }

    static {
        if (Constants.IS_SECURITY_ENABLED) {
            DefaultResolver = null;
        } else {
            DefaultResolver = new CompositeELResolver();
            ((CompositeELResolver)DefaultResolver).add(new MapELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ResourceBundleELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ListELResolver());
            ((CompositeELResolver)DefaultResolver).add(new ArrayELResolver());
            ((CompositeELResolver)DefaultResolver).add(new BeanELResolver());
        }
    }

    private static final class VariableMapperImpl
    extends VariableMapper {
        private Map<String, ValueExpression> vars;

        private VariableMapperImpl() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            if (this.vars == null) {
                return null;
            }
            return this.vars.get(variable);
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (this.vars == null) {
                this.vars = new HashMap<String, ValueExpression>();
            }
            return this.vars.put(variable, expression);
        }
    }
}

