/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccountingEntries;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.converter.IConverterToFromString;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDate;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.settings.IMngSettings;

public class PrcAccEntryCopy<RS>
implements IEntityProcessor<AccountingEntry, Long> {
    private ISrvOrm<RS> srvOrm;
    private IMngSettings mngUvdSettings;
    private ISrvDate srvDate;
    private IFactoryAppBeansByName<IConverterToFromString<?>> convertersFieldsFatory;
    private IHolderForClassByName<String> fieldConverterNamesHolder;
    private ISrvI18n srvI18n;
    private final Integer accountingEntriesTypeCode = new AccountingEntries().constTypeCode();

    @Override
    public final AccountingEntry process(Map<String, Object> pAddParam, AccountingEntry pEntity, IRequestData pRequestData) throws Exception {
        AccountingEntry entity = this.srvOrm.retrieveEntity(pAddParam, pEntity);
        AccountingEntries doc = this.getSrvOrm().retrieveEntityById(pAddParam, AccountingEntries.class, entity.getSourceId());
        if (!doc.getIdDatabaseBirth().equals(this.getSrvOrm().getIdDatabase())) {
            throw new ExceptionWithCode(1003, "can_not_make_entry_for_foreign_src");
        }
        entity.setIsNew(true);
        entity.setItsId(null);
        entity.setIdBirth(null);
        entity.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
        entity.setItsDate(new Date());
        entity.setSourceType(this.accountingEntriesTypeCode);
        String docDescription = doc.getDescription() != null ? doc.getDescription() : "";
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        entity.setDescription(this.getSrvI18n().getMsg(AccountingEntries.class.getSimpleName() + "short", langDef) + " #" + doc.getIdDatabaseBirth() + "-" + doc.getItsId() + ", " + dateFormat.format(doc.getItsDate()) + ". " + docDescription);
        entity.setIsNew(true);
        pRequestData.setAttribute("entity", entity);
        pRequestData.setAttribute("AccountingEntriesVersion", doc.getItsVersion());
        pRequestData.setAttribute("mngUvds", this.mngUvdSettings);
        pRequestData.setAttribute("srvOrm", this.srvOrm);
        pRequestData.setAttribute("srvDate", this.srvDate);
        pRequestData.setAttribute("hldCnvFtfsNames", this.fieldConverterNamesHolder);
        pRequestData.setAttribute("fctCnvFtfs", this.convertersFieldsFatory);
        return entity;
    }

    public final Integer getAccountingEntriesTypeCode() {
        return this.accountingEntriesTypeCode;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final IMngSettings getMngUvdSettings() {
        return this.mngUvdSettings;
    }

    public final void setMngUvdSettings(IMngSettings pMngUvdSettings) {
        this.mngUvdSettings = pMngUvdSettings;
    }

    public final ISrvDate getSrvDate() {
        return this.srvDate;
    }

    public final void setSrvDate(ISrvDate pSrvDate) {
        this.srvDate = pSrvDate;
    }

    public final IFactoryAppBeansByName<IConverterToFromString<?>> getConvertersFieldsFatory() {
        return this.convertersFieldsFatory;
    }

    public final void setConvertersFieldsFatory(IFactoryAppBeansByName<IConverterToFromString<?>> pConvertersFieldsFatory) {
        this.convertersFieldsFatory = pConvertersFieldsFatory;
    }

    public final IHolderForClassByName<String> getFieldConverterNamesHolder() {
        return this.fieldConverterNamesHolder;
    }

    public final void setFieldConverterNamesHolder(IHolderForClassByName<String> pFieldConverterNamesHolder) {
        this.fieldConverterNamesHolder = pFieldConverterNamesHolder;
    }
}

