/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvOrm;

public class PrcInvItemTaxCategoryLineSave<RS>
implements IEntityProcessor<InvItemTaxCategoryLine, Long> {
    private ISrvOrm<RS> srvOrm;

    @Override
    public final InvItemTaxCategoryLine process(Map<String, Object> pAddParam, InvItemTaxCategoryLine pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getItsPercentage().doubleValue() <= 0.0) {
            throw new ExceptionWithCode(1003, "percentage_wrong");
        }
        if (pEntity.getTax() == null) {
            throw new ExceptionWithCode(1003, "tax_wrong");
        }
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getItsOwner()));
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(InvItemTaxCategory.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        pEntity.setTax(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getTax()));
        if (!ETaxType.SALES_TAX_INITEM.equals((Object)pEntity.getTax().getItsType()) && !ETaxType.SALES_TAX_OUTITEM.equals((Object)pEntity.getTax().getItsType())) {
            throw new ExceptionWithCode(1003, "tax_wrong");
        }
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pAddParam, pEntity);
            pEntity.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pAddParam, pEntity);
        }
        this.updateInvItemTaxCategory(pAddParam, pEntity.getItsOwner());
        pAddParam.put("nextEntity", pEntity.getItsOwner());
        pAddParam.put("nameOwnerEntity", InvItemTaxCategory.class.getSimpleName());
        return null;
    }

    public final void updateInvItemTaxCategory(Map<String, Object> pAddParam, InvItemTaxCategory pOwner) throws Exception {
        InvItemTaxCategoryLine iitcl = new InvItemTaxCategoryLine();
        iitcl.setItsOwner(pOwner);
        List<InvItemTaxCategoryLine> ptl = this.getSrvOrm().retrieveListForField(pAddParam, iitcl, "itsOwner");
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        BigDecimal aggrPercent = BigDecimal.ZERO;
        for (InvItemTaxCategoryLine pt : ptl) {
            aggrPercent = aggrPercent.add(pt.getItsPercentage());
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(pt.getTax().getItsName());
        }
        pOwner.setAggrOnlyPercent(aggrPercent);
        pOwner.setTaxesDescription(sb.toString());
        this.getSrvOrm().updateEntity(pAddParam, pOwner);
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }
}

