/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.IInvoice;
import org.beigesoft.accounting.persistable.IInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;

public class PrcInvoiceLnGfe<RS, T extends IInvoiceLine<I>, I extends IInvoice>
implements IEntityProcessor<T, Long> {
    private IEntityProcessor<T, Long> prcEntityPbEditDelete;

    @Override
    public final T process(Map<String, Object> pReqVars, T pEntity, IRequestData pRequestData) throws Exception {
        SalesInvoice inv;
        if (pEntity.getClass() == PurchaseInvoiceServiceLine.class) {
            pReqVars.put("PurchaseInvoicevendordeepLevel", 3);
        } else if (pEntity.getClass() == SalesInvoiceServiceLine.class) {
            pReqVars.put("SalesInvoicecustomerdeepLevel", 3);
        }
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        IInvoiceLine invLn = (IInvoiceLine)this.prcEntityPbEditDelete.process(pReqVars, pEntity, pRequestData);
        pReqVars.remove("DebtorCreditorneededFields");
        if (invLn.getClass() == PurchaseInvoiceServiceLine.class) {
            pReqVars.remove("PurchaseInvoicevendordeepLevel");
        } else if (invLn.getClass() == SalesInvoiceServiceLine.class) {
            pReqVars.remove("SalesInvoicecustomerdeepLevel");
        }
        Enum rounding = null;
        String taxRounding = null;
        if (invLn.getClass() == PurchaseInvoiceServiceLine.class) {
            PurchaseInvoice inv2 = (PurchaseInvoice)invLn.getItsOwner();
            if (inv2.getVendor().getTaxDestination() != null) {
                rounding = inv2.getVendor().getTaxDestination().getSalTaxRoundMode();
            }
        } else if (invLn.getClass() == SalesInvoiceServiceLine.class && (inv = (SalesInvoice)invLn.getItsOwner()).getCustomer().getTaxDestination() != null) {
            rounding = inv.getCustomer().getTaxDestination().getSalTaxRoundMode();
        }
        if (rounding != null) {
            taxRounding = rounding.equals((Object)RoundingMode.HALF_UP) ? "S" : (rounding.equals((Object)RoundingMode.HALF_DOWN) ? "s" : (rounding.equals((Object)RoundingMode.UP) ? "U" : (rounding.equals((Object)RoundingMode.DOWN) ? "D" : (rounding.equals((Object)RoundingMode.HALF_EVEN) ? "B" : (rounding.equals((Object)RoundingMode.CEILING) ? "C" : (rounding.equals((Object)RoundingMode.FLOOR) ? "F" : "S"))))));
        }
        pRequestData.setAttribute("taxRounding", taxRounding);
        return (T)invLn;
    }

    public final IEntityProcessor<T, Long> getPrcEntityPbEditDelete() {
        return this.prcEntityPbEditDelete;
    }

    public final void setPrcEntityPbEditDelete(IEntityProcessor<T, Long> pPrcEntityPbEditDelete) {
        this.prcEntityPbEditDelete = pPrcEntityPbEditDelete;
    }
}

