/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.util.Map;
import org.beigesoft.accounting.persistable.PaymentFrom;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.processor.APrcAccDocSave;
import org.beigesoft.accounting.processor.PrcSalesInvoiceSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcPaymentFromSave<RS>
extends APrcAccDocSave<RS, PaymentFrom> {
    private PrcSalesInvoiceSave<RS> prcSalesInvoiceSave;

    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, PaymentFrom pEntity, IRequestData pRequestData) throws Exception {
        pEntity.setAccCash(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getAccCash()));
        if (pEntity.getAccCash().getSubaccType() != null && pEntity.getSubaccCashId() == null) {
            throw new ExceptionWithCode(1003, "select_subaccount");
        }
        if (pEntity.getSalesInvoice() != null) {
            SalesInvoice salesInvoice = this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getSalesInvoice());
            if (!salesInvoice.getHasMadeAccEntries().booleanValue() || salesInvoice.getReversedId() != null) {
                throw new ExceptionWithCode(1003, "sales_invoice_must_be_accounted");
            }
            pEntity.setSalesInvoice(salesInvoice);
        }
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, PaymentFrom pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd)) {
            this.prcSalesInvoiceSave.calculateTotalPayment(pAddParam, pEntity.getSalesInvoice());
            this.getSrvOrm().updateEntity(pAddParam, pEntity.getSalesInvoice());
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, PaymentFrom pEntity, IRequestData pRequestData, PaymentFrom pOldEntity) throws Exception {
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, PaymentFrom pEntity, IRequestData pRequestData) throws Exception {
    }

    public final PrcSalesInvoiceSave<RS> getPrcSalesInvoiceSave() {
        return this.prcSalesInvoiceSave;
    }

    public final void setPrcSalesInvoiceSave(PrcSalesInvoiceSave<RS> pPrcSalesInvoiceSave) {
        this.prcSalesInvoiceSave = pPrcSalesInvoiceSave;
    }
}

