/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.util.Map;
import org.beigesoft.accounting.persistable.PaymentTo;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.processor.APrcAccDocSave;
import org.beigesoft.accounting.processor.PrcPurchaseInvoiceSave;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;

public class PrcPaymentToSave<RS>
extends APrcAccDocSave<RS, PaymentTo> {
    private PrcPurchaseInvoiceSave<RS> prcPurchaseInvoiceSave;

    @Override
    public final void makeFirstPrepareForSave(Map<String, Object> pAddParam, PaymentTo pEntity, IRequestData pRequestData) throws Exception {
        pEntity.setAccCash(this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getAccCash()));
        if (pEntity.getAccCash().getSubaccType() != null && pEntity.getSubaccCashId() == null) {
            throw new ExceptionWithCode(1003, "select_subaccount");
        }
        if (pEntity.getPurchaseInvoice() != null) {
            PurchaseInvoice purchaseInvoice = this.getSrvOrm().retrieveEntity(pAddParam, pEntity.getPurchaseInvoice());
            if (!purchaseInvoice.getHasMadeAccEntries().booleanValue() || purchaseInvoice.getReversedId() != null) {
                throw new ExceptionWithCode(1003, "purchase_invoice_must_be_accounted");
            }
            pEntity.setPurchaseInvoice(purchaseInvoice);
        }
    }

    @Override
    public final void makeOtherEntries(Map<String, Object> pAddParam, PaymentTo pEntity, IRequestData pRequestData, boolean pIsNew) throws Exception {
        String actionAdd = pRequestData.getParameter("actionAdd");
        if ("makeAccEntries".equals(actionAdd)) {
            this.prcPurchaseInvoiceSave.calculateTotalPayment(pAddParam, pEntity.getPurchaseInvoice());
            this.getSrvOrm().updateEntity(pAddParam, pEntity.getPurchaseInvoice());
        }
    }

    @Override
    public final void checkOtherFraudUpdate(Map<String, Object> pAddParam, PaymentTo pEntity, IRequestData pRequestData, PaymentTo pOldEntity) throws Exception {
    }

    @Override
    public final void addCheckIsReadyToAccount(Map<String, Object> pAddParam, PaymentTo pEntity, IRequestData pRequestData) throws Exception {
    }

    public final PrcPurchaseInvoiceSave<RS> getPrcPurchaseInvoiceSave() {
        return this.prcPurchaseInvoiceSave;
    }

    public final void setPrcPurchaseInvoiceSave(PrcPurchaseInvoiceSave<RS> pPrcPurchaseInvoiceSave) {
        this.prcPurchaseInvoiceSave = pPrcPurchaseInvoiceSave;
    }
}

