/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.PurchaseReturn;
import org.beigesoft.accounting.persistable.PurchaseReturnTaxLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchRetTaxLnSave<RS>
implements IEntityProcessor<PurchaseReturnTaxLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvAccSettings srvAccSettings;
    private String queryInvTot;

    @Override
    public final PurchaseReturnTaxLine process(Map<String, Object> pReqVars, PurchaseReturnTaxLine pEntity, IRequestData pRequestData) throws Exception {
        boolean isTaxable;
        if (pEntity.getItsTotal().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "total_less_or_eq_zero");
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        pReqVars.put("PurchaseInvoicevendordeepLevel", 3);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        HashSet<String> ndFlInv = new HashSet<String>();
        ndFlInv.add("itsId");
        ndFlInv.add("vendor");
        ndFlInv.add("omitTaxes");
        ndFlInv.add("hasMadeAccEntries");
        pReqVars.put("PurchaseInvoiceneededFields", ndFlInv);
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("PurchaseInvoiceneededFields");
        pReqVars.remove("PurchaseInvoicevendordeepLevel");
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromPurchase() != false && pEntity.getItsOwner().getPurchaseInvoice().getOmitTaxes() == false && pEntity.getItsOwner().getPurchaseInvoice().getVendor().getIsForeigner() == false;
        if (!isTaxable) {
            throw new ExceptionWithCode(1003, "non_taxable");
        }
        PurchaseReturnTaxLine oldEntity = this.getSrvOrm().retrieveEntity(pReqVars, pEntity);
        pEntity.setTax(oldEntity.getTax());
        pEntity.setTaxableInvBas(oldEntity.getTaxableInvBas());
        boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
        RoundingMode rm = as.getSalTaxRoundMode();
        if (pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination() != null) {
            isItemBasis = pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination().getSalTaxIsInvoiceBase() == false;
            rm = pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination().getSalTaxRoundMode();
        }
        if (isItemBasis) {
            throw new ExceptionWithCode(1003, "cant_edit_item_basis_tax");
        }
        pEntity.setItsTotal(pEntity.getItsTotal().setScale((int)as.getPricePrecision(), rm));
        BigDecimal bd100 = new BigDecimal("100.00");
        BigDecimal totalTaxes = pEntity.getTaxableInvBas().multiply(pEntity.getTax().getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
        if (pEntity.getItsTotal().compareTo(totalTaxes) != 0) {
            if (pEntity.getItsOwner().getDescription() == null) {
                pEntity.getItsOwner().setDescription(pEntity.getItsTotal().toString() + "!=" + totalTaxes + "!");
            } else {
                pEntity.getItsOwner().setDescription(pEntity.getItsOwner().getDescription() + " " + pEntity.getItsTotal().toString() + "!=" + totalTaxes + "!");
            }
        }
        this.getSrvOrm().updateEntity(pReqVars, pEntity);
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseReturn.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        String query = this.lazyGetQueryInvTot();
        query = query.replace(":ITSOWNER", pEntity.getItsOwner().getItsId().toString());
        String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
        this.getSrvOrm().updateEntity(pReqVars, pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", PurchaseReturn.class.getSimpleName());
        return null;
    }

    public final String lazyGetQueryInvTot() throws Exception {
        if (this.queryInvTot == null) {
            String flName = "/accounting/trade/purchRetTot.sql";
            this.queryInvTot = this.loadString(flName);
        }
        return this.queryInvTot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcPurchRetTaxLnSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcPurchRetTaxLnSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final void setQueryInvTot(String pQueryInvTot) {
        this.queryInvTot = pQueryInvTot;
    }
}

