/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.DestTaxServPurchLn;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoice;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceTaxLine;
import org.beigesoft.accounting.processor.UtlPurchaseGoodsServiceLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseInvoiceServiceLineSave<RS>
implements IEntityProcessor<PurchaseInvoiceServiceLine, Long> {
    private ISrvOrm<RS> srvOrm;
    private UtlPurchaseGoodsServiceLine<RS> utlPurchaseGoodsServiceLine;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final PurchaseInvoiceServiceLine process(Map<String, Object> pReqVars, PurchaseInvoiceServiceLine pEntity, IRequestData pRequestData) throws Exception {
        boolean isTaxable;
        if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
            throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero::" + pReqVars.get("user"));
        }
        if (pEntity.getItsCost().compareTo(BigDecimal.ZERO) <= 0 && pEntity.getForeignPrice().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ExceptionWithCode(1003, "cost_less_or_eq_zero::" + pReqVars.get("user"));
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
        HashSet<String> ndFlDc = new HashSet<String>();
        ndFlDc.add("itsId");
        ndFlDc.add("isForeigner");
        ndFlDc.add("taxDestination");
        pReqVars.put("DebtorCreditorneededFields", ndFlDc);
        pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
        pReqVars.remove("DebtorCreditorneededFields");
        pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
        pEntity.setService(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getService()));
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromPurchase() != false && pEntity.getItsOwner().getOmitTaxes() == false && pEntity.getItsOwner().getVendor().getIsForeigner() == false;
        if (pEntity.getItsOwner().getForeignCurrency() != null) {
            pEntity.setItsCost(pEntity.getForeignPrice().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                pEntity.setItsTotal(pEntity.getForeignTotal().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            } else {
                pEntity.setSubtotal(pEntity.getForeignSubtotal().multiply(pEntity.getItsOwner().getExchangeRate()).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            }
        }
        BigDecimal totalTaxes = BigDecimal.ZERO;
        BigDecimal totalTaxesFc = BigDecimal.ZERO;
        BigDecimal bd100 = new BigDecimal("100.00");
        ArrayList<PurchaseInvoiceServiceTaxLine> tls = null;
        boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
        boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
        if (isTaxable) {
            pEntity.setTaxCategory(pEntity.getService().getTaxCategory());
            RoundingMode rm = as.getSalTaxRoundMode();
            if (pEntity.getItsOwner().getVendor().getTaxDestination() != null) {
                isItemBasis = pEntity.getItsOwner().getVendor().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                isAggrOnlyRate = pEntity.getItsOwner().getVendor().getTaxDestination().getSalTaxUseAggregItBas();
                rm = pEntity.getItsOwner().getVendor().getTaxDestination().getSalTaxRoundMode();
                pReqVars.put("DestTaxServPurchLnitsOwnerdeepLevel", 1);
                List<DestTaxServPurchLn> dtls = this.getSrvOrm().retrieveListWithConditions(pReqVars, DestTaxServPurchLn.class, "where ITSOWNER=" + pEntity.getService().getItsId());
                pReqVars.remove("DestTaxServPurchLnitsOwnerdeepLevel");
                for (DestTaxServPurchLn dtl : dtls) {
                    if (!dtl.getTaxDestination().getItsId().equals(pEntity.getItsOwner().getVendor().getTaxDestination().getItsId())) continue;
                    pEntity.setTaxCategory(dtl.getTaxCategory());
                    break;
                }
            }
            if (pEntity.getTaxCategory() != null && isItemBasis) {
                if (!isAggrOnlyRate) {
                    if (pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                        throw new ExceptionWithCode(1003, "price_inc_tax_multi_not_imp");
                    }
                    tls = new ArrayList<PurchaseInvoiceServiceTaxLine>();
                    pReqVars.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
                    List<InvItemTaxCategoryLine> itcls = this.getSrvOrm().retrieveListWithConditions(pReqVars, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getTaxCategory().getItsId());
                    pReqVars.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    for (InvItemTaxCategoryLine itcl : itcls) {
                        if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
                        if (i++ > 0) {
                            sb.append(", ");
                        }
                        BigDecimal addTx = pEntity.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                        totalTaxes = totalTaxes.add(addTx);
                        PurchaseInvoiceServiceTaxLine iitl = new PurchaseInvoiceServiceTaxLine();
                        iitl.setIsNew(true);
                        iitl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                        iitl.setItsTotal(addTx);
                        iitl.setTax(itcl.getTax());
                        if (pEntity.getItsOwner().getForeignCurrency() != null) {
                            BigDecimal addTxFc = pEntity.getForeignSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                            totalTaxesFc = totalTaxesFc.add(addTxFc);
                            iitl.setForeignTotalTaxes(addTxFc);
                        }
                        tls.add(iitl);
                        sb.append(itcl.getTax().getItsName() + " " + this.prn(pReqVars, addTx));
                    }
                    pEntity.setTaxesDescription(sb.toString());
                } else {
                    totalTaxes = pEntity.getItsOwner().getPriceIncTax() != false ? pEntity.getItsTotal().subtract(pEntity.getItsTotal().divide(BigDecimal.ONE.add(pEntity.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                    pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
                    if (pEntity.getItsOwner().getForeignCurrency() != null) {
                        totalTaxesFc = pEntity.getItsOwner().getPriceIncTax().booleanValue() ? pEntity.getForeignTotal().subtract(pEntity.getForeignTotal().divide(BigDecimal.ONE.add(pEntity.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm)) : pEntity.getForeignSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                    }
                }
            } else if (pEntity.getTaxCategory() != null) {
                pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
            }
        }
        if (isTaxable && pEntity.getTaxCategory() != null && isItemBasis && isAggrOnlyRate) {
            if (pEntity.getTotalTaxes().compareTo(totalTaxes) != 0) {
                if (pEntity.getDescription() == null) {
                    pEntity.setDescription(pEntity.getTotalTaxes().toString() + "!=" + totalTaxes + "!");
                } else {
                    pEntity.setDescription(pEntity.getDescription() + " " + pEntity.getTotalTaxes().toString() + "!=" + totalTaxes + "!");
                }
            }
        } else {
            pEntity.setTotalTaxes(totalTaxes);
        }
        if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
            pEntity.setSubtotal(pEntity.getItsTotal().subtract(totalTaxes));
        } else {
            pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
        }
        if (pEntity.getItsOwner().getForeignCurrency() != null) {
            pEntity.setForeignTotalTaxes(totalTaxesFc);
            if (!isTaxable || pEntity.getItsOwner().getPriceIncTax().booleanValue()) {
                pEntity.setForeignSubtotal(pEntity.getForeignTotal().subtract(totalTaxesFc));
            } else {
                pEntity.setForeignTotal(pEntity.getForeignSubtotal().add(totalTaxesFc));
            }
        }
        if (pEntity.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, pEntity);
            pEntity.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, pEntity);
        }
        PurchaseInvoiceServiceTaxLine pistlt = new PurchaseInvoiceServiceTaxLine();
        pistlt.setItsOwner(pEntity);
        pReqVars.put("PurchaseInvoiceServiceTaxLineitsOwnerdeepLevel", 1);
        List<PurchaseInvoiceServiceTaxLine> tlsw = this.getSrvOrm().retrieveListForField(pReqVars, pistlt, "itsOwner");
        pReqVars.remove("PurchaseInvoiceServiceTaxLineitsOwnerdeepLevel");
        if (tls != null) {
            for (int i = 0; i < tls.size(); ++i) {
                if (i < tlsw.size()) {
                    tlsw.get(i).setTax(((PurchaseInvoiceServiceTaxLine)tls.get(i)).getTax());
                    tlsw.get(i).setItsTotal(((PurchaseInvoiceServiceTaxLine)tls.get(i)).getItsTotal());
                    this.getSrvOrm().updateEntity(pReqVars, tlsw.get(i));
                    continue;
                }
                ((PurchaseInvoiceServiceTaxLine)tls.get(i)).setItsOwner(pEntity);
                ((PurchaseInvoiceServiceTaxLine)tls.get(i)).setInvoiceId(pEntity.getItsOwner().getItsId());
                this.getSrvOrm().insertEntity(pReqVars, tls.get(i));
                ((PurchaseInvoiceServiceTaxLine)tls.get(i)).setIsNew(false);
            }
            for (int j = tls.size(); j < tlsw.size(); ++j) {
                this.getSrvOrm().deleteEntity(pReqVars, tlsw.get(j));
            }
        } else {
            for (PurchaseInvoiceServiceTaxLine pistlw : tlsw) {
                this.getSrvOrm().deleteEntity(pReqVars, pistlw);
            }
        }
        Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseInvoice.class.getSimpleName() + ".ownerVersion"));
        pEntity.getItsOwner().setItsVersion(ownerVersion);
        this.utlPurchaseGoodsServiceLine.updateOwner(pReqVars, pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", PurchaseInvoice.class.getSimpleName());
        return null;
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("pricePrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final UtlPurchaseGoodsServiceLine<RS> getUtlPurchaseGoodsServiceLine() {
        return this.utlPurchaseGoodsServiceLine;
    }

    public final void setUtlPurchaseGoodsServiceLine(UtlPurchaseGoodsServiceLine<RS> pUtlPurchaseGoodsServiceLine) {
        this.utlPurchaseGoodsServiceLine = pUtlPurchaseGoodsServiceLine;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

