/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.CmprPurchRetLnTotal;
import org.beigesoft.accounting.model.CmprTaxCatLnRate;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseReturn;
import org.beigesoft.accounting.persistable.PurchaseReturnGoodsTaxLine;
import org.beigesoft.accounting.persistable.PurchaseReturnLine;
import org.beigesoft.accounting.persistable.PurchaseReturnTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.persistable.UseMaterialEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvDrawItemEntry;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcPurchaseReturnLineSave<RS>
implements IEntityProcessor<PurchaseReturnLine, Long> {
    private ISrvI18n srvI18n;
    private ISrvDatabase<RS> srvDatabase;
    private String queryPurchaseReturnLineTaxes;
    private String queryPurchRetSalTaxItBasAggr;
    private String queryPurchRetSalTaxInvBas;
    private String queryInvTot;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvDrawItemEntry<UseMaterialEntry> srvUseMaterialEntry;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final PurchaseReturnLine process(Map<String, Object> pReqVars, PurchaseReturnLine pEntity, IRequestData pRequestData) throws Exception {
        Double[] totals;
        if (pEntity.getIsNew().booleanValue()) {
            List<PurchaseReturnGoodsTaxLine> tls;
            pReqVars.put("PurchaseInvoicevendordeepLevel", 3);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            HashSet<String> ndFlInv = new HashSet<String>();
            ndFlInv.add("itsId");
            ndFlInv.add("vendor");
            ndFlInv.add("omitTaxes");
            ndFlInv.add("priceIncTax");
            ndFlInv.add("hasMadeAccEntries");
            pReqVars.put("PurchaseInvoiceneededFields", ndFlInv);
            pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("PurchaseInvoiceneededFields");
            pReqVars.remove("PurchaseInvoicevendordeepLevel");
            pReqVars.put("PurchaseInvoiceLineitsOwnerdeepLevel", 1);
            pEntity.setPurchaseInvoiceLine(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getPurchaseInvoiceLine()));
            pReqVars.remove("PurchaseInvoiceLineitsOwnerdeepLevel");
            AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
            boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
            boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
            RoundingMode rm = as.getSalTaxRoundMode();
            if (pEntity.getPurchaseInvoiceLine().getTaxCategory() != null && pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination() != null) {
                isItemBasis = pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                isAggrOnlyRate = pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination().getSalTaxUseAggregItBas();
                rm = pEntity.getItsOwner().getPurchaseInvoice().getVendor().getTaxDestination().getSalTaxRoundMode();
            }
            if (pEntity.getReversedId() != null) {
                PurchaseReturnLine reversed = this.getSrvOrm().retrieveEntityById(pReqVars, PurchaseReturnLine.class, pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pReqVars.get("user"));
                }
                pEntity.setWarehouseSiteFo(reversed.getWarehouseSiteFo());
                pEntity.setPurchaseInvoiceLine(reversed.getPurchaseInvoiceLine());
                pEntity.setPurchInvLnAppearance(reversed.getPurchInvLnAppearance());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, pEntity);
                pEntity.setIsNew(false);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, reversed);
                PurchaseReturnGoodsTaxLine pigtlt = new PurchaseReturnGoodsTaxLine();
                pigtlt.setItsOwner(reversed);
                tls = this.getSrvOrm().retrieveListForField(pReqVars, pigtlt, "itsOwner");
                for (PurchaseReturnGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pReqVars, pigtl);
                }
                this.srvWarehouseEntry.reverseDraw(pReqVars, pEntity);
                this.srvUseMaterialEntry.reverseDraw(pReqVars, pEntity, pEntity.getItsOwner().getItsDate(), pEntity.getItsOwner().getItsId());
            } else {
                BigDecimal curCostNt;
                BigDecimal sourceCostNt;
                if (pEntity.getItsQuantity().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "quantity_less_or_equal_zero");
                }
                if (pEntity.getPurchaseInvoiceLine() == null) {
                    throw new ExceptionWithCode(1003, "wrong_purchaseInvoiceLine");
                }
                String langDef = (String)pReqVars.get("langDef");
                pEntity.setPurchInvLnAppearance(this.getSrvI18n().getMsg(PurchaseInvoiceLine.class.getSimpleName() + "short", langDef) + " #" + pEntity.getPurchaseInvoiceLine().getIdDatabaseBirth() + "-" + pEntity.getPurchaseInvoiceLine().getItsId() + ", " + pEntity.getPurchaseInvoiceLine().getInvItem().getItsName() + ", " + pEntity.getPurchaseInvoiceLine().getUnitOfMeasure().getItsName() + ", " + this.getSrvI18n().getMsg("itsCost", langDef) + "=" + this.prnc(pReqVars, pEntity.getPurchaseInvoiceLine().getItsCost()) + ", " + this.getSrvI18n().getMsg("rest_was", langDef) + "=" + this.prnq(pReqVars, pEntity.getPurchaseInvoiceLine().getTheRest()));
                BigDecimal totalTaxes = BigDecimal.ZERO;
                tls = null;
                BigDecimal bd100 = new BigDecimal("100.00");
                if (pEntity.getPurchaseInvoiceLine().getTaxCategory() != null && isItemBasis) {
                    if (!isAggrOnlyRate) {
                        tls = new ArrayList<PurchaseReturnGoodsTaxLine>();
                        pReqVars.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
                        List<InvItemTaxCategoryLine> itcls = this.getSrvOrm().retrieveListWithConditions(pReqVars, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getPurchaseInvoiceLine().getTaxCategory().getItsId());
                        pReqVars.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        for (InvItemTaxCategoryLine itcl : itcls) {
                            if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
                            if (i++ > 0) {
                                sb.append(", ");
                            }
                            BigDecimal addTx = pEntity.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                            totalTaxes = totalTaxes.add(addTx);
                            PurchaseReturnGoodsTaxLine iitl = new PurchaseReturnGoodsTaxLine();
                            iitl.setIsNew(true);
                            iitl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                            iitl.setItsTotal(addTx);
                            iitl.setTax(itcl.getTax());
                            tls.add(iitl);
                            sb.append(itcl.getTax().getItsName() + " " + this.prn(pReqVars, addTx));
                        }
                        pEntity.setTaxesDescription(sb.toString());
                    } else {
                        totalTaxes = pEntity.getSubtotal().multiply(pEntity.getPurchaseInvoiceLine().getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                        pEntity.setTaxesDescription(pEntity.getPurchaseInvoiceLine().getTaxCategory().getItsName());
                    }
                } else if (pEntity.getPurchaseInvoiceLine().getTaxCategory() != null) {
                    pEntity.setTaxesDescription(pEntity.getPurchaseInvoiceLine().getTaxCategory().getItsName());
                }
                if (pEntity.getPurchaseInvoiceLine().getTaxCategory() != null && isItemBasis && isAggrOnlyRate) {
                    if (pEntity.getTotalTaxes().compareTo(totalTaxes) != 0) {
                        if (pEntity.getDescription() == null) {
                            pEntity.setDescription(pEntity.getTotalTaxes().toString() + "!=" + totalTaxes + "!");
                        } else {
                            pEntity.setDescription(pEntity.getDescription() + " " + pEntity.getTotalTaxes().toString() + "!=" + totalTaxes + "!");
                        }
                    }
                } else {
                    pEntity.setTotalTaxes(totalTaxes);
                }
                if ((sourceCostNt = pEntity.getItsOwner().getPurchaseInvoice().getPriceIncTax() != false ? pEntity.getPurchaseInvoiceLine().getItsCost().divide(BigDecimal.ONE.add(pEntity.getPurchaseInvoiceLine().getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getCostPrecision(), as.getRoundingMode()) : pEntity.getPurchaseInvoiceLine().getItsCost()).compareTo(curCostNt = pEntity.getSubtotal().divide(pEntity.getItsQuantity(), (int)as.getCostPrecision(), as.getRoundingMode())) != 0) {
                    if (pEntity.getDescription() == null) {
                        pEntity.setDescription(curCostNt.toString() + "!=" + sourceCostNt + "!");
                    } else {
                        pEntity.setDescription(pEntity.getDescription() + " " + curCostNt + "!=" + sourceCostNt + "!");
                    }
                }
                pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
                this.getSrvOrm().insertEntity(pReqVars, pEntity);
                pEntity.setIsNew(false);
                if (tls != null) {
                    for (PurchaseReturnGoodsTaxLine pigtl : tls) {
                        pigtl.setItsOwner(pEntity);
                        pigtl.setInvoiceId(pEntity.getItsOwner().getItsId());
                        this.getSrvOrm().insertEntity(pReqVars, pigtl);
                        pigtl.setIsNew(false);
                    }
                }
                this.srvWarehouseEntry.withdrawal(pReqVars, pEntity, pEntity.getWarehouseSiteFo());
                this.srvUseMaterialEntry.withdrawalFrom(pReqVars, pEntity, pEntity.getPurchaseInvoiceLine(), pEntity.getItsQuantity());
            }
            this.updateTaxLines(pReqVars, pEntity.getItsOwner(), pEntity.getPurchaseInvoiceLine().getTaxCategory() != null, isItemBasis, isAggrOnlyRate, as, rm);
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(PurchaseReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            String query = this.lazyGetQueryInvTot();
            query = query.replace(":ITSOWNER", pEntity.getItsOwner().getItsId().toString());
            String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
            totals = this.getSrvDatabase().evalDoubleResults(query, columns);
            if (totals[0] == null) {
                totals[0] = 0.0;
            }
            if (totals[1] == null) {
                totals[1] = 0.0;
            }
        } else {
            throw new ExceptionWithCode(403, "Attempt to update purchase return line by " + pReqVars.get("user"));
        }
        pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
        this.getSrvOrm().updateEntity(pReqVars, pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", PurchaseReturn.class.getSimpleName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pReqVars, PurchaseReturn pItsOwner, boolean pIsTaxable, boolean pIsItemBasis, boolean pIsAggrOnlyRate, AccSettings pAs, RoundingMode pRm) throws Exception {
        pReqVars.put("PurchaseInvoiceTaxLineitsOwnerdeepLevel", 1);
        List<PurchaseReturnTaxLine> itls = this.getSrvOrm().retrieveListWithConditions(pReqVars, PurchaseReturnTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("PurchaseInvoiceTaxLineitsOwnerdeepLevel");
        if (pIsTaxable) {
            String query = !pIsItemBasis ? this.lazyGetQuPurchRetSalTaxInvBas() : (pIsAggrOnlyRate ? this.lazyGetQuPurchRetSalTaxItBasAggr() : this.lazyGetQueryPurchaseReturnLineTaxes());
            query = query.replace(":INVOICEID", pItsOwner.getItsId().toString());
            IRecordSet<RS> recordSet = null;
            ArrayList<PurchaseInvoiceServiceLine> inLnsDt = new ArrayList<PurchaseInvoiceServiceLine>();
            ArrayList<Long> taxesLst = new ArrayList<Long>();
            ArrayList<Double> dbResults = new ArrayList<Double>();
            try {
                recordSet = this.getSrvDatabase().retrieveRecords(query);
                if (recordSet.moveToFirst()) {
                    do {
                        Iterator invLn;
                        Long taxId = recordSet.getLong("TAXID");
                        if (!pIsItemBasis) {
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            Long ilId = recordSet.getLong("TAXCATID");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, pAs);
                            ((PurchaseInvoiceServiceLine)((Object)invLn)).setSubtotal(BigDecimal.valueOf(recordSet.getDouble("SUBTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        if (pIsAggrOnlyRate) {
                            Long ilId = recordSet.getLong("ILID");
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, pAs);
                            ((PurchaseInvoiceServiceLine)((Object)invLn)).setTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("TOTALTAXES")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        taxesLst.add(taxId);
                        dbResults.add(recordSet.getDouble("TOTALTAX"));
                    } while (recordSet.moveToNext());
                }
            }
            finally {
                if (recordSet != null) {
                    recordSet.close();
                }
            }
            if (inLnsDt.size() > 0 && taxesLst.size() > 0) {
                throw new Exception("Algorithm error!!!");
            }
            if (!pIsItemBasis && inLnsDt.size() > 0) {
                HashSet taxIds = new HashSet();
                for (PurchaseInvoiceServiceLine invLn : inLnsDt) {
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        if (taxIds.contains(itcl.getTax().getItsId())) {
                            throw new ExceptionWithCode(1003, "invoice_basis_same_taxes_with_different_tax_cat");
                        }
                        taxIds.add(itcl.getTax().getItsId());
                    }
                }
            }
            if (itls.size() > 0) {
                for (PurchaseReturnTaxLine itl : itls) {
                    itl.setTax(null);
                    itl.setTaxableInvBas(BigDecimal.ZERO);
                    itl.setItsTotal(BigDecimal.ZERO);
                }
            }
            ArrayList<PurchaseReturnTaxLine> itlsnew = null;
            if (!pIsItemBasis || pIsAggrOnlyRate) {
                itlsnew = new ArrayList<PurchaseReturnTaxLine>();
            }
            pReqVars.put("countUpdatedItl", 0);
            if (inLnsDt.size() > 0) {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<InvItemTaxCategoryLine> cmpr = Collections.reverseOrder(new CmprTaxCatLnRate());
                for (PurchaseInvoiceServiceLine invLn : inLnsDt) {
                    int ti = 0;
                    BigDecimal invBasTaxTot = null;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    if (pIsAggrOnlyRate) {
                        Collections.sort(invLn.getTaxCategory().getTaxes(), cmpr);
                    }
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        ++ti;
                        if (taxAggegated == null && pIsAggrOnlyRate && pIsItemBasis) {
                            taxAggegated = invLn.getTotalTaxes();
                        }
                        if (!pIsItemBasis) {
                            invBasTaxTot = invLn.getTotalTaxes();
                        }
                        if (!pIsItemBasis) {
                            invLn.setTotalTaxes(invLn.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)pAs.getPricePrecision(), pRm));
                        } else if (pIsItemBasis && pIsAggrOnlyRate) {
                            if (invLn.getTaxCategory().getTaxes().size() == 1 || ti < invLn.getTaxCategory().getTaxes().size()) {
                                invLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pRm));
                                taxAggrAccum = taxAggrAccum.add(invLn.getTotalTaxes());
                            } else {
                                invLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                            }
                        } else {
                            throw new Exception("Algorithm error!!!");
                        }
                        PurchaseReturnTaxLine itl = this.findCreateTaxLine(pReqVars, itls, itlsnew, itcl.getTax().getItsId());
                        itl.setItsOwner(pItsOwner);
                        itl.setTax(itcl.getTax());
                        this.makeItl(pReqVars, itl, invLn, pIsItemBasis);
                        if (pIsItemBasis) continue;
                        invLn.setTotalTaxes(invBasTaxTot.add(invLn.getTotalTaxes()));
                    }
                }
            }
            if (taxesLst.size() > 0) {
                for (int i = 0; i < taxesLst.size(); ++i) {
                    Tax tax = new Tax();
                    tax.setItsId((Long)taxesLst.get(i));
                    PurchaseReturnTaxLine itl = this.findCreateTaxLine(pReqVars, itls, null, tax.getItsId());
                    itl.setItsOwner(pItsOwner);
                    itl.setTax(tax);
                    itl.setItsTotal(BigDecimal.valueOf((Double)dbResults.get(i)).setScale((int)pAs.getPricePrecision(), pRm));
                    if (itl.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pReqVars, itl);
                        itl.setIsNew(false);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pReqVars, itl);
                }
            }
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            pReqVars.remove("countUpdatedItl");
            if (countUpdatedItl < itls.size()) {
                for (int j = countUpdatedItl.intValue(); j < itls.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pReqVars, itls.get(j));
                }
            }
            if (!pIsItemBasis && inLnsDt.size() > 0) {
                this.adjustInvoiceLns(pReqVars, pItsOwner, inLnsDt, pAs);
            }
        } else if (itls.size() > 0) {
            for (PurchaseReturnTaxLine prtln : itls) {
                this.getSrvOrm().deleteEntity(pReqVars, prtln);
            }
        }
    }

    public final void adjustInvoiceLns(Map<String, Object> pReqVars, PurchaseReturn pItsOwner, List<PurchaseInvoiceServiceLine> pTacCatTotLns, AccSettings pAs) throws Exception {
        pReqVars.put("PurchaseReturnLineitsOwnerdeepLevel", 1);
        List<PurchaseReturnLine> igls = this.getSrvOrm().retrieveListWithConditions(pReqVars, PurchaseReturnLine.class, "where PURCHASEINVOICELINE.TAXCATEGORY is not null and PURCHASERETURNLINE.REVERSEDID is null and PURCHASERETURNLINE.ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("PurchaseReturnLineitsOwnerdeepLevel");
        ArrayList<PurchaseReturnLine> ilnt = new ArrayList<PurchaseReturnLine>();
        Comparator<PurchaseReturnLine> cmpr = Collections.reverseOrder(new CmprPurchRetLnTotal());
        for (PurchaseInvoiceServiceLine ttl : pTacCatTotLns) {
            for (PurchaseReturnLine igl : igls) {
                if (!igl.getPurchaseInvoiceLine().getTaxCategory().getItsId().equals(ttl.getTaxCategory().getItsId())) continue;
                ilnt.add(igl);
            }
            Collections.sort(ilnt, cmpr);
            BigDecimal txRest = ttl.getTotalTaxes();
            for (int i = 0; i < ilnt.size(); ++i) {
                if (i + 1 == ilnt.size()) {
                    ((PurchaseReturnLine)ilnt.get(i)).setItsTotal(((PurchaseReturnLine)ilnt.get(i)).getSubtotal().add(txRest));
                    ((PurchaseReturnLine)ilnt.get(i)).setTotalTaxes(txRest);
                } else {
                    BigDecimal taxTot = ttl.getTotalTaxes().multiply(((PurchaseReturnLine)ilnt.get(i)).getSubtotal()).divide(ttl.getSubtotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                    ((PurchaseReturnLine)ilnt.get(i)).setItsTotal(((PurchaseReturnLine)ilnt.get(i)).getSubtotal().add(taxTot));
                    ((PurchaseReturnLine)ilnt.get(i)).setTotalTaxes(taxTot);
                    txRest = txRest.subtract(taxTot);
                }
                this.getSrvOrm().updateEntity(pReqVars, ilnt.get(i));
            }
            ilnt.clear();
        }
    }

    public final PurchaseReturnTaxLine findCreateTaxLine(Map<String, Object> pReqVars, List<PurchaseReturnTaxLine> pTaxLnsWas, List<PurchaseReturnTaxLine> pTaxLnsNew, Long pTaxId) {
        int k;
        PurchaseReturnTaxLine itl = null;
        if (pTaxLnsWas.size() > 0) {
            for (k = 0; k < pTaxLnsWas.size(); ++k) {
                if (pTaxLnsWas.get(k).getTax() == null || !pTaxLnsWas.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsWas.get(k);
                break;
            }
        }
        if (itl == null && pTaxLnsNew.size() > 0) {
            for (k = 0; k < pTaxLnsNew.size(); ++k) {
                if (!pTaxLnsNew.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsNew.get(k);
                break;
            }
        }
        if (itl == null) {
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            if (pTaxLnsWas.size() > countUpdatedItl) {
                itl = pTaxLnsWas.get(countUpdatedItl);
                Integer n = countUpdatedItl;
                Integer n2 = countUpdatedItl = Integer.valueOf(countUpdatedItl + 1);
                pReqVars.put("countUpdatedItl", countUpdatedItl);
            } else {
                itl = new PurchaseReturnTaxLine();
                itl.setIsNew(true);
                itl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                if (pTaxLnsNew != null) {
                    pTaxLnsNew.add(itl);
                }
            }
        }
        return itl;
    }

    public final PurchaseInvoiceServiceLine makeLine(List<PurchaseInvoiceServiceLine> pInvLns, Long pIlId, Long pCatId, Long pTaxId, Double pPercent, AccSettings pAs) {
        PurchaseInvoiceServiceLine invLn = null;
        for (PurchaseInvoiceServiceLine il : pInvLns) {
            if (!il.getItsId().equals(pIlId)) continue;
            invLn = il;
        }
        if (invLn == null) {
            invLn = new PurchaseInvoiceServiceLine();
            invLn.setItsId(pIlId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            tc.setTaxes(new ArrayList<InvItemTaxCategoryLine>());
            invLn.setTaxCategory(tc);
            pInvLns.add(invLn);
        }
        InvItemTaxCategoryLine itcl = new InvItemTaxCategoryLine();
        Tax tax = new Tax();
        tax.setItsId(pTaxId);
        itcl.setTax(tax);
        itcl.setItsPercentage(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTaxPrecision(), RoundingMode.HALF_UP));
        invLn.getTaxCategory().getTaxes().add(itcl);
        invLn.getTaxCategory().setAggrOnlyPercent(invLn.getTaxCategory().getAggrOnlyPercent().add(itcl.getItsPercentage()));
        return invLn;
    }

    public final void makeItl(Map<String, Object> pReqVars, PurchaseReturnTaxLine pItl, PurchaseInvoiceServiceLine pInvLn, boolean pIsItemBasis) throws Exception {
        pItl.setItsTotal(pItl.getItsTotal().add(pInvLn.getTotalTaxes()));
        if (!pIsItemBasis) {
            pItl.setTaxableInvBas(pItl.getTaxableInvBas().add(pInvLn.getSubtotal()));
        }
        if (pItl.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, pItl);
            pItl.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, pItl);
        }
    }

    public final String lazyGetQueryPurchaseReturnLineTaxes() throws Exception {
        if (this.queryPurchaseReturnLineTaxes == null) {
            String flName = "/accounting/trade/purchaseReturnLineTaxes.sql";
            this.queryPurchaseReturnLineTaxes = this.loadString(flName);
        }
        return this.queryPurchaseReturnLineTaxes;
    }

    public final String lazyGetQuPurchRetSalTaxItBasAggr() throws Exception {
        if (this.queryPurchRetSalTaxItBasAggr == null) {
            String flName = "/accounting/trade/purchRetSalTaxItBasAggr.sql";
            this.queryPurchRetSalTaxItBasAggr = this.loadString(flName);
        }
        return this.queryPurchRetSalTaxItBasAggr;
    }

    public final String lazyGetQuPurchRetSalTaxInvBas() throws Exception {
        if (this.queryPurchRetSalTaxInvBas == null) {
            String flName = "/accounting/trade/purchRetSalTaxInvBasis.sql";
            this.queryPurchRetSalTaxInvBas = this.loadString(flName);
        }
        return this.queryPurchRetSalTaxInvBas;
    }

    public final String lazyGetQueryInvTot() throws Exception {
        if (this.queryInvTot == null) {
            String flName = "/accounting/trade/purchRetTot.sql";
            this.queryInvTot = this.loadString(flName);
        }
        return this.queryInvTot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcPurchaseReturnLineSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcPurchaseReturnLineSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("pricePrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final String prnc(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("costPrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final String prnq(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("quantityPrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDrawItemEntry<UseMaterialEntry> getSrvUseMaterialEntry() {
        return this.srvUseMaterialEntry;
    }

    public final void setSrvUseMaterialEntry(ISrvDrawItemEntry<UseMaterialEntry> pSrvUseMaterialEntry) {
        this.srvUseMaterialEntry = pSrvUseMaterialEntry;
    }

    public final void setQueryPurchaseReturnLineTaxes(String pQueryPurchaseReturnLineTaxes) {
        this.queryPurchaseReturnLineTaxes = pQueryPurchaseReturnLineTaxes;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }

    public final void setQueryPurchRetSalTaxItBasAggr(String pQueryPurchRetSalTaxItBasAggr) {
        this.queryPurchRetSalTaxItBasAggr = pQueryPurchRetSalTaxItBasAggr;
    }

    public final void setQueryPurchRetSalTaxInvBas(String pQueryPurchRetSalTaxInvBas) {
        this.queryPurchRetSalTaxInvBas = pQueryPurchRetSalTaxInvBas;
    }

    public final void setQueryInvTot(String pQueryInvTot) {
        this.queryInvTot = pQueryInvTot;
    }
}

