/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Map;
import org.beigesoft.accounting.persistable.DestTaxGoodsLn;
import org.beigesoft.accounting.persistable.DestTaxServPurchLn;
import org.beigesoft.accounting.persistable.DestTaxServSelLn;
import org.beigesoft.accounting.persistable.InvItem;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.PurchaseInvoiceLine;
import org.beigesoft.accounting.persistable.PurchaseInvoiceServiceLine;
import org.beigesoft.accounting.persistable.PurchaseReturnLine;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesReturnLine;
import org.beigesoft.accounting.persistable.ServicePurchased;
import org.beigesoft.accounting.persistable.ServiceToSale;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;

public class PrcRevealTaxCat<RS>
implements IProcessor {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private String queryRevealTaxCat;

    @Override
    public final void process(Map<String, Object> pAddParam, IRequestData pRequestData) throws Exception {
        String itemNm;
        String destTaxItemLnNm;
        String taxDestIdStr = pRequestData.getParameter("taxDestId");
        Long taxDestId = Long.parseLong(taxDestIdStr);
        String itemIdStr = pRequestData.getParameter("itemId");
        Long itemId = Long.parseLong(itemIdStr);
        String nmEnt = pRequestData.getParameter("nmEnt");
        if (SalesInvoiceServiceLine.class.getSimpleName().equals(nmEnt)) {
            destTaxItemLnNm = DestTaxServSelLn.class.getSimpleName().toUpperCase();
            itemNm = ServiceToSale.class.getSimpleName().toUpperCase();
        } else if (PurchaseInvoiceServiceLine.class.getSimpleName().equals(nmEnt)) {
            destTaxItemLnNm = DestTaxServPurchLn.class.getSimpleName().toUpperCase();
            itemNm = ServicePurchased.class.getSimpleName().toUpperCase();
        } else if (PurchaseInvoiceLine.class.getSimpleName().equals(nmEnt) || SalesInvoiceLine.class.getSimpleName().equals(nmEnt) || SalesReturnLine.class.getSimpleName().equals(nmEnt) || PurchaseReturnLine.class.getSimpleName().equals(nmEnt)) {
            destTaxItemLnNm = DestTaxGoodsLn.class.getSimpleName().toUpperCase();
            itemNm = InvItem.class.getSimpleName().toUpperCase();
        } else {
            throw new ExceptionWithCode(1003, "Wrong line type " + nmEnt);
        }
        String query = this.lazyGetQueryRevealTaxCat();
        query = query.replace(":ITEMNM", itemNm);
        query = query.replace(":DESTTAXITEMLNNM", destTaxItemLnNm);
        query = query.replace(":ITEMID", itemId.toString());
        query = query.replace(":TAXDESTID", taxDestId.toString());
        InvItemTaxCategory taxCategory = new InvItemTaxCategory();
        IRecordSet<RS> recordSet = null;
        Enum rounding = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                Long dtlId = recordSet.getLong("DTLID");
                Integer tdrm = null;
                Long tcId = recordSet.getLong("DTCID");
                String tcd = null;
                String tcn = null;
                Double tcRate = null;
                if (dtlId == null) {
                    tcn = recordSet.getString("OTCNAME");
                    tcd = recordSet.getString("OTCDESCR");
                    tcId = recordSet.getLong("OTCID");
                    tcRate = recordSet.getDouble("OTCRATE");
                } else if (tcId != null) {
                    tdrm = recordSet.getInteger("DTRM");
                    tcd = recordSet.getString("DTCDESCR");
                    tcn = recordSet.getString("DTCNAME");
                    tcRate = recordSet.getDouble("DTCRATE");
                }
                taxCategory.setItsId(tcId);
                taxCategory.setItsName(tcn);
                taxCategory.setTaxesDescription(tcd);
                if (tdrm != null) {
                    rounding = ((RoundingMode[])RoundingMode.class.getEnumConstants())[tdrm];
                }
                if (tcRate != null) {
                    taxCategory.setAggrOnlyPercent(BigDecimal.valueOf(tcRate));
                }
                if (recordSet.moveToNext()) {
                    throw new ExceptionWithCode(1001, "There are multiply tax category results for item id/tax dest.id/entity: " + itemId + "/" + taxDestId + "/" + nmEnt);
                }
            }
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            if (recordSet != null) {
                recordSet.close();
            }
            this.srvDatabase.releaseResources();
        }
        String taxRounding = null;
        if (rounding != null) {
            taxRounding = rounding.equals((Object)RoundingMode.HALF_UP) ? "S" : (rounding.equals((Object)RoundingMode.HALF_DOWN) ? "s" : (rounding.equals((Object)RoundingMode.UP) ? "U" : (rounding.equals((Object)RoundingMode.DOWN) ? "D" : (rounding.equals((Object)RoundingMode.HALF_EVEN) ? "B" : (rounding.equals((Object)RoundingMode.CEILING) ? "C" : (rounding.equals((Object)RoundingMode.FLOOR) ? "F" : "S"))))));
        }
        pRequestData.setAttribute("taxRounding", taxRounding);
        pRequestData.setAttribute("taxCategory", taxCategory);
    }

    public final String lazyGetQueryRevealTaxCat() throws IOException {
        if (this.queryRevealTaxCat == null) {
            this.queryRevealTaxCat = this.loadString("/accounting/revealTaxCat.sql");
        }
        return this.queryRevealTaxCat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcRevealTaxCat.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcRevealTaxCat.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final String getQueryRevealTaxCat() {
        return this.queryRevealTaxCat;
    }

    public final void setQueryRevealTaxCat(String pQueryRevealTaxCat) {
        this.queryRevealTaxCat = pQueryRevealTaxCat;
    }
}

