/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.CmprSalRetLnTotal;
import org.beigesoft.accounting.model.CmprTaxCatLnRate;
import org.beigesoft.accounting.model.ETaxType;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.DestTaxGoodsLn;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesReturn;
import org.beigesoft.accounting.persistable.SalesReturnGoodsTaxLine;
import org.beigesoft.accounting.persistable.SalesReturnLine;
import org.beigesoft.accounting.persistable.SalesReturnTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvWarehouseEntry;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class PrcSalesReturnLineSave<RS>
implements IEntityProcessor<SalesReturnLine, Long> {
    private ISrvDatabase<RS> srvDatabase;
    private String querySalRetTaxInvBas;
    private String querySalRetTaxItBasAggr;
    private String querySalRetTaxItemBas;
    private String queryInvTot;
    private ISrvOrm<RS> srvOrm;
    private ISrvWarehouseEntry srvWarehouseEntry;
    private ISrvAccSettings srvAccSettings;
    private ISrvNumberToString srvNumberToString;

    @Override
    public final SalesReturnLine process(Map<String, Object> pReqVars, SalesReturnLine pEntity, IRequestData pRequestData) throws Exception {
        Double[] totals;
        if (pEntity.getIsNew().booleanValue()) {
            pReqVars.put("DebtorCreditortaxDestinationdeepLevel", 2);
            HashSet<String> ndFlDc = new HashSet<String>();
            ndFlDc.add("itsId");
            ndFlDc.add("isForeigner");
            ndFlDc.add("taxDestination");
            pReqVars.put("DebtorCreditorneededFields", ndFlDc);
            pEntity.setItsOwner(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getItsOwner()));
            pReqVars.remove("DebtorCreditorneededFields");
            pReqVars.remove("DebtorCreditortaxDestinationdeepLevel");
            pEntity.setInvItem(this.getSrvOrm().retrieveEntity(pReqVars, pEntity.getInvItem()));
            AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
            boolean isTaxable = as.getIsExtractSalesTaxFromSales() != false && pEntity.getItsOwner().getOmitTaxes() == false && pEntity.getItsOwner().getCustomer().getIsForeigner() == false;
            boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
            boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
            RoundingMode rm = as.getSalTaxRoundMode();
            if (isTaxable) {
                pEntity.setTaxCategory(pEntity.getInvItem().getTaxCategory());
                if (pEntity.getItsOwner().getCustomer().getTaxDestination() != null) {
                    isItemBasis = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                    isAggrOnlyRate = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxUseAggregItBas();
                    rm = pEntity.getItsOwner().getCustomer().getTaxDestination().getSalTaxRoundMode();
                    pReqVars.put("DestTaxGoodsLnitsOwnerdeepLevel", 1);
                    List<DestTaxGoodsLn> dtls = this.getSrvOrm().retrieveListWithConditions(pReqVars, DestTaxGoodsLn.class, "where ITSOWNER=" + pEntity.getInvItem().getItsId());
                    pReqVars.remove("DestTaxGoodsLnitsOwnerdeepLevel");
                    for (DestTaxGoodsLn dtl : dtls) {
                        if (!dtl.getTaxDestination().getItsId().equals(pEntity.getItsOwner().getCustomer().getTaxDestination().getItsId())) continue;
                        pEntity.setTaxCategory(dtl.getTaxCategory());
                        break;
                    }
                }
            }
            if (pEntity.getReversedId() != null) {
                SalesReturnLine reversed = this.getSrvOrm().retrieveEntityById(pReqVars, SalesReturnLine.class, pEntity.getReversedId());
                if (reversed.getReversedId() != null) {
                    throw new ExceptionWithCode(403, "Attempt to double reverse" + pReqVars.get("user"));
                }
                if (!reversed.getItsQuantity().equals(reversed.getTheRest())) {
                    throw new ExceptionWithCode(1003, "where_is_withdrawals_from_this_source");
                }
                pEntity.setTheRest(BigDecimal.ZERO);
                pEntity.setInvItem(reversed.getInvItem());
                pEntity.setUnitOfMeasure(reversed.getUnitOfMeasure());
                pEntity.setWarehouseSite(reversed.getWarehouseSite());
                pEntity.setTaxesDescription(reversed.getTaxesDescription());
                pEntity.setTotalTaxes(reversed.getTotalTaxes().negate());
                pEntity.setItsQuantity(reversed.getItsQuantity().negate());
                pEntity.setItsCost(reversed.getItsCost());
                pEntity.setItsPrice(reversed.getItsPrice());
                pEntity.setSubtotal(reversed.getSubtotal().negate());
                pEntity.setItsTotal(reversed.getItsTotal().negate());
                this.getSrvOrm().insertEntity(pReqVars, pEntity);
                pEntity.setIsNew(false);
                reversed.setTheRest(BigDecimal.ZERO);
                reversed.setReversedId(pEntity.getItsId());
                this.getSrvOrm().updateEntity(pReqVars, reversed);
                SalesReturnGoodsTaxLine pigtlt = new SalesReturnGoodsTaxLine();
                pigtlt.setItsOwner(reversed);
                List<SalesReturnGoodsTaxLine> tls = this.getSrvOrm().retrieveListForField(pReqVars, pigtlt, "itsOwner");
                for (SalesReturnGoodsTaxLine pigtl : tls) {
                    this.getSrvOrm().deleteEntity(pReqVars, pigtl);
                }
            } else {
                if (pEntity.getItsQuantity().doubleValue() == 0.0) {
                    throw new ExceptionWithCode(1003, "quantity_is_0");
                }
                if (pEntity.getItsCost().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "cost_less_or_eq_zero" + pReqVars.get("user"));
                }
                if (pEntity.getItsPrice().doubleValue() <= 0.0) {
                    throw new ExceptionWithCode(1003, "price_less_eq_0");
                }
                BigDecimal totalTaxes = BigDecimal.ZERO;
                ArrayList<SalesReturnGoodsTaxLine> tls = null;
                if (pEntity.getTaxCategory() != null && isItemBasis) {
                    BigDecimal bd100 = new BigDecimal("100.00");
                    if (!isAggrOnlyRate) {
                        tls = new ArrayList<SalesReturnGoodsTaxLine>();
                        pReqVars.put("InvItemTaxCategoryLineitsOwnerdeepLevel", 1);
                        List<InvItemTaxCategoryLine> itcls = this.getSrvOrm().retrieveListWithConditions(pReqVars, InvItemTaxCategoryLine.class, "where ITSOWNER=" + pEntity.getTaxCategory().getItsId());
                        pReqVars.remove("InvItemTaxCategoryLineitsOwnerdeepLevel");
                        StringBuffer sb = new StringBuffer();
                        int i = 0;
                        for (InvItemTaxCategoryLine itcl : itcls) {
                            if (!ETaxType.SALES_TAX_OUTITEM.equals((Object)itcl.getTax().getItsType()) && !ETaxType.SALES_TAX_INITEM.equals((Object)itcl.getTax().getItsType())) continue;
                            if (i++ > 0) {
                                sb.append(", ");
                            }
                            BigDecimal addTx = pEntity.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm);
                            totalTaxes = totalTaxes.add(addTx);
                            SalesReturnGoodsTaxLine iitl = new SalesReturnGoodsTaxLine();
                            iitl.setIsNew(true);
                            iitl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                            iitl.setItsTotal(addTx);
                            iitl.setTax(itcl.getTax());
                            tls.add(iitl);
                            sb.append(itcl.getTax().getItsName() + " " + this.prn(pReqVars, addTx));
                        }
                        pEntity.setTaxesDescription(sb.toString());
                    } else {
                        totalTaxes = pEntity.getSubtotal().multiply(pEntity.getTaxCategory().getAggrOnlyPercent()).divide(bd100, (int)as.getPricePrecision(), rm);
                        pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
                    }
                } else if (pEntity.getTaxCategory() != null) {
                    pEntity.setTaxesDescription(pEntity.getTaxCategory().getItsName());
                }
                if (pEntity.getTaxCategory() != null && isItemBasis && isAggrOnlyRate) {
                    if (pEntity.getTotalTaxes().compareTo(totalTaxes) != 0) {
                        if (pEntity.getDescription() == null) {
                            pEntity.setDescription(pEntity.getTotalTaxes().toString() + "!=" + totalTaxes + "!");
                        } else {
                            pEntity.setDescription(pEntity.getDescription() + " " + pEntity.getTotalTaxes().toString() + "!=" + totalTaxes + "!");
                        }
                    }
                } else {
                    pEntity.setTotalTaxes(totalTaxes);
                }
                pEntity.setItsTotal(pEntity.getSubtotal().add(totalTaxes));
                this.getSrvOrm().insertEntity(pReqVars, pEntity);
                pEntity.setIsNew(false);
                if (tls != null) {
                    for (SalesReturnGoodsTaxLine itl : tls) {
                        itl.setItsOwner(pEntity);
                        itl.setInvoiceId(pEntity.getItsOwner().getItsId());
                        this.getSrvOrm().insertEntity(pReqVars, itl);
                        itl.setIsNew(false);
                    }
                }
                this.srvWarehouseEntry.load(pReqVars, pEntity, pEntity.getWarehouseSite());
            }
            this.updateTaxLines(pReqVars, pEntity.getItsOwner(), isTaxable, isItemBasis, isAggrOnlyRate, as, rm);
            Long ownerVersion = Long.valueOf(pRequestData.getParameter(SalesReturn.class.getSimpleName() + ".ownerVersion"));
            pEntity.getItsOwner().setItsVersion(ownerVersion);
            String query = this.lazyGetQueryInvTot();
            query = query.replace(":ITSOWNER", pEntity.getItsOwner().getItsId().toString());
            String[] columns = new String[]{"SUBTOTAL", "TOTALTAXES"};
            totals = this.getSrvDatabase().evalDoubleResults(query, columns);
            if (totals[0] == null) {
                totals[0] = 0.0;
            }
            if (totals[1] == null) {
                totals[1] = 0.0;
            }
        } else {
            throw new ExceptionWithCode(403, "Attempt to update Sales Return line by " + pReqVars.get("user"));
        }
        pEntity.getItsOwner().setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setTotalTaxes(BigDecimal.valueOf(totals[1]).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getPricePrecision(), this.getSrvAccSettings().lazyGetAccSettings(pReqVars).getRoundingMode()));
        pEntity.getItsOwner().setItsTotal(pEntity.getItsOwner().getSubtotal().add(pEntity.getItsOwner().getTotalTaxes()));
        this.getSrvOrm().updateEntity(pReqVars, pEntity.getItsOwner());
        pReqVars.put("nextEntity", pEntity.getItsOwner());
        pReqVars.put("nameOwnerEntity", SalesReturn.class.getSimpleName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pReqVars, SalesReturn pItsOwner, boolean pIsTaxable, boolean pIsItemBasis, boolean pIsAggrOnlyRate, AccSettings pAs, RoundingMode pRm) throws Exception {
        pReqVars.put("SalesInvoiceTaxLineitsOwnerdeepLevel", 1);
        List<SalesReturnTaxLine> itls = this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesReturnTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("SalesInvoiceTaxLineitsOwnerdeepLevel");
        if (pIsTaxable) {
            String query = !pIsItemBasis ? this.lazyGetQuSalRetTaxInvBas() : (pIsAggrOnlyRate ? this.lazyGetQuSalRetTaxItBasAggr() : this.lazyGetQuSalRetTaxItemBas());
            query = query.replace(":INVOICEID", pItsOwner.getItsId().toString());
            IRecordSet<RS> recordSet = null;
            ArrayList<SalesInvoiceServiceLine> inLnsDt = new ArrayList<SalesInvoiceServiceLine>();
            ArrayList<Long> taxesLst = new ArrayList<Long>();
            ArrayList<Double> dbResults = new ArrayList<Double>();
            try {
                recordSet = this.getSrvDatabase().retrieveRecords(query);
                if (recordSet.moveToFirst()) {
                    do {
                        Iterator invLn;
                        Long taxId = recordSet.getLong("TAXID");
                        if (!pIsItemBasis) {
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            Long ilId = recordSet.getLong("TAXCATID");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, pAs);
                            ((SalesInvoiceServiceLine)((Object)invLn)).setSubtotal(BigDecimal.valueOf(recordSet.getDouble("SUBTOTAL")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        if (pIsAggrOnlyRate) {
                            Long ilId = recordSet.getLong("ILID");
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, pAs);
                            ((SalesInvoiceServiceLine)((Object)invLn)).setTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("TOTALTAXES")).setScale((int)pAs.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        taxesLst.add(taxId);
                        dbResults.add(recordSet.getDouble("TOTALTAX"));
                    } while (recordSet.moveToNext());
                }
            }
            finally {
                if (recordSet != null) {
                    recordSet.close();
                }
            }
            if (inLnsDt.size() > 0 && taxesLst.size() > 0) {
                throw new Exception("Algorithm error!!!");
            }
            if (!pIsItemBasis && inLnsDt.size() > 0) {
                HashSet taxIds = new HashSet();
                for (SalesInvoiceServiceLine invLn : inLnsDt) {
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        if (taxIds.contains(itcl.getTax().getItsId())) {
                            throw new ExceptionWithCode(1003, "invoice_basis_same_taxes_with_different_tax_cat");
                        }
                        taxIds.add(itcl.getTax().getItsId());
                    }
                }
            }
            if (itls.size() > 0) {
                for (SalesReturnTaxLine itl : itls) {
                    itl.setTax(null);
                    itl.setTaxableInvBas(BigDecimal.ZERO);
                    itl.setItsTotal(BigDecimal.ZERO);
                }
            }
            ArrayList<SalesReturnTaxLine> itlsnew = null;
            if (!pIsItemBasis || pIsAggrOnlyRate) {
                itlsnew = new ArrayList<SalesReturnTaxLine>();
            }
            pReqVars.put("countUpdatedItl", 0);
            if (inLnsDt.size() > 0) {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<InvItemTaxCategoryLine> cmpr = Collections.reverseOrder(new CmprTaxCatLnRate());
                for (SalesInvoiceServiceLine invLn : inLnsDt) {
                    int ti = 0;
                    BigDecimal invBasTaxTot = null;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    if (pIsAggrOnlyRate) {
                        Collections.sort(invLn.getTaxCategory().getTaxes(), cmpr);
                    }
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        ++ti;
                        if (taxAggegated == null && pIsAggrOnlyRate && pIsItemBasis) {
                            taxAggegated = invLn.getTotalTaxes();
                        }
                        if (!pIsItemBasis) {
                            invBasTaxTot = invLn.getTotalTaxes();
                        }
                        if (!pIsItemBasis) {
                            invLn.setTotalTaxes(invLn.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)pAs.getPricePrecision(), pRm));
                        } else if (pIsItemBasis && pIsAggrOnlyRate) {
                            if (invLn.getTaxCategory().getTaxes().size() == 1 || ti < invLn.getTaxCategory().getTaxes().size()) {
                                invLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)pAs.getPricePrecision(), pRm));
                                taxAggrAccum = taxAggrAccum.add(invLn.getTotalTaxes());
                            } else {
                                invLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                            }
                        } else {
                            throw new Exception("Algorithm error!!!");
                        }
                        SalesReturnTaxLine itl = this.findCreateTaxLine(pReqVars, itls, itlsnew, itcl.getTax().getItsId());
                        itl.setItsOwner(pItsOwner);
                        itl.setTax(itcl.getTax());
                        this.makeItl(pReqVars, itl, invLn, pIsItemBasis);
                        if (pIsItemBasis) continue;
                        invLn.setTotalTaxes(invBasTaxTot.add(invLn.getTotalTaxes()));
                    }
                }
            }
            if (taxesLst.size() > 0) {
                for (int i = 0; i < taxesLst.size(); ++i) {
                    Tax tax = new Tax();
                    tax.setItsId((Long)taxesLst.get(i));
                    SalesReturnTaxLine itl = this.findCreateTaxLine(pReqVars, itls, null, tax.getItsId());
                    itl.setItsOwner(pItsOwner);
                    itl.setTax(tax);
                    itl.setItsTotal(BigDecimal.valueOf((Double)dbResults.get(i)).setScale((int)pAs.getPricePrecision(), pRm));
                    if (itl.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pReqVars, itl);
                        itl.setIsNew(false);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pReqVars, itl);
                }
            }
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            pReqVars.remove("countUpdatedItl");
            if (countUpdatedItl < itls.size()) {
                for (int j = countUpdatedItl.intValue(); j < itls.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pReqVars, itls.get(j));
                }
            }
            if (!pIsItemBasis && inLnsDt.size() > 0) {
                this.adjustInvoiceLns(pReqVars, pItsOwner, inLnsDt, pAs);
            }
        } else if (itls.size() > 0) {
            for (SalesReturnTaxLine prtln : itls) {
                this.getSrvOrm().deleteEntity(pReqVars, prtln);
            }
        }
    }

    public final void adjustInvoiceLns(Map<String, Object> pReqVars, SalesReturn pItsOwner, List<SalesInvoiceServiceLine> pTacCatTotLns, AccSettings pAs) throws Exception {
        pReqVars.put("SalesReturnLineitsOwnerdeepLevel", 1);
        List<SalesReturnLine> igls = this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesReturnLine.class, "where SALESRETURNLINE.TAXCATEGORY is not null and REVERSEDID is null and ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("SalesReturnLineitsOwnerdeepLevel");
        ArrayList<SalesReturnLine> ilnt = new ArrayList<SalesReturnLine>();
        Comparator<SalesReturnLine> cmpr = Collections.reverseOrder(new CmprSalRetLnTotal());
        for (SalesInvoiceServiceLine ttl : pTacCatTotLns) {
            for (SalesReturnLine igl : igls) {
                if (!igl.getTaxCategory().getItsId().equals(ttl.getTaxCategory().getItsId())) continue;
                ilnt.add(igl);
            }
            Collections.sort(ilnt, cmpr);
            BigDecimal txRest = ttl.getTotalTaxes();
            for (int i = 0; i < ilnt.size(); ++i) {
                if (i + 1 == ilnt.size()) {
                    ((SalesReturnLine)ilnt.get(i)).setItsTotal(((SalesReturnLine)ilnt.get(i)).getSubtotal().add(txRest));
                    ((SalesReturnLine)ilnt.get(i)).setTotalTaxes(txRest);
                } else {
                    BigDecimal taxTot = ttl.getTotalTaxes().multiply(((SalesReturnLine)ilnt.get(i)).getSubtotal()).divide(ttl.getSubtotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                    ((SalesReturnLine)ilnt.get(i)).setItsTotal(((SalesReturnLine)ilnt.get(i)).getSubtotal().add(taxTot));
                    ((SalesReturnLine)ilnt.get(i)).setTotalTaxes(taxTot);
                    txRest = txRest.subtract(taxTot);
                }
                this.getSrvOrm().updateEntity(pReqVars, ilnt.get(i));
            }
            ilnt.clear();
        }
    }

    public final SalesReturnTaxLine findCreateTaxLine(Map<String, Object> pReqVars, List<SalesReturnTaxLine> pTaxLnsWas, List<SalesReturnTaxLine> pTaxLnsNew, Long pTaxId) {
        int k;
        SalesReturnTaxLine itl = null;
        if (pTaxLnsWas.size() > 0) {
            for (k = 0; k < pTaxLnsWas.size(); ++k) {
                if (pTaxLnsWas.get(k).getTax() == null || !pTaxLnsWas.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsWas.get(k);
                break;
            }
        }
        if (itl == null && pTaxLnsNew != null && pTaxLnsNew.size() > 0) {
            for (k = 0; k < pTaxLnsNew.size(); ++k) {
                if (!pTaxLnsNew.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsNew.get(k);
                break;
            }
        }
        if (itl == null) {
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            if (pTaxLnsWas.size() > countUpdatedItl) {
                itl = pTaxLnsWas.get(countUpdatedItl);
                Integer n = countUpdatedItl;
                Integer n2 = countUpdatedItl = Integer.valueOf(countUpdatedItl + 1);
                pReqVars.put("countUpdatedItl", countUpdatedItl);
            } else {
                itl = new SalesReturnTaxLine();
                itl.setIsNew(true);
                itl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                if (pTaxLnsNew != null) {
                    pTaxLnsNew.add(itl);
                }
            }
        }
        return itl;
    }

    public final SalesInvoiceServiceLine makeLine(List<SalesInvoiceServiceLine> pInvLns, Long pIlId, Long pCatId, Long pTaxId, Double pPercent, AccSettings pAs) {
        SalesInvoiceServiceLine invLn = null;
        for (SalesInvoiceServiceLine il : pInvLns) {
            if (!il.getItsId().equals(pIlId)) continue;
            invLn = il;
        }
        if (invLn == null) {
            invLn = new SalesInvoiceServiceLine();
            invLn.setItsId(pIlId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            tc.setTaxes(new ArrayList<InvItemTaxCategoryLine>());
            invLn.setTaxCategory(tc);
            pInvLns.add(invLn);
        }
        InvItemTaxCategoryLine itcl = new InvItemTaxCategoryLine();
        Tax tax = new Tax();
        tax.setItsId(pTaxId);
        itcl.setTax(tax);
        itcl.setItsPercentage(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTaxPrecision(), RoundingMode.HALF_UP));
        invLn.getTaxCategory().getTaxes().add(itcl);
        invLn.getTaxCategory().setAggrOnlyPercent(invLn.getTaxCategory().getAggrOnlyPercent().add(itcl.getItsPercentage()));
        return invLn;
    }

    public final void makeItl(Map<String, Object> pReqVars, SalesReturnTaxLine pItl, SalesInvoiceServiceLine pInvLn, boolean pIsItemBasis) throws Exception {
        pItl.setItsTotal(pItl.getItsTotal().add(pInvLn.getTotalTaxes()));
        if (!pIsItemBasis) {
            pItl.setTaxableInvBas(pItl.getTaxableInvBas().add(pInvLn.getSubtotal()));
        }
        if (pItl.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, pItl);
            pItl.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, pItl);
        }
    }

    public final String lazyGetQuSalRetTaxItBasAggr() throws Exception {
        if (this.querySalRetTaxItBasAggr == null) {
            String flName = "/accounting/trade/salRetTaxItBasAggr.sql";
            this.querySalRetTaxItBasAggr = this.loadString(flName);
        }
        return this.querySalRetTaxItBasAggr;
    }

    public final String lazyGetQuSalRetTaxInvBas() throws Exception {
        if (this.querySalRetTaxInvBas == null) {
            String flName = "/accounting/trade/salRetTaxInvBas.sql";
            this.querySalRetTaxInvBas = this.loadString(flName);
        }
        return this.querySalRetTaxInvBas;
    }

    public final String lazyGetQuSalRetTaxItemBas() throws Exception {
        if (this.querySalRetTaxItemBas == null) {
            String flName = "/accounting/trade/salRetTaxItemBas.sql";
            this.querySalRetTaxItemBas = this.loadString(flName);
        }
        return this.querySalRetTaxItemBas;
    }

    public final String lazyGetQueryInvTot() throws Exception {
        if (this.queryInvTot == null) {
            String flName = "/accounting/trade/salRetTot.sql";
            this.queryInvTot = this.loadString(flName);
        }
        return this.queryInvTot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = PrcSalesReturnLineSave.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = PrcSalesReturnLineSave.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("pricePrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final ISrvWarehouseEntry getSrvWarehouseEntry() {
        return this.srvWarehouseEntry;
    }

    public final void setSrvWarehouseEntry(ISrvWarehouseEntry pSrvWarehouseEntry) {
        this.srvWarehouseEntry = pSrvWarehouseEntry;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }

    public final void setQueryInvTot(String pQueryInvTot) {
        this.queryInvTot = pQueryInvTot;
    }

    public final void setQuerySalRetTaxInvBas(String pQuerySalRetTaxInvBas) {
        this.querySalRetTaxInvBas = pQuerySalRetTaxInvBas;
    }

    public final void setQuerySalRetTaxItBasAggr(String pQuerySalRetTaxItBasAggr) {
        this.querySalRetTaxItBasAggr = pQuerySalRetTaxItBasAggr;
    }

    public final void setQuerySalRetTaxItemBas(String pQuerySalRetTaxItemBas) {
        this.querySalRetTaxItemBas = pQuerySalRetTaxItemBas;
    }
}

