/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.processor;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.CmprInvLnTotal;
import org.beigesoft.accounting.model.CmprTaxCatLnRate;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.IInvoiceLine;
import org.beigesoft.accounting.persistable.InvItemTaxCategory;
import org.beigesoft.accounting.persistable.InvItemTaxCategoryLine;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.persistable.Tax;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.persistable.APersistableBaseVersion;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class UtlSalesGoodsServiceLine<RS> {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private String fileQuSalInvSaTaxItBasAggr = "salInvSalTaxItBasAggr.sql";
    private String quSalInvSaTaxItBasAggr;
    private String fileQuSalInvSaTaxItBas = "salesInvSalTaxItemBasis.sql";
    private String quSalInvSaTaxItBas;
    private String fileQuSalInvSaTaxInvBas = "salesInvSalTaxInvBasis.sql";
    private String quSalInvSaTaxInvBas;
    private String fileQuerySalesInvoiceTotals = "salesInvoiceTotals.sql";
    private String querySalesInvoiceTotals;
    private ISrvAccSettings srvAccSettings;

    public final void updateOwner(Map<String, Object> pReqVars, SalesInvoice pItsOwner) throws Exception {
        this.updateTaxLines(pReqVars, pItsOwner);
        String query = this.lazyGetQuerySalesInvoiceTotals();
        query = query.replace(":ITSOWNER", pItsOwner.getItsId().toString());
        String[] columns = new String[]{"SUBTOTAL", "ITSTOTAL", "TOTALTAXES", "FOREIGNSUBTOTAL", "FOREIGNTOTAL", "FOREIGNTOTALTAXES"};
        Double[] totals = this.getSrvDatabase().evalDoubleResults(query, columns);
        if (totals[0] == null) {
            totals[0] = 0.0;
        }
        if (totals[1] == null) {
            totals[1] = 0.0;
        }
        if (totals[2] == null) {
            totals[2] = 0.0;
        }
        if (totals[3] == null) {
            totals[3] = 0.0;
        }
        if (totals[4] == null) {
            totals[4] = 0.0;
        }
        if (totals[5] == null) {
            totals[5] = 0.0;
        }
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        if (pItsOwner.getPriceIncTax().booleanValue()) {
            pItsOwner.setItsTotal(BigDecimal.valueOf(totals[1]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setTotalTaxes(BigDecimal.valueOf(totals[2]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setSubtotal(pItsOwner.getItsTotal().subtract(pItsOwner.getTotalTaxes()));
            pItsOwner.setForeignTotal(BigDecimal.valueOf(totals[4]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setForeignTotalTaxes(BigDecimal.valueOf(totals[5]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setForeignSubtotal(pItsOwner.getForeignTotal().subtract(pItsOwner.getForeignTotalTaxes()));
        } else {
            pItsOwner.setSubtotal(BigDecimal.valueOf(totals[0]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setTotalTaxes(BigDecimal.valueOf(totals[2]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setItsTotal(pItsOwner.getSubtotal().add(pItsOwner.getTotalTaxes()));
            pItsOwner.setForeignSubtotal(BigDecimal.valueOf(totals[3]).setScale((int)as.getPricePrecision(), as.getRoundingMode()));
            pItsOwner.setForeignTotalTaxes(BigDecimal.valueOf(totals[5]).setScale((int)as.getPricePrecision(), as.getSalTaxRoundMode()));
            pItsOwner.setForeignTotal(pItsOwner.getForeignSubtotal().add(pItsOwner.getForeignTotalTaxes()));
        }
        this.getSrvOrm().updateEntity(pReqVars, pItsOwner);
    }

    public final String lazyGetQuSalInvSaTaxItBasAggr() throws Exception {
        if (this.quSalInvSaTaxItBasAggr == null) {
            String flName = "/accounting/trade/" + this.fileQuSalInvSaTaxItBasAggr;
            this.quSalInvSaTaxItBasAggr = this.loadString(flName);
        }
        return this.quSalInvSaTaxItBasAggr;
    }

    public final String lazyGetQuSalInvSaTaxItBas() throws Exception {
        if (this.quSalInvSaTaxItBas == null) {
            String flName = "/accounting/trade/" + this.fileQuSalInvSaTaxItBas;
            this.quSalInvSaTaxItBas = this.loadString(flName);
        }
        return this.quSalInvSaTaxItBas;
    }

    public final String lazyGetQuSalInvSaTaxInvBas() throws Exception {
        if (this.quSalInvSaTaxInvBas == null) {
            String flName = "/accounting/trade/" + this.fileQuSalInvSaTaxInvBas;
            this.quSalInvSaTaxInvBas = this.loadString(flName);
        }
        return this.quSalInvSaTaxInvBas;
    }

    public final String lazyGetQuerySalesInvoiceTotals() throws Exception {
        if (this.querySalesInvoiceTotals == null) {
            String flName = "/accounting/trade/" + this.fileQuerySalesInvoiceTotals;
            this.querySalesInvoiceTotals = this.loadString(flName);
        }
        return this.querySalesInvoiceTotals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = UtlSalesGoodsServiceLine.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = UtlSalesGoodsServiceLine.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateTaxLines(Map<String, Object> pReqVars, SalesInvoice pItsOwner) throws Exception {
        boolean isTaxable;
        pReqVars.put("SalesInvoiceTaxLineitsOwnerdeepLevel", 1);
        List<SalesInvoiceTaxLine> itls = this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesInvoiceTaxLine.class, "where ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("SalesInvoiceTaxLineitsOwnerdeepLevel");
        boolean isShowDebug = this.getLogger().getIsShowDebugMessagesFor(this.getClass());
        int dbgDetLev = this.getLogger().getDetailLevel();
        AccSettings as = this.getSrvAccSettings().lazyGetAccSettings(pReqVars);
        boolean bl = isTaxable = as.getIsExtractSalesTaxFromSales() != false && pItsOwner.getOmitTaxes() == false && pItsOwner.getCustomer().getIsForeigner() == false;
        if (isTaxable) {
            boolean isItemBasis = as.getSalTaxIsInvoiceBase() == false;
            boolean isAggrOnlyRate = as.getSalTaxUseAggregItBas();
            RoundingMode rm = as.getSalTaxRoundMode();
            if (pItsOwner.getCustomer().getTaxDestination() != null) {
                isItemBasis = pItsOwner.getCustomer().getTaxDestination().getSalTaxIsInvoiceBase() == false;
                isAggrOnlyRate = pItsOwner.getCustomer().getTaxDestination().getSalTaxUseAggregItBas();
                rm = pItsOwner.getCustomer().getTaxDestination().getSalTaxRoundMode();
            }
            if (pItsOwner.getPriceIncTax().booleanValue() && !isAggrOnlyRate) {
                throw new ExceptionWithCode(1003, "price_inc_tax_multi_not_imp");
            }
            if (isShowDebug && dbgDetLev > 30000) {
                this.getLogger().debug(null, UtlSalesGoodsServiceLine.class, "Updating tax lines for invoice #/date/isItemBasis/isAggrOnlyRate/rm: " + pItsOwner.getItsId() + "/" + pItsOwner.getItsDate() + "/" + isItemBasis + "/" + isAggrOnlyRate + "/" + (Object)((Object)rm));
            }
            String query = !isItemBasis ? this.lazyGetQuSalInvSaTaxInvBas() : (isAggrOnlyRate ? this.lazyGetQuSalInvSaTaxItBasAggr() : this.lazyGetQuSalInvSaTaxItBas());
            query = query.replace(":INVOICEID", pItsOwner.getItsId().toString());
            IRecordSet<RS> recordSet = null;
            ArrayList<SalesInvoiceServiceLine> inLnsDt = new ArrayList<SalesInvoiceServiceLine>();
            ArrayList<Long> taxesLst = new ArrayList<Long>();
            ArrayList<Double> dbResults = new ArrayList<Double>();
            try {
                recordSet = this.getSrvDatabase().retrieveRecords(query);
                if (recordSet.moveToFirst()) {
                    do {
                        Iterator invLn;
                        Long taxId = recordSet.getLong("TAXID");
                        if (!isItemBasis) {
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            Long ilId = recordSet.getLong("TAXCATID");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, as);
                            if (pItsOwner.getPriceIncTax().booleanValue()) {
                                ((SalesInvoiceServiceLine)((Object)invLn)).setItsTotal(BigDecimal.valueOf(recordSet.getDouble("ITSTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                                ((SalesInvoiceServiceLine)((Object)invLn)).setForeignTotal(BigDecimal.valueOf(recordSet.getDouble("FOREIGNTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                                continue;
                            }
                            ((SalesInvoiceServiceLine)((Object)invLn)).setSubtotal(BigDecimal.valueOf(recordSet.getDouble("SUBTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            ((SalesInvoiceServiceLine)((Object)invLn)).setForeignTotal(BigDecimal.valueOf(recordSet.getDouble("FOREIGNSUBTOTAL")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        if (isAggrOnlyRate) {
                            Long ilId = recordSet.getLong("ILID");
                            Double percent = recordSet.getDouble("ITSPERCENTAGE");
                            invLn = this.makeLine(inLnsDt, ilId, ilId, taxId, percent, as);
                            ((SalesInvoiceServiceLine)((Object)invLn)).setTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("TOTALTAXES")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            ((SalesInvoiceServiceLine)((Object)invLn)).setForeignTotalTaxes(BigDecimal.valueOf(recordSet.getDouble("FOREIGNTOTALTAXES")).setScale((int)as.getPricePrecision(), RoundingMode.HALF_UP));
                            continue;
                        }
                        taxesLst.add(taxId);
                        dbResults.add(recordSet.getDouble("TOTALTAX"));
                        dbResults.add(recordSet.getDouble("FOREIGNTOTALTAXES"));
                    } while (recordSet.moveToNext());
                }
            }
            finally {
                if (recordSet != null) {
                    recordSet.close();
                }
            }
            if (inLnsDt.size() > 0 && taxesLst.size() > 0) {
                throw new Exception("Algorithm error!!!");
            }
            if (!isItemBasis && inLnsDt.size() > 0) {
                HashSet taxIds = new HashSet();
                for (SalesInvoiceServiceLine invLn : inLnsDt) {
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        if (taxIds.contains(itcl.getTax().getItsId())) {
                            throw new ExceptionWithCode(1003, "invoice_basis_same_taxes_with_different_tax_cat");
                        }
                        taxIds.add(itcl.getTax().getItsId());
                    }
                }
            }
            if (itls.size() > 0) {
                for (SalesInvoiceTaxLine itl : itls) {
                    itl.setTax(null);
                    itl.setTaxableInvBas(BigDecimal.ZERO);
                    itl.setTaxableInvBasFc(BigDecimal.ZERO);
                    itl.setItsTotal(BigDecimal.ZERO);
                    itl.setForeignTotalTaxes(BigDecimal.ZERO);
                }
            }
            ArrayList<SalesInvoiceTaxLine> itlsnew = null;
            if (!isItemBasis || isAggrOnlyRate) {
                itlsnew = new ArrayList<SalesInvoiceTaxLine>();
            }
            pReqVars.put("countUpdatedItl", 0);
            if (inLnsDt.size() > 0) {
                BigDecimal bd100 = new BigDecimal("100.00");
                Comparator<InvItemTaxCategoryLine> cmpr = Collections.reverseOrder(new CmprTaxCatLnRate());
                for (SalesInvoiceServiceLine invLn : inLnsDt) {
                    int ti = 0;
                    BigDecimal invBasTaxTot = null;
                    BigDecimal invBasTaxTotFc = null;
                    BigDecimal taxAggegated = null;
                    BigDecimal taxAggegatedFc = null;
                    BigDecimal taxAggrAccum = BigDecimal.ZERO;
                    BigDecimal taxAggrAccumFc = BigDecimal.ZERO;
                    if (isAggrOnlyRate) {
                        Collections.sort(invLn.getTaxCategory().getTaxes(), cmpr);
                    }
                    for (InvItemTaxCategoryLine itcl : invLn.getTaxCategory().getTaxes()) {
                        ++ti;
                        if (taxAggegated == null && isAggrOnlyRate) {
                            if (!isItemBasis && pItsOwner.getPriceIncTax().booleanValue()) {
                                taxAggegated = invLn.getItsTotal().subtract(invLn.getItsTotal().divide(BigDecimal.ONE.add(invLn.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm));
                                taxAggegatedFc = invLn.getForeignTotal().subtract(invLn.getForeignTotal().divide(BigDecimal.ONE.add(invLn.getTaxCategory().getAggrOnlyPercent().divide(bd100)), (int)as.getPricePrecision(), rm));
                            } else if (isItemBasis) {
                                taxAggegated = invLn.getTotalTaxes();
                                taxAggegatedFc = invLn.getForeignTotalTaxes();
                            }
                        }
                        if (!isItemBasis) {
                            invBasTaxTot = invLn.getTotalTaxes();
                            invBasTaxTotFc = invLn.getForeignTotalTaxes();
                        }
                        if (!isItemBasis && pItsOwner.getPriceIncTax().booleanValue() && isAggrOnlyRate) {
                            if (invLn.getTaxCategory().getTaxes().size() == 1 || ti < invLn.getTaxCategory().getTaxes().size()) {
                                invLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccum = taxAggrAccum.add(invLn.getTotalTaxes());
                                invLn.setForeignTotalTaxes(taxAggegatedFc.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccumFc = taxAggrAccumFc.add(invLn.getForeignTotalTaxes());
                            } else {
                                invLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                                invLn.setForeignTotalTaxes(taxAggegatedFc.subtract(taxAggrAccumFc));
                            }
                        } else if (!isItemBasis && !pItsOwner.getPriceIncTax().booleanValue()) {
                            invLn.setTotalTaxes(invLn.getSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm));
                            invLn.setForeignTotalTaxes(invLn.getForeignSubtotal().multiply(itcl.getItsPercentage()).divide(bd100, (int)as.getPricePrecision(), rm));
                        } else if (isItemBasis && isAggrOnlyRate) {
                            if (invLn.getTaxCategory().getTaxes().size() == 1 || ti < invLn.getTaxCategory().getTaxes().size()) {
                                invLn.setTotalTaxes(taxAggegated.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccum = taxAggrAccum.add(invLn.getTotalTaxes());
                                invLn.setForeignTotalTaxes(taxAggegatedFc.multiply(itcl.getItsPercentage()).divide(invLn.getTaxCategory().getAggrOnlyPercent(), (int)as.getPricePrecision(), rm));
                                taxAggrAccumFc = taxAggrAccumFc.add(invLn.getForeignTotalTaxes());
                            } else {
                                invLn.setTotalTaxes(taxAggegated.subtract(taxAggrAccum));
                                invLn.setForeignTotalTaxes(taxAggegatedFc.subtract(taxAggrAccumFc));
                            }
                        } else {
                            throw new Exception("Algorithm error!!!");
                        }
                        SalesInvoiceTaxLine itl = this.findCreateTaxLine(pReqVars, itls, itlsnew, itcl.getTax().getItsId());
                        itl.setItsOwner(pItsOwner);
                        itl.setTax(itcl.getTax());
                        this.makeItl(pReqVars, itl, invLn, isItemBasis, pItsOwner.getPriceIncTax());
                        if (isItemBasis) continue;
                        invLn.setTotalTaxes(invBasTaxTot.add(invLn.getTotalTaxes()));
                        invLn.setForeignTotalTaxes(invBasTaxTotFc.add(invLn.getForeignTotalTaxes()));
                    }
                }
            }
            if (taxesLst.size() > 0) {
                for (int i = 0; i < taxesLst.size(); ++i) {
                    Tax tax = new Tax();
                    tax.setItsId((Long)taxesLst.get(i));
                    SalesInvoiceTaxLine itl = this.findCreateTaxLine(pReqVars, itls, null, tax.getItsId());
                    itl.setItsOwner(pItsOwner);
                    itl.setTax(tax);
                    itl.setItsTotal(BigDecimal.valueOf((Double)dbResults.get(i * 2)).setScale((int)as.getPricePrecision(), rm));
                    itl.setForeignTotalTaxes(BigDecimal.valueOf((Double)dbResults.get(i * 2 + 1)).setScale((int)as.getPricePrecision(), rm));
                    if (itl.getIsNew().booleanValue()) {
                        this.getSrvOrm().insertEntity(pReqVars, itl);
                        itl.setIsNew(false);
                        continue;
                    }
                    this.getSrvOrm().updateEntity(pReqVars, itl);
                }
            }
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            pReqVars.remove("countUpdatedItl");
            if (countUpdatedItl < itls.size()) {
                for (int j = countUpdatedItl.intValue(); j < itls.size(); ++j) {
                    this.getSrvOrm().deleteEntity(pReqVars, itls.get(j));
                }
            }
            if (!isItemBasis && inLnsDt.size() > 0) {
                this.adjustInvoiceLns(pReqVars, pItsOwner, inLnsDt, as);
            }
        } else if (itls.size() > 0) {
            if (isShowDebug) {
                this.getLogger().debug(null, UtlSalesGoodsServiceLine.class, "Deleting tax lines for non-taxable invoice #" + pItsOwner.getItsId() + "/" + pItsOwner.getItsDate());
            }
            for (SalesInvoiceTaxLine itln : itls) {
                this.getSrvOrm().deleteEntity(pReqVars, itln);
            }
        }
    }

    public final void adjustInvoiceLns(Map<String, Object> pReqVars, SalesInvoice pItsOwner, List<SalesInvoiceServiceLine> pTacCatTotLns, AccSettings pAs) throws Exception {
        pReqVars.put("SalesInvoiceServiceLineitsOwnerdeepLevel", 1);
        List<SalesInvoiceServiceLine> isls = this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesInvoiceServiceLine.class, "where SALESINVOICESERVICELINE.TAXCATEGORY is not null and ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("SalesInvoiceServiceLineitsOwnerdeepLevel");
        pReqVars.put("SalesInvoiceLineitsOwnerdeepLevel", 1);
        List<SalesInvoiceLine> igls = this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesInvoiceLine.class, "where SALESINVOICELINE.TAXCATEGORY is not null and REVERSEDID is null and ITSOWNER=" + pItsOwner.getItsId());
        pReqVars.remove("SalesInvoiceLineitsOwnerdeepLevel");
        ArrayList<APersistableBaseVersion> ilnt = new ArrayList<APersistableBaseVersion>();
        Comparator cmpr = Collections.reverseOrder(new CmprInvLnTotal());
        for (SalesInvoiceServiceLine ttl : pTacCatTotLns) {
            for (SalesInvoiceServiceLine isl : isls) {
                if (!isl.getTaxCategory().getItsId().equals(ttl.getTaxCategory().getItsId())) continue;
                ilnt.add(isl);
            }
            for (SalesInvoiceLine igl : igls) {
                if (!igl.getTaxCategory().getItsId().equals(ttl.getTaxCategory().getItsId())) continue;
                ilnt.add(igl);
            }
            Collections.sort(ilnt, cmpr);
            BigDecimal txRest = ttl.getTotalTaxes();
            for (int i = 0; i < ilnt.size(); ++i) {
                if (i + 1 == ilnt.size()) {
                    if (pItsOwner.getPriceIncTax().booleanValue()) {
                        ((IInvoiceLine)ilnt.get(i)).setSubtotal(((IInvoiceLine)ilnt.get(i)).getItsTotal().subtract(txRest));
                    } else {
                        ((IInvoiceLine)ilnt.get(i)).setItsTotal(((IInvoiceLine)ilnt.get(i)).getSubtotal().add(txRest));
                    }
                    ((IInvoiceLine)ilnt.get(i)).setTotalTaxes(txRest);
                } else {
                    BigDecimal taxTot;
                    if (pItsOwner.getPriceIncTax().booleanValue()) {
                        taxTot = ttl.getTotalTaxes().multiply(((IInvoiceLine)ilnt.get(i)).getItsTotal()).divide(ttl.getItsTotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                        ((IInvoiceLine)ilnt.get(i)).setSubtotal(((IInvoiceLine)ilnt.get(i)).getItsTotal().subtract(taxTot));
                    } else {
                        taxTot = ttl.getTotalTaxes().multiply(((IInvoiceLine)ilnt.get(i)).getSubtotal()).divide(ttl.getSubtotal(), (int)pAs.getPricePrecision(), RoundingMode.HALF_UP);
                        ((IInvoiceLine)ilnt.get(i)).setItsTotal(((IInvoiceLine)ilnt.get(i)).getSubtotal().add(taxTot));
                    }
                    ((IInvoiceLine)ilnt.get(i)).setTotalTaxes(taxTot);
                    txRest = txRest.subtract(taxTot);
                }
                this.getSrvOrm().updateEntity(pReqVars, ilnt.get(i));
            }
            ilnt.clear();
        }
    }

    public final SalesInvoiceTaxLine findCreateTaxLine(Map<String, Object> pReqVars, List<SalesInvoiceTaxLine> pTaxLnsWas, List<SalesInvoiceTaxLine> pTaxLnsNew, Long pTaxId) {
        int k;
        SalesInvoiceTaxLine itl = null;
        if (pTaxLnsWas.size() > 0) {
            for (k = 0; k < pTaxLnsWas.size(); ++k) {
                if (pTaxLnsWas.get(k).getTax() == null || !pTaxLnsWas.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsWas.get(k);
                break;
            }
        }
        if (itl == null && pTaxLnsNew != null && pTaxLnsNew.size() > 0) {
            for (k = 0; k < pTaxLnsNew.size(); ++k) {
                if (!pTaxLnsNew.get(k).getTax().getItsId().equals(pTaxId)) continue;
                itl = pTaxLnsNew.get(k);
                break;
            }
        }
        if (itl == null) {
            Integer countUpdatedItl = (Integer)pReqVars.get("countUpdatedItl");
            if (pTaxLnsWas.size() > countUpdatedItl) {
                itl = pTaxLnsWas.get(countUpdatedItl);
                Integer n = countUpdatedItl;
                Integer n2 = countUpdatedItl = Integer.valueOf(countUpdatedItl + 1);
                pReqVars.put("countUpdatedItl", countUpdatedItl);
            } else {
                itl = new SalesInvoiceTaxLine();
                itl.setIsNew(true);
                itl.setIdDatabaseBirth(this.srvOrm.getIdDatabase());
                if (pTaxLnsNew != null) {
                    pTaxLnsNew.add(itl);
                }
            }
        }
        return itl;
    }

    public final SalesInvoiceServiceLine makeLine(List<SalesInvoiceServiceLine> pInvLns, Long pIlId, Long pCatId, Long pTaxId, Double pPercent, AccSettings pAs) {
        SalesInvoiceServiceLine invLn = null;
        for (SalesInvoiceServiceLine il : pInvLns) {
            if (!il.getItsId().equals(pIlId)) continue;
            invLn = il;
        }
        if (invLn == null) {
            invLn = new SalesInvoiceServiceLine();
            invLn.setItsId(pIlId);
            InvItemTaxCategory tc = new InvItemTaxCategory();
            tc.setItsId(pCatId);
            tc.setTaxes(new ArrayList<InvItemTaxCategoryLine>());
            invLn.setTaxCategory(tc);
            pInvLns.add(invLn);
        }
        InvItemTaxCategoryLine itcl = new InvItemTaxCategoryLine();
        Tax tax = new Tax();
        tax.setItsId(pTaxId);
        itcl.setTax(tax);
        itcl.setItsPercentage(BigDecimal.valueOf(pPercent).setScale((int)pAs.getTaxPrecision(), RoundingMode.HALF_UP));
        invLn.getTaxCategory().getTaxes().add(itcl);
        invLn.getTaxCategory().setAggrOnlyPercent(invLn.getTaxCategory().getAggrOnlyPercent().add(itcl.getItsPercentage()));
        return invLn;
    }

    public final void makeItl(Map<String, Object> pReqVars, SalesInvoiceTaxLine pItl, SalesInvoiceServiceLine pInvLn, boolean pIsItemBasis, boolean pIsPriceInclTax) throws Exception {
        pItl.setItsTotal(pItl.getItsTotal().add(pInvLn.getTotalTaxes()));
        pItl.setForeignTotalTaxes(pItl.getForeignTotalTaxes().add(pInvLn.getForeignTotalTaxes()));
        if (!pIsItemBasis) {
            if (pIsPriceInclTax) {
                pItl.setTaxableInvBas(pItl.getTaxableInvBas().add(pInvLn.getItsTotal()));
                pItl.setTaxableInvBasFc(pItl.getTaxableInvBasFc().add(pInvLn.getForeignTotal()));
            } else {
                pItl.setTaxableInvBas(pItl.getTaxableInvBas().add(pInvLn.getSubtotal()));
                pItl.setTaxableInvBasFc(pItl.getTaxableInvBasFc().add(pInvLn.getForeignSubtotal()));
            }
        }
        if (pItl.getIsNew().booleanValue()) {
            this.getSrvOrm().insertEntity(pReqVars, pItl);
            pItl.setIsNew(false);
        } else {
            this.getSrvOrm().updateEntity(pReqVars, pItl);
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final String getFileQuSalInvSaTaxItBasAggr() {
        return this.fileQuSalInvSaTaxItBasAggr;
    }

    public final void setFileQuSalInvSaTaxItBasAggr(String pFileQuSalInvSaTaxItBasAggr) {
        this.fileQuSalInvSaTaxItBasAggr = pFileQuSalInvSaTaxItBasAggr;
    }

    public final void setQuSalInvSaTaxItBasAggr(String pQuSalInvSaTaxItBasAggr) {
        this.quSalInvSaTaxItBasAggr = pQuSalInvSaTaxItBasAggr;
    }

    public final String getFileQuSalInvSaTaxItBas() {
        return this.fileQuSalInvSaTaxItBas;
    }

    public final void setFileQuSalInvSaTaxItBas(String pFileQuSalInvSaTaxItBas) {
        this.fileQuSalInvSaTaxItBas = pFileQuSalInvSaTaxItBas;
    }

    public final String getQuSalInvSaTaxItBas() {
        return this.quSalInvSaTaxItBas;
    }

    public final void setQuSalInvSaTaxItBas(String pQuSalInvSaTaxItBas) {
        this.quSalInvSaTaxItBas = pQuSalInvSaTaxItBas;
    }

    public final String getFileQuerySalesInvoiceTotals() {
        return this.fileQuerySalesInvoiceTotals;
    }

    public final void setFileQuerySalesInvoiceTotals(String pFileQuerySalesInvoiceTotals) {
        this.fileQuerySalesInvoiceTotals = pFileQuerySalesInvoiceTotals;
    }

    public final String getQuerySalesInvoiceTotals() {
        return this.querySalesInvoiceTotals;
    }

    public final void setQuerySalesInvoiceTotals(String pQuerySalesInvoiceTotals) {
        this.querySalesInvoiceTotals = pQuerySalesInvoiceTotals;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }
}

