/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.report;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.persistable.AccSettings;
import org.beigesoft.accounting.persistable.Currency;
import org.beigesoft.accounting.persistable.I18nAccounting;
import org.beigesoft.accounting.persistable.I18nBuyer;
import org.beigesoft.accounting.persistable.I18nCurrency;
import org.beigesoft.accounting.persistable.SalesInvoice;
import org.beigesoft.accounting.persistable.SalesInvoiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceServiceLine;
import org.beigesoft.accounting.persistable.SalesInvoiceTaxLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EUnitOfMeasure;
import org.beigesoft.doc.model.EWraping;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.model.IRequestData;
import org.beigesoft.pdf.model.PdfDocument;
import org.beigesoft.pdf.service.IPdfFactory;
import org.beigesoft.pdf.service.IPdfMaker;
import org.beigesoft.service.IEntityFileReporter;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvNumberToString;
import org.beigesoft.service.ISrvOrm;

public class InvoiceReportPdf<RS, WI>
implements IEntityFileReporter<SalesInvoice, Long> {
    private IPdfFactory<WI> pdfFactory;
    private ISrvAccSettings srvAccSettings;
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;
    private ISrvNumberToString srvNumberToString;
    private String salesInvOverseaseLinesSql;
    private String salesInvOverseaseServiceLinesSql;

    @Override
    public final void makeReport(Map<String, Object> pReqVars, SalesInvoice pInvoice, IRequestData pRequestData, OutputStream pOus) throws Exception {
        int k;
        int i;
        BigDecimal total;
        BigDecimal totalTaxes;
        BigDecimal subtotal;
        BigDecimal price;
        int rowc;
        String curSign;
        boolean isPrnCurLf;
        AccSettings accSet = this.srvAccSettings.lazyGetAccSettings(pReqVars);
        String lang = (String)pReqVars.get("lang");
        String langDef = (String)pReqVars.get("langDef");
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale(lang));
        SalesInvoice inv = this.retrieveEntity(pReqVars, pInvoice, lang, !lang.equals(langDef));
        boolean isInvoiceBasis = false;
        for (SalesInvoiceTaxLine itl : inv.getTaxesLines()) {
            if (itl.getTaxableInvBas().compareTo(BigDecimal.ZERO) != 1) continue;
            isInvoiceBasis = true;
            break;
        }
        Currency currency = inv.getForeignCurrency() != null ? inv.getForeignCurrency() : accSet.getCurrency();
        String priceName = inv.getPriceIncTax() != false ? "priceIncTax" : "itsPrice";
        I18nCurrency i18nCurrency = null;
        if (!lang.equals(langDef)) {
            List<I18nCurrency> i18nCurrencyLst = this.srvOrm.retrieveList(pReqVars, I18nCurrency.class);
            for (I18nCurrency i18nCur : i18nCurrencyLst) {
                if (!i18nCur.getHasName().getItsId().equals(currency.getItsId()) || !i18nCur.getLang().getItsId().equals(lang)) continue;
                i18nCurrency = i18nCur;
                break;
            }
        }
        if (i18nCurrency != null) {
            isPrnCurLf = i18nCurrency.getPrintCurrencyLeft();
            curSign = i18nCurrency.getUseCurrencySign().booleanValue() ? i18nCurrency.getHasName().getItsSign() : " " + i18nCurrency.getItsName() + " ";
        } else {
            isPrnCurLf = accSet.getPrintCurrencyLeft();
            curSign = accSet.getUseCurrencySign() != false ? currency.getItsSign() : " " + currency.getItsName() + " ";
        }
        Document<WI> doc = this.pdfFactory.lazyGetFctDocument().createDoc(accSet.getPageSize(), accSet.getPageOrientation());
        doc.setFontSize(accSet.getFontSize());
        doc.getPages().get(0).setMarginBottom(accSet.getMarginBottom());
        doc.getPages().get(0).setMarginTop(accSet.getMarginTop());
        doc.getPages().get(0).setMarginLeft(accSet.getMarginLeft());
        doc.getPages().get(0).setMarginRight(accSet.getMarginRight());
        PdfDocument<WI> docPdf = this.pdfFactory.createPdfDoc(doc);
        IDocumentMaker<WI> docMaker = this.pdfFactory.lazyGetDocumentMaker();
        docPdf.getPdfInfo().setAuthor("Beigesoft (TM) Accounting, " + accSet.getOrganization());
        IPdfMaker<WI> pdfMaker = this.pdfFactory.lazyGetPdfMaker();
        if (accSet.getTtfBoldFileName() != null) {
            pdfMaker.addFontTtf(docPdf, accSet.getTtfBoldFileName());
        }
        pdfMaker.addFontTtf(docPdf, accSet.getTtfFileName());
        double widthNdot = this.pdfFactory.lazyGetUomHelper().fromPoints(2.0, 300.0, doc.getUnitOfMeasure());
        doc.setBorder(widthNdot);
        doc.setContentPadding(0.0);
        doc.setContentPaddingBottom(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        DocTable<WI> tblOwner = docMaker.addDocTableNoBorder(doc, 1, 1);
        I18nAccounting i18nAccounting = (I18nAccounting)pReqVars.get("i18nAccounting");
        if (i18nAccounting != null) {
            tblOwner.getItsCells().get(0).setItsContent(i18nAccounting.getOrganizationName());
        } else {
            tblOwner.getItsCells().get(0).setItsContent(accSet.getOrganization());
        }
        int n = 0;
        if (accSet.getTaxIdentificationNumber() != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("taxIdentificationNumber", lang) + ": " + accSet.getTaxIdentificationNumber());
        }
        if (accSet.getRegZip() != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regZip", lang) + ": " + accSet.getRegZip());
        }
        String addr = null;
        addr = i18nAccounting != null ? i18nAccounting.getRegAddress1() : accSet.getRegAddress1();
        if (addr != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regAddress1", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegAddress2() : accSet.getRegAddress2()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regAddress2", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegCity() : accSet.getRegCity()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regCity", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegState() : accSet.getRegState()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regState", lang) + ": " + addr);
        }
        if ((addr = i18nAccounting != null ? i18nAccounting.getRegCountry() : accSet.getRegCountry()) != null) {
            docMaker.addRowToDocTable(tblOwner);
            tblOwner.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regCountry", lang) + ": " + addr);
        }
        tblOwner.getItsCells().get(0).setFontNumber(1);
        docMaker.makeDocTableWrapping(tblOwner);
        tblOwner.setAlignHorizontal(EAlignHorizontal.RIGHT);
        DocTable<WI> tblTitle = docMaker.addDocTableNoBorder(doc, 1, 1);
        String invNum = inv.getIdBirth() != null ? inv.getIdDatabaseBirth().toString() + "-" + inv.getIdBirth() : inv.getIdDatabaseBirth().toString() + "-" + inv.getItsId();
        String title = this.srvI18n.getMsg("Invoice", lang) + " #" + invNum + ", " + this.srvI18n.getMsg("date", lang) + ": " + dateFormat.format(inv.getItsDate());
        tblTitle.getItsCells().get(0).setItsContent(title);
        tblTitle.getItsCells().get(0).setFontNumber(1);
        tblTitle.setAlignHorizontal(EAlignHorizontal.CENTER);
        doc.setContainerMarginBottom(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
        docMaker.makeDocTableWrapping(tblTitle);
        DocTable<WI> tblCustomer = docMaker.addDocTableNoBorder(doc, 1, 1);
        I18nBuyer i18nBuyer = null;
        if (!lang.equals(langDef)) {
            i18nBuyer = this.getSrvOrm().retrieveEntityById(pReqVars, I18nBuyer.class, inv.getCustomer());
        }
        if (i18nBuyer != null) {
            tblCustomer.getItsCells().get(0).setItsContent(i18nBuyer.getItsName());
        } else {
            tblCustomer.getItsCells().get(0).setItsContent(inv.getCustomer().getItsName());
        }
        n = 0;
        if (inv.getCustomer().getTaxIdentificationNumber() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("taxIdentificationNumber", lang) + ": " + inv.getCustomer().getTaxIdentificationNumber());
        }
        if (inv.getCustomer().getRegZip() != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regZip", lang) + ": " + inv.getCustomer().getRegZip());
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegAddress1() : inv.getCustomer().getRegAddress1()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regAddress1", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegAddress2() : inv.getCustomer().getRegAddress2()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regAddress2", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegCity() : inv.getCustomer().getRegCity()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regCity", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegState() : inv.getCustomer().getRegState()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regState", lang) + ": " + addr);
        }
        if ((addr = i18nBuyer != null ? i18nBuyer.getRegCountry() : inv.getCustomer().getRegCountry()) != null) {
            docMaker.addRowToDocTable(tblCustomer);
            tblCustomer.getItsCells().get(++n).setItsContent(this.srvI18n.getMsg("regCountry", lang) + ": " + addr);
        }
        tblCustomer.getItsCells().get(0).setFontNumber(1);
        if (inv.getItsLines() != null && inv.getItsLines().size() > 0) {
            doc.setContainerMarginBottom(this.mmToDocUom(2.0, doc.getUnitOfMeasure()));
            DocTable<WI> tblTiGoods = docMaker.addDocTableNoBorder(doc, 1, 1);
            tblTiGoods.getItsCells().get(0).setItsContent(this.srvI18n.getMsg(SalesInvoiceLine.class.getSimpleName() + "s", lang));
            tblTiGoods.getItsCells().get(0).setFontNumber(1);
            tblTiGoods.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiGoods);
            doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
            doc.setContentPaddingBottom(this.mmToDocUom(1.5, doc.getUnitOfMeasure()));
            rowc = isInvoiceBasis ? 6 : (inv.getPriceIncTax() != false ? 7 : 8);
            DocTable<WI> tblGoods = docMaker.addDocTable(doc, rowc, inv.getItsLines().size() + 1);
            tblGoods.setIsRepeatHead(true);
            tblGoods.getItsRows().get(0).setIsHead(true);
            tblGoods.getItsCells().get(0).setItsContent(this.srvI18n.getMsg("invItem", lang).replace(" ", "\n"));
            tblGoods.getItsColumns().get(0).setIsWidthFixed(true);
            tblGoods.getItsColumns().get(0).setWidthInPercentage(60.0);
            tblGoods.getItsCells().get(1).setItsContent(this.srvI18n.getMsg("unitOfMeasure", lang).replace(" ", "\n"));
            tblGoods.getItsColumns().get(1).setWraping(EWraping.WRAP_CONTENT);
            tblGoods.getItsCells().get(2).setItsContent(this.srvI18n.getMsg(priceName, lang).replace(" ", "\n"));
            tblGoods.getItsColumns().get(2).setWraping(EWraping.WRAP_CONTENT);
            tblGoods.getItsCells().get(3).setItsContent(this.srvI18n.getMsg("itsQuantity", lang).replace(" ", "\n"));
            tblGoods.getItsColumns().get(3).setWraping(EWraping.WRAP_CONTENT);
            int pos = 3;
            if (!inv.getPriceIncTax().booleanValue()) {
                tblGoods.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("subtotal", lang).replace(" ", "\n"));
                tblGoods.getItsColumns().get(pos).setWraping(EWraping.WRAP_CONTENT);
            } else if (isInvoiceBasis && inv.getPriceIncTax().booleanValue()) {
                tblGoods.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("itsTotal", lang).replace(" ", "\n"));
                tblGoods.getItsColumns().get(pos).setWraping(EWraping.WRAP_CONTENT);
            }
            tblGoods.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("taxesDescription", lang));
            if (!isInvoiceBasis) {
                tblGoods.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("totalTaxes", lang).replace(" ", "\n"));
                tblGoods.getItsColumns().get(pos).setWraping(EWraping.WRAP_CONTENT);
                tblGoods.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("itsTotal", lang).replace(" ", "\n"));
                tblGoods.getItsColumns().get(pos).setWraping(EWraping.WRAP_CONTENT);
            }
            for (int i2 = 0; i2 < rowc; ++i2) {
                tblGoods.getItsCells().get(i2).setFontNumber(1);
                tblGoods.getItsCells().get(i2).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            int j = 1;
            for (SalesInvoiceLine ln : inv.getItsLines()) {
                if (inv.getForeignCurrency() != null) {
                    price = ln.getForeignPrice();
                    subtotal = ln.getForeignSubtotal();
                    totalTaxes = ln.getForeignTotalTaxes();
                    total = ln.getForeignTotal();
                } else {
                    price = ln.getItsPrice();
                    subtotal = ln.getSubtotal();
                    totalTaxes = ln.getTotalTaxes();
                    total = ln.getItsTotal();
                }
                int i3 = 0;
                int k2 = j * rowc + i3++;
                tblGoods.getItsCells().get(k2).setItsContent(ln.getInvItem().getItsName());
                k2 = j * rowc + i3++;
                tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.CENTER);
                tblGoods.getItsCells().get(k2).setItsContent(ln.getUnitOfMeasure().getItsName());
                k2 = j * rowc + i3++;
                tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.RIGHT);
                tblGoods.getItsCells().get(k2).setItsContent(this.prn(pReqVars, price));
                k2 = j * rowc + i3++;
                tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.RIGHT);
                tblGoods.getItsCells().get(k2).setItsContent(this.prn(pReqVars, ln.getItsQuantity()));
                if (!inv.getPriceIncTax().booleanValue()) {
                    k2 = j * rowc + i3++;
                    tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblGoods.getItsCells().get(k2).setItsContent(this.prn(pReqVars, subtotal));
                } else if (isInvoiceBasis && inv.getPriceIncTax().booleanValue()) {
                    k2 = j * rowc + i3++;
                    tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblGoods.getItsCells().get(k2).setItsContent(this.prn(pReqVars, total));
                }
                k2 = j * rowc + i3++;
                tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.CENTER);
                tblGoods.getItsCells().get(k2).setItsContent(ln.getTaxesDescription());
                if (!isInvoiceBasis) {
                    k2 = j * rowc + i3++;
                    tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblGoods.getItsCells().get(k2).setItsContent(this.prn(pReqVars, totalTaxes));
                    k2 = j * rowc + i3++;
                    tblGoods.getItsCells().get(k2).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblGoods.getItsCells().get(k2).setItsContent(this.prn(pReqVars, total));
                }
                ++j;
            }
        }
        if (inv.getServices() != null && inv.getServices().size() > 0) {
            double wd15;
            doc.setContainerMarginBottom(this.mmToDocUom(2.0, doc.getUnitOfMeasure()));
            DocTable<WI> tblTiServices = docMaker.addDocTableNoBorder(doc, 1, 1);
            tblTiServices.getItsCells().get(0).setItsContent(this.srvI18n.getMsg(SalesInvoiceServiceLine.class.getSimpleName() + "s", lang));
            tblTiServices.getItsCells().get(0).setFontNumber(1);
            tblTiServices.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiServices);
            doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
            doc.setContentPaddingBottom(this.mmToDocUom(1.5, doc.getUnitOfMeasure()));
            if (isInvoiceBasis) {
                rowc = 6;
                wd15 = 30.0;
            } else if (inv.getPriceIncTax().booleanValue()) {
                rowc = 7;
                wd15 = 15.0;
            } else {
                rowc = 8;
                wd15 = 15.0;
            }
            DocTable<WI> tblServices = docMaker.addDocTable(doc, rowc, inv.getServices().size() + 1);
            tblServices.setIsRepeatHead(true);
            tblServices.getItsRows().get(0).setIsHead(true);
            tblServices.getItsCells().get(0).setItsContent(this.srvI18n.getMsg("service", lang));
            tblServices.getItsColumns().get(0).setIsWidthFixed(true);
            tblServices.getItsColumns().get(0).setWidthInPercentage(35.0);
            tblServices.getItsCells().get(1).setItsContent(this.srvI18n.getMsg("unitOfMeasure", lang).replace(" ", "\n"));
            tblServices.getItsColumns().get(1).setWraping(EWraping.WRAP_CONTENT);
            tblServices.getItsCells().get(2).setItsContent(this.srvI18n.getMsg(priceName, lang).replace(" ", "\n"));
            tblServices.getItsColumns().get(2).setIsWidthFixed(true);
            tblServices.getItsColumns().get(2).setWidthInPercentage(wd15);
            tblServices.getItsCells().get(3).setItsContent(this.srvI18n.getMsg("itsQuantity", lang).replace(" ", "\n"));
            tblServices.getItsColumns().get(3).setWraping(EWraping.WRAP_CONTENT);
            int pos = 3;
            if (!inv.getPriceIncTax().booleanValue()) {
                tblServices.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("subtotal", lang).replace(" ", "\n"));
                tblServices.getItsColumns().get(pos).setWraping(EWraping.WRAP_CONTENT);
            } else if (isInvoiceBasis && inv.getPriceIncTax().booleanValue()) {
                tblServices.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("itsTotal", lang).replace(" ", "\n"));
                tblServices.getItsColumns().get(pos).setWraping(EWraping.WRAP_CONTENT);
            }
            tblServices.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("taxesDescription", lang));
            if (!isInvoiceBasis) {
                tblServices.getItsColumns().get(pos).setIsWidthFixed(true);
                tblServices.getItsColumns().get(pos).setWidthInPercentage(20.0);
                tblServices.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("totalTaxes", lang));
                tblServices.getItsColumns().get(pos).setIsWidthFixed(true);
                tblServices.getItsColumns().get(pos).setWidthInPercentage(wd15);
                tblServices.getItsCells().get(++pos).setItsContent(this.srvI18n.getMsg("itsTotal", lang));
                tblServices.getItsColumns().get(pos).setIsWidthFixed(true);
                tblServices.getItsColumns().get(pos).setWidthInPercentage(wd15);
            }
            for (int i4 = 0; i4 < rowc; ++i4) {
                tblServices.getItsCells().get(i4).setFontNumber(1);
                tblServices.getItsCells().get(i4).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            int j = 1;
            for (SalesInvoiceServiceLine ln : inv.getServices()) {
                if (inv.getForeignCurrency() != null) {
                    price = ln.getForeignPrice();
                    subtotal = ln.getForeignSubtotal();
                    totalTaxes = ln.getForeignTotalTaxes();
                    total = ln.getForeignTotal();
                } else {
                    price = ln.getItsPrice();
                    subtotal = ln.getSubtotal();
                    totalTaxes = ln.getTotalTaxes();
                    total = ln.getItsTotal();
                }
                i = 0;
                k = j * rowc + i++;
                tblServices.getItsCells().get(k).setItsContent(ln.getService().getItsName());
                k = j * rowc + i++;
                tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.CENTER);
                tblServices.getItsCells().get(k).setItsContent(ln.getUnitOfMeasure().getItsName());
                k = j * rowc + i++;
                tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                tblServices.getItsCells().get(k).setItsContent(this.prn(pReqVars, price));
                k = j * rowc + i++;
                tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                tblServices.getItsCells().get(k).setItsContent(this.prn(pReqVars, ln.getItsQuantity()));
                if (!inv.getPriceIncTax().booleanValue()) {
                    k = j * rowc + i++;
                    tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblServices.getItsCells().get(k).setItsContent(this.prn(pReqVars, subtotal));
                } else if (isInvoiceBasis && inv.getPriceIncTax().booleanValue()) {
                    k = j * rowc + i++;
                    tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblServices.getItsCells().get(k).setItsContent(this.prn(pReqVars, total));
                }
                k = j * rowc + i++;
                tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.CENTER);
                tblServices.getItsCells().get(k).setItsContent(ln.getTaxesDescription());
                if (!isInvoiceBasis) {
                    k = j * rowc + i++;
                    tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblServices.getItsCells().get(k).setItsContent(this.prn(pReqVars, totalTaxes));
                    k = j * rowc + i++;
                    tblServices.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblServices.getItsCells().get(k).setItsContent(this.prn(pReqVars, total));
                }
                ++j;
            }
        }
        if (inv.getTaxesLines() != null && inv.getTaxesLines().size() > 0) {
            double rowtw;
            doc.setContainerMarginBottom(this.mmToDocUom(2.0, doc.getUnitOfMeasure()));
            DocTable<WI> tblTiTaxes = docMaker.addDocTableNoBorder(doc, 1, 1);
            tblTiTaxes.setIsRepeatHead(true);
            tblTiTaxes.getItsRows().get(0).setIsHead(true);
            tblTiTaxes.getItsCells().get(0).setItsContent(this.srvI18n.getMsg(SalesInvoiceTaxLine.class.getSimpleName() + "s", lang));
            tblTiTaxes.getItsCells().get(0).setFontNumber(1);
            tblTiTaxes.setAlignHorizontal(EAlignHorizontal.CENTER);
            docMaker.makeDocTableWrapping(tblTiTaxes);
            doc.setContentPadding(this.mmToDocUom(1.0, doc.getUnitOfMeasure()));
            doc.setContentPaddingBottom(this.mmToDocUom(1.5, doc.getUnitOfMeasure()));
            if (isInvoiceBasis) {
                rowc = 3;
                rowtw = 40.0;
            } else {
                rowc = 2;
                rowtw = 70.0;
            }
            DocTable<WI> tblTaxes = docMaker.addDocTable(doc, rowc, inv.getTaxesLines().size() + 1);
            tblTaxes.getItsCells().get(0).setItsContent(this.srvI18n.getMsg("tax", lang));
            tblTaxes.getItsColumns().get(0).setIsWidthFixed(true);
            tblTaxes.getItsColumns().get(0).setWidthInPercentage(rowtw);
            if (isInvoiceBasis) {
                tblTaxes.getItsCells().get(1).setItsContent(this.srvI18n.getMsg("taxable", lang));
            }
            tblTaxes.getItsCells().get(rowc - 1).setItsContent(this.srvI18n.getMsg("itsTotal", lang));
            for (int i5 = 0; i5 < rowc; ++i5) {
                tblTaxes.getItsCells().get(i5).setFontNumber(1);
                tblTaxes.getItsCells().get(i5).setAlignHorizontal(EAlignHorizontal.CENTER);
            }
            int j = 1;
            for (SalesInvoiceTaxLine ln : inv.getTaxesLines()) {
                BigDecimal taxable;
                if (inv.getForeignCurrency() != null) {
                    taxable = ln.getTaxableInvBasFc();
                    total = ln.getForeignTotalTaxes();
                } else {
                    taxable = ln.getTaxableInvBas();
                    total = ln.getItsTotal();
                }
                i = 0;
                tblTaxes.getItsCells().get(j * rowc + i++).setItsContent(ln.getTax().getItsName());
                k = j * rowc + i++;
                if (isInvoiceBasis) {
                    tblTaxes.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                    tblTaxes.getItsCells().get(k).setItsContent(this.prn(pReqVars, taxable));
                    k = j * rowc + i++;
                }
                tblTaxes.getItsCells().get(k).setAlignHorizontal(EAlignHorizontal.RIGHT);
                tblTaxes.getItsCells().get(k).setItsContent(this.prn(pReqVars, total));
                ++j;
            }
        }
        doc.setAlignHoriCont(EAlignHorizontal.RIGHT);
        DocTable<WI> tblRez = docMaker.addDocTableNoBorder(doc, 2, 3);
        tblRez.getItsCells().get(0).setFontNumber(1);
        tblRez.getItsCells().get(0).setItsContent(this.srvI18n.getMsg("subtotal", lang) + ": ");
        tblRez.getItsCells().get(1).setFontNumber(1);
        if (inv.getForeignCurrency() != null) {
            subtotal = inv.getForeignSubtotal();
            totalTaxes = inv.getForeignTotalTaxes();
            total = inv.getForeignTotal();
        } else {
            subtotal = inv.getSubtotal();
            totalTaxes = inv.getTotalTaxes();
            total = inv.getItsTotal();
        }
        String cnt = isPrnCurLf ? curSign + this.prn(pReqVars, subtotal) : this.prn(pReqVars, subtotal) + curSign;
        tblRez.getItsCells().get(1).setItsContent(cnt);
        tblRez.getItsCells().get(2).setFontNumber(1);
        tblRez.getItsCells().get(2).setItsContent(this.srvI18n.getMsg("totalTaxes", lang) + ": ");
        tblRez.getItsCells().get(3).setFontNumber(1);
        cnt = isPrnCurLf ? curSign + this.prn(pReqVars, totalTaxes) : this.prn(pReqVars, totalTaxes) + curSign;
        tblRez.getItsCells().get(3).setItsContent(cnt);
        tblRez.getItsCells().get(4).setFontNumber(1);
        tblRez.getItsCells().get(4).setItsContent(this.srvI18n.getMsg("itsTotal", lang) + ": ");
        tblRez.getItsCells().get(5).setFontNumber(1);
        cnt = isPrnCurLf ? curSign + this.prn(pReqVars, total) : this.prn(pReqVars, total) + curSign;
        tblRez.getItsCells().get(5).setItsContent(cnt);
        tblRez.setAlignHorizontal(EAlignHorizontal.RIGHT);
        docMaker.makeDocTableWrapping(tblRez);
        docMaker.addPagination(doc);
        docMaker.deriveElements(doc);
        pdfMaker.prepareBeforeWrite(docPdf);
        this.pdfFactory.lazyGetPdfWriter().write(null, docPdf, pOus);
    }

    public final SalesInvoice retrieveEntity(Map<String, Object> pReqVars, SalesInvoice pInvoice, String pLang, boolean pIsOverseas) throws Exception {
        SalesInvoice inv = this.srvOrm.retrieveEntity(pReqVars, pInvoice);
        if (pIsOverseas) {
            HashSet<String> ndFlSil = new HashSet<String>();
            ndFlSil.add("itsId");
            ndFlSil.add("subtotal");
            ndFlSil.add("totalTaxes");
            ndFlSil.add("taxesDescription");
            ndFlSil.add("invItem");
            ndFlSil.add("unitOfMeasure");
            ndFlSil.add("itsQuantity");
            ndFlSil.add("itsPrice");
            ndFlSil.add("itsTotal");
            ndFlSil.add("foreignPrice");
            ndFlSil.add("foreignSubtotal");
            ndFlSil.add("foreignTotalTaxes");
            ndFlSil.add("foreignTotal");
            pReqVars.put("SalesInvoiceLineneededFields", ndFlSil);
            HashSet<String> ndFlItUm = new HashSet<String>();
            ndFlItUm.add("itsId");
            ndFlItUm.add("itsName");
            pReqVars.put("InvItemneededFields", ndFlItUm);
            pReqVars.put("UnitOfMeasureneededFields", ndFlItUm);
            inv.setItsLines(this.getSrvOrm().retrieveListByQuery(pReqVars, SalesInvoiceLine.class, this.evalSalesInvOverseaseLinesSql(inv.getItsId().toString(), pLang)));
            pReqVars.remove("SalesInvoiceLineneededFields");
            pReqVars.remove("InvItemneededFields");
            pReqVars.remove("UnitOfMeasureneededFields");
        } else {
            pReqVars.put("SalesInvoiceLineitsOwnerdeepLevel", 1);
            inv.setItsLines(this.getSrvOrm().retrieveListWithConditions(pReqVars, SalesInvoiceLine.class, "where REVERSEDID is null and ITSOWNER=" + inv.getItsId()));
            pReqVars.remove("SalesInvoiceLineitsOwnerdeepLevel");
        }
        SalesInvoiceTaxLine sitl = new SalesInvoiceTaxLine();
        sitl.setItsOwner(inv);
        pReqVars.put("SalesInvoiceTaxLineitsOwnerdeepLevel", 1);
        inv.setTaxesLines(this.getSrvOrm().retrieveListForField(pReqVars, sitl, "itsOwner"));
        pReqVars.remove("SalesInvoiceTaxLineitsOwnerdeepLevel");
        if (pIsOverseas) {
            HashSet<String> ndFlSil = new HashSet<String>();
            ndFlSil.add("itsId");
            ndFlSil.add("subtotal");
            ndFlSil.add("totalTaxes");
            ndFlSil.add("taxesDescription");
            ndFlSil.add("unitOfMeasure");
            ndFlSil.add("itsQuantity");
            ndFlSil.add("service");
            ndFlSil.add("itsPrice");
            ndFlSil.add("itsTotal");
            ndFlSil.add("foreignPrice");
            ndFlSil.add("foreignSubtotal");
            ndFlSil.add("foreignTotalTaxes");
            ndFlSil.add("foreignTotal");
            pReqVars.put("SalesInvoiceServiceLineneededFields", ndFlSil);
            HashSet<String> ndFlItUm = new HashSet<String>();
            ndFlItUm.add("itsId");
            ndFlItUm.add("itsName");
            pReqVars.put("ServiceToSaleneededFields", ndFlItUm);
            pReqVars.put("UnitOfMeasureneededFields", ndFlItUm);
            inv.setServices(this.getSrvOrm().retrieveListByQuery(pReqVars, SalesInvoiceServiceLine.class, this.evalSalesInvOverseaseServiceLinesSql(inv.getItsId().toString(), pLang)));
            pReqVars.remove("SalesInvoiceServiceLineneededFields");
            pReqVars.remove("ServiceToSaleneededFields");
            pReqVars.remove("UnitOfMeasureneededFields");
        } else {
            SalesInvoiceServiceLine sisl = new SalesInvoiceServiceLine();
            sisl.setItsOwner(inv);
            pReqVars.put("SalesInvoiceServiceLineitsOwnerdeepLevel", 1);
            inv.setServices(this.getSrvOrm().retrieveListForField(pReqVars, sisl, "itsOwner"));
        }
        pReqVars.remove("SalesInvoiceServiceLineitsOwnerdeepLevel");
        return inv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String evalSalesInvOverseaseServiceLinesSql(String pItsOwnerId, String pLang) throws Exception {
        if (this.salesInvOverseaseServiceLinesSql == null) {
            InvoiceReportPdf invoiceReportPdf = this;
            synchronized (invoiceReportPdf) {
                if (this.salesInvOverseaseServiceLinesSql == null) {
                    String flName = "/accounting/trade/salesInvOverseaseServiceLines.sql";
                    this.salesInvOverseaseServiceLinesSql = this.loadString(flName);
                }
            }
        }
        String query = this.salesInvOverseaseServiceLinesSql.replace(":ITSOWNER", pItsOwnerId).replace(":LANG", pLang);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String evalSalesInvOverseaseLinesSql(String pItsOwnerId, String pLang) throws Exception {
        if (this.salesInvOverseaseLinesSql == null) {
            InvoiceReportPdf invoiceReportPdf = this;
            synchronized (invoiceReportPdf) {
                if (this.salesInvOverseaseLinesSql == null) {
                    String flName = "/accounting/trade/salesInvOverseaseLines.sql";
                    this.salesInvOverseaseLinesSql = this.loadString(flName);
                }
            }
        }
        String query = this.salesInvOverseaseLinesSql.replace(":ITSOWNER", pItsOwnerId).replace(":LANG", pLang);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = InvoiceReportPdf.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = InvoiceReportPdf.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final String prn(Map<String, Object> pReqVars, BigDecimal pVal) {
        return this.srvNumberToString.print(pVal.toString(), (String)pReqVars.get("dseparatorv"), (String)pReqVars.get("dgseparatorv"), (Integer)pReqVars.get("pricePrecision"), (Integer)pReqVars.get("digitsInGroup"));
    }

    public final double mmToDocUom(double pValue, EUnitOfMeasure pUom) {
        if (pUom.equals((Object)EUnitOfMeasure.INCH)) {
            return pValue / 25.4;
        }
        return pValue;
    }

    public final synchronized String getSalesInvOverseaseLinesSql() {
        return this.salesInvOverseaseLinesSql;
    }

    public final synchronized void setSalesInvOverseaseLinesSql(String pSalesInvOverseaseLinesSql) {
        this.salesInvOverseaseLinesSql = pSalesInvOverseaseLinesSql;
    }

    public final synchronized String getSalesInvOverseaseServiceLinesSql() {
        return this.salesInvOverseaseServiceLinesSql;
    }

    public final synchronized void setSalesInvOverseaseServiceLinesSql(String pSalesInvOverseaseServiceLinesSql) {
        this.salesInvOverseaseServiceLinesSql = pSalesInvOverseaseServiceLinesSql;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IPdfFactory<WI> getPdfFactory() {
        return this.pdfFactory;
    }

    public final void setPdfFactory(IPdfFactory<WI> pFactory) {
        this.pdfFactory = pFactory;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }

    public final ISrvNumberToString getSrvNumberToString() {
        return this.srvNumberToString;
    }

    public final void setSrvNumberToString(ISrvNumberToString pSrvNumberToString) {
        this.srvNumberToString = pSrvNumberToString;
    }
}

