/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.accounting.model.CmprAccSourcesByType;
import org.beigesoft.accounting.persistable.AccEntriesSourcesLine;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.persistable.AccountingEntry;
import org.beigesoft.accounting.persistable.IDoc;
import org.beigesoft.accounting.service.ISrvAccEntry;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvBalance;
import org.beigesoft.accounting.service.ISrvTypeCode;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;

public class SrvAccEntry<RS>
implements ISrvAccEntry {
    private ISrvI18n srvI18n;
    private ISrvOrm<RS> srvOrm;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvBalance srvBalance;
    private ISrvAccSettings srvAccSettings;
    private ISrvTypeCode srvTypeCode;
    private final Map<String, String> queries = new HashMap<String, String>();
    private CmprAccSourcesByType cmprAccSourcesByType = new CmprAccSourcesByType();

    public SrvAccEntry() {
    }

    public SrvAccEntry(ISrvOrm<RS> pSrvOrm, ISrvDatabase<RS> pSrvDatabase, ISrvTypeCode pSrvTypeCode, ISrvAccSettings pSrvAccSettings, ISrvBalance pSrvBalance, ISrvI18n pSrvI18n) {
        this.srvDatabase = pSrvDatabase;
        this.srvBalance = pSrvBalance;
        this.srvOrm = pSrvOrm;
        this.srvTypeCode = pSrvTypeCode;
        this.srvAccSettings = pSrvAccSettings;
        this.srvI18n = pSrvI18n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void makeEntries(Map<String, Object> pAddParam, IDoc pEntity) throws Exception {
        String query;
        Calendar calCurrYear = Calendar.getInstance(new Locale("en", "US"));
        calCurrYear.setTime(this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCurrentAccYear());
        calCurrYear.set(2, 0);
        calCurrYear.set(5, 1);
        calCurrYear.set(11, 0);
        calCurrYear.set(12, 0);
        calCurrYear.set(13, 0);
        calCurrYear.set(14, 0);
        Calendar calDoc = Calendar.getInstance(new Locale("en", "US"));
        calDoc.setTime(pEntity.getItsDate());
        calDoc.set(2, 0);
        calDoc.set(5, 1);
        calDoc.set(11, 0);
        calDoc.set(12, 0);
        calDoc.set(13, 0);
        calDoc.set(14, 0);
        if (calCurrYear.getTime().getTime() != calDoc.getTime().getTime()) {
            throw new ExceptionWithCode(1003, "wrong_year");
        }
        StringBuffer sb = new StringBuffer();
        List<AccEntriesSourcesLine> sourcesLines = this.srvAccSettings.lazyGetAccSettings(pAddParam).getAccEntriesSources();
        Collections.sort(sourcesLines, this.cmprAccSourcesByType);
        int i = 0;
        for (AccEntriesSourcesLine sourcesLine : sourcesLines) {
            if (!sourcesLine.getIsUsed().booleanValue() || !sourcesLine.getSourceType().equals(pEntity.constTypeCode())) continue;
            query = this.lazyGetQuery(sourcesLine.getFileName());
            String idName = "ITSID";
            if (pEntity.getIdBirth() != null) {
                idName = "IDBIRTH";
            }
            query = query.replace(":IDNAME", idName);
            String strWhereDocId = sourcesLine.getSourceIdName() + " = " + ((Long)pEntity.getItsId()).toString();
            if (query.contains(":WHEREADD")) {
                query = query.replace(":WHEREADD", " and " + strWhereDocId);
            } else if (query.contains(":WHERE")) {
                query = query.replace(":WHERE", " where " + strWhereDocId);
            }
            if (i++ > 0) {
                sb.append("\nunion all\n\n");
            }
            sb.append(query);
        }
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        query = sb.toString();
        if (query.trim().length() == 0) {
            throw new ExceptionWithCode(1002, "there_is_no_accounting_sources");
        }
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(query);
            if (recordSet.moveToFirst()) {
                Long itsDateLong = null;
                do {
                    AccountingEntry accEntry = new AccountingEntry();
                    accEntry.setIdDatabaseBirth(this.getSrvDatabase().getIdDatabase());
                    if (itsDateLong == null) {
                        itsDateLong = pEntity.getItsDate().getTime();
                        this.getSrvBalance().handleNewAccountEntry(pAddParam, null, null, new Date(itsDateLong));
                    }
                    Long l = itsDateLong;
                    Long l2 = itsDateLong = Long.valueOf(itsDateLong + 1L);
                    Date itsDate = new Date(l);
                    accEntry.setItsDate(itsDate);
                    accEntry.setSourceType(pEntity.constTypeCode());
                    if (pEntity.getIdBirth() != null) {
                        accEntry.setSourceId(pEntity.getIdBirth());
                    } else {
                        accEntry.setSourceId((Long)pEntity.getItsId());
                    }
                    accEntry.setSourceDatabaseBirth(pEntity.getIdDatabaseBirth());
                    String accDebitId = recordSet.getString("ACCDEBIT");
                    Account accDebit = new Account();
                    accDebit.setItsId(accDebitId);
                    accEntry.setAccDebit(accDebit);
                    accEntry.setSubaccDebitType(recordSet.getInteger("SUBACCDEBITTYPE"));
                    accEntry.setSubaccDebitId(recordSet.getLong("SUBACCDEBITID"));
                    accEntry.setSubaccDebit(recordSet.getString("SUBACCDEBIT"));
                    accEntry.setDebit(BigDecimal.valueOf(recordSet.getDouble("DEBIT")).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    String accCreditId = recordSet.getString("ACCCREDIT");
                    Account accCredit = new Account();
                    accCredit.setItsId(accCreditId);
                    accEntry.setAccCredit(accCredit);
                    accEntry.setSubaccCreditType(recordSet.getInteger("SUBACCCREDITTYPE"));
                    accEntry.setSubaccCreditId(recordSet.getLong("SUBACCCREDITID"));
                    accEntry.setSubaccCredit(recordSet.getString("SUBACCCREDIT"));
                    accEntry.setCredit(BigDecimal.valueOf(recordSet.getDouble("CREDIT")).setScale((int)this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getCostPrecision(), this.getSrvAccSettings().lazyGetAccSettings(pAddParam).getRoundingMode()));
                    String docId = ((Long)pEntity.getItsId()).toString();
                    if (pEntity.getIdBirth() != null) {
                        docId = pEntity.getIdBirth().toString();
                    }
                    String descr = "";
                    if (pEntity.getDescription() != null) {
                        descr = " " + pEntity.getDescription();
                    }
                    accEntry.setDescription(this.getSrvI18n().getMsg(pEntity.getClass().getSimpleName() + "short", langDef) + " #" + pEntity.getIdDatabaseBirth() + "-" + docId + ", " + dateFormat.format(pEntity.getItsDate()) + descr);
                    this.srvOrm.insertEntity(pAddParam, accEntry);
                    accEntry.setIsNew(false);
                } while (recordSet.moveToNext());
            }
        }
        pEntity.setHasMadeAccEntries(true);
        this.srvOrm.updateEntity(pAddParam, pEntity);
    }

    @Override
    public final void reverseEntries(Map<String, Object> pAddParam, IDoc pReversing, IDoc pReversed) throws Exception {
        List<AccountingEntry> sources = this.getSrvOrm().retrieveListWithConditions(pAddParam, AccountingEntry.class, " where SOURCETYPE=" + pReversing.constTypeCode() + " and SOURCEID=" + pReversing.getReversedId() + " and SOURCEDATABASEBIRTH=" + pReversing.getReversedIdDatabaseBirth());
        Long itsDateLong = null;
        String langDef = (String)pAddParam.get("langDef");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3, new Locale(langDef));
        for (AccountingEntry source : sources) {
            if (!source.getIdDatabaseBirth().equals(this.getSrvDatabase().getIdDatabase())) {
                throw new ExceptionWithCode(1003, "can_not_reverse_foreign_acconting_entries");
            }
            if (itsDateLong == null) {
                itsDateLong = pReversing.getItsDate().getTime();
                this.getSrvBalance().handleNewAccountEntry(pAddParam, null, null, new Date(itsDateLong));
            }
            AccountingEntry accEntry = new AccountingEntry();
            Long l = itsDateLong;
            Long l2 = itsDateLong = Long.valueOf(itsDateLong + 1L);
            accEntry.setItsDate(new Date(l));
            accEntry.setIdDatabaseBirth(this.getSrvDatabase().getIdDatabase());
            accEntry.setSourceType(pReversing.constTypeCode());
            Long reversingDocId = (Long)pReversing.getItsId();
            if (pReversing.getIdBirth() != null) {
                reversingDocId = pReversing.getIdBirth();
            }
            accEntry.setSourceId(reversingDocId);
            accEntry.setSourceDatabaseBirth(pReversing.getIdDatabaseBirth());
            accEntry.setAccDebit(source.getAccDebit());
            accEntry.setSubaccDebitType(source.getSubaccDebitType());
            accEntry.setSubaccDebitId(source.getSubaccDebitId());
            accEntry.setSubaccDebit(source.getSubaccDebit());
            if (source.getDebit() != null) {
                accEntry.setDebit(source.getDebit().negate());
            }
            accEntry.setAccCredit(source.getAccCredit());
            accEntry.setSubaccCreditType(source.getSubaccCreditType());
            accEntry.setSubaccCreditId(source.getSubaccCreditId());
            accEntry.setSubaccCredit(source.getSubaccCredit());
            if (source.getCredit() != null) {
                accEntry.setCredit(source.getCredit().negate());
            }
            accEntry.setDescription(this.getSrvI18n().getMsg("made_at", langDef) + " " + dateFormat.format(new Date()) + " " + this.getSrvI18n().getMsg("by", langDef) + " " + this.getSrvI18n().getMsg(pReversing.getClass().getSimpleName() + "short", langDef) + " #" + pReversing.getIdDatabaseBirth() + "-" + reversingDocId + ", " + dateFormat.format(pReversing.getItsDate()) + ", " + this.getSrvI18n().getMsg("reversed_entry_n", langDef) + source.getIdDatabaseBirth() + "-" + source.getItsId());
            accEntry.setReversedId(source.getItsId());
            accEntry.setReversedIdDatabaseBirth(source.getIdDatabaseBirth());
            this.srvOrm.insertEntity(pAddParam, accEntry);
            accEntry.setIsNew(false);
            source.setDescription(source.getDescription().trim() + " " + this.getSrvI18n().getMsg("reversing_entry_n", langDef) + accEntry.getIdDatabaseBirth() + "-" + accEntry.getItsId());
            source.setReversedId(accEntry.getItsId());
            source.setReversedIdDatabaseBirth(accEntry.getIdDatabaseBirth());
            this.srvOrm.updateEntity(pAddParam, source);
        }
        pReversing.setHasMadeAccEntries(true);
        this.srvOrm.updateEntity(pAddParam, pReversing);
    }

    @Override
    public final List<AccountingEntry> retrieveAccEntriesFor(Map<String, Object> pAddParam, IDoc pEntity) throws Exception {
        Long docId = (Long)pEntity.getItsId();
        if (pEntity.getIdBirth() != null) {
            docId = pEntity.getIdBirth();
        }
        List<AccountingEntry> result = this.getSrvOrm().retrieveListWithConditions(pAddParam, AccountingEntry.class, " where SOURCETYPE=" + pEntity.constTypeCode() + " and SOURCEID=" + docId + " and SOURCEDATABASEBIRTH=" + pEntity.getIdDatabaseBirth());
        return result;
    }

    @Override
    public final void makeEntriesAll(Map<String, Object> pAddParam) throws Exception {
        throw new Exception("Doesn't implemented yet");
    }

    public final String lazyGetQuery(String pFileName) throws Exception {
        if (this.queries.get(pFileName) == null) {
            String flName = "/accounting/journalEntries/" + pFileName + ".sql";
            this.queries.put(pFileName, this.loadString(flName));
        }
        return this.queries.get(pFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = SrvAccEntry.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvAccEntry.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ISrvAccSettings getSrvAccSettings() {
        return this.srvAccSettings;
    }

    public final void setSrvAccSettings(ISrvAccSettings pSrvAccSettings) {
        this.srvAccSettings = pSrvAccSettings;
    }

    public final ISrvBalance getSrvBalance() {
        return this.srvBalance;
    }

    public final void setSrvBalance(ISrvBalance pSrvBalance) {
        this.srvBalance = pSrvBalance;
    }

    public final ISrvTypeCode getSrvTypeCode() {
        return this.srvTypeCode;
    }

    public final void setSrvTypeCode(ISrvTypeCode pSrvTypeCode) {
        this.srvTypeCode = pSrvTypeCode;
    }

    public final Map<String, String> getQueries() {
        return this.queries;
    }

    public final CmprAccSourcesByType getCmprAccSourcesByType() {
        return this.cmprAccSourcesByType;
    }

    public final void setCmprAccSourcesByType(CmprAccSourcesByType pCmprAccSourcesByType) {
        this.cmprAccSourcesByType = pCmprAccSourcesByType;
    }

    public final ISrvI18n getSrvI18n() {
        return this.srvI18n;
    }

    public final void setSrvI18n(ISrvI18n pSrvI18n) {
        this.srvI18n = pSrvI18n;
    }
}

