/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.service;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.beigesoft.accounting.model.WarehouseSiteRestLine;
import org.beigesoft.accounting.service.ISrvWarehouseSiteRests;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.service.ISrvDatabase;

public class SrvWarehouseSiteRests<RS>
implements ISrvWarehouseSiteRests {
    private ISrvDatabase<RS> srvDatabase;
    private String queryMain;

    public SrvWarehouseSiteRests() {
    }

    public SrvWarehouseSiteRests(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<WarehouseSiteRestLine> retrieveWarehouseSiteRests(Map<String, Object> pAddParam) throws Exception {
        ArrayList<WarehouseSiteRestLine> result = new ArrayList<WarehouseSiteRestLine>();
        if (this.queryMain == null) {
            String flName = "/accounting/warehouse/rests-in-sites.sql";
            this.queryMain = this.loadString(flName);
        }
        try (IRecordSet<RS> recordSet = null;){
            recordSet = this.getSrvDatabase().retrieveRecords(this.queryMain);
            if (recordSet.moveToFirst()) {
                do {
                    WarehouseSiteRestLine wrl = new WarehouseSiteRestLine();
                    wrl.setWarehouse(recordSet.getString("WAREHOUSE"));
                    wrl.setWarehouseSite(recordSet.getString("WAREHOUSESITE"));
                    wrl.setInvItemId(recordSet.getLong("INVITEMID"));
                    wrl.setInvItem(recordSet.getString("INVITEM"));
                    wrl.setUnitOfMeasure(recordSet.getString("UNITOFMEASURE"));
                    wrl.setTheRest(BigDecimal.valueOf(recordSet.getDouble("THEREST")));
                    result.add(wrl);
                } while (recordSet.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String loadString(String pFileName) throws IOException {
        URL urlFile = SrvWarehouseSiteRests.class.getResource(pFileName);
        if (urlFile != null) {
            try (InputStream inputStream = null;){
                inputStream = SrvWarehouseSiteRests.class.getResourceAsStream(pFileName);
                byte[] bArray = new byte[inputStream.available()];
                inputStream.read(bArray, 0, inputStream.available());
                String string = new String(bArray, "UTF-8");
                return string;
            }
        }
        return null;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final String getQueryMain() {
        return this.queryMain;
    }

    public final void setQueryMain(String pQueryMain) {
        this.queryMain = pQueryMain;
    }
}

