/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.accounting.model.AccountInChart;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.persistable.SubaccountLine;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.web.model.HttpRequestData;

public class WChartOfAccounts<RS>
extends HttpServlet {
    private IFactoryAppBeans factoryAppBeans;
    private String dirJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
        try {
            this.factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "INIT", e);
                }
            }
            throw new ServletException(e);
        }
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        try {
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            ISrvDatabase srvDatabase = (ISrvDatabase)this.factoryAppBeans.lazyGet("ISrvDatabase");
            ISrvOrm srvOrm = (ISrvOrm)this.factoryAppBeans.lazyGet("ISrvOrm");
            List<Account> accounts = null;
            ArrayList<AccountInChart> accountsInChart = new ArrayList<AccountInChart>();
            HashMap<String, Object> addParam = new HashMap<String, Object>();
            try {
                srvDatabase.setIsAutocommit(false);
                srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                srvDatabase.beginTransaction();
                accounts = srvOrm.retrieveListWithConditions(addParam, Account.class, "where ISUSED=1 order by ITSNUMBER");
                for (Account acc : accounts) {
                    AccountInChart accInChart = new AccountInChart();
                    accInChart.setItsId(acc.getItsId());
                    accInChart.setItsName(acc.getItsName());
                    accInChart.setItsNumber(acc.getItsNumber());
                    accInChart.setDescription(acc.getDescription());
                    accInChart.setItsType(acc.getItsType());
                    accInChart.setNormalBalanceType(acc.getNormalBalanceType());
                    if (acc.getSubaccType() == null) {
                        accountsInChart.add(accInChart);
                        continue;
                    }
                    SubaccountLine sal = new SubaccountLine();
                    sal.setItsOwner(acc);
                    List<SubaccountLine> subaccounts = srvOrm.retrieveListForField(addParam, sal, "itsOwner");
                    if (subaccounts.size() > 0) {
                        for (SubaccountLine subacc : subaccounts) {
                            if (accInChart != null) {
                                accInChart.setSubacc(subacc.getSubaccName());
                                accountsInChart.add(accInChart);
                                accInChart = null;
                                continue;
                            }
                            AccountInChart subaccInChart = new AccountInChart();
                            subaccInChart.setSubacc(subacc.getSubaccName());
                            accountsInChart.add(subaccInChart);
                        }
                        continue;
                    }
                    accountsInChart.add(accInChart);
                }
                srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                srvDatabase.rollBackTransaction();
                throw ex;
            }
            finally {
                srvDatabase.releaseResources();
            }
            String nmRnd = pReq.getParameter("nmRnd");
            String path = this.dirJsp + nmRnd + ".jsp";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            ISrvI18n srvI18n = (ISrvI18n)this.factoryAppBeans.lazyGet("ISrvI18n");
            ISrvAccSettings srvAccSettings = (ISrvAccSettings)this.factoryAppBeans.lazyGet("ISrvAccSettings");
            pReq.setAttribute("accSettings", srvAccSettings.lazyGetAccSettings(addParam));
            pReq.setAttribute("utlJsp", this.factoryAppBeans.lazyGet("UtlJsp"));
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("accounts", accountsInChart);
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }
}

