/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.accounting.servlet;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beigesoft.accounting.model.LedgerDetail;
import org.beigesoft.accounting.model.LedgerPrevious;
import org.beigesoft.accounting.persistable.Account;
import org.beigesoft.accounting.service.ISrvAccSettings;
import org.beigesoft.accounting.service.ISrvLedger;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeans;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.log.ILogger;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvDate;
import org.beigesoft.service.ISrvI18n;
import org.beigesoft.service.ISrvOrm;
import org.beigesoft.web.model.HttpRequestData;

public class WLedger<RS>
extends HttpServlet {
    private IFactoryAppBeans factoryAppBeans;
    private String dirJsp;

    @Override
    public final void init() throws ServletException {
        this.dirJsp = this.getInitParameter("dirJsp");
        try {
            this.factoryAppBeans = (IFactoryAppBeans)this.getServletContext().getAttribute("IFactoryAppBeans");
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "INIT", e);
                }
            }
            throw new ServletException(e);
        }
    }

    @Override
    public final void doGet(HttpServletRequest pReq, HttpServletResponse pResp) throws ServletException, IOException {
        pReq.setCharacterEncoding("UTF-8");
        pResp.setCharacterEncoding("UTF-8");
        try {
            HashMap<String, Object> reqVars = new HashMap<String, Object>();
            HttpRequestData requestData = new HttpRequestData(pReq, pResp);
            requestData.setAttribute("reqVars", reqVars);
            IHandlerRequest hndlI18nRequest = (IHandlerRequest)this.factoryAppBeans.lazyGet("hndlI18nRequest");
            hndlI18nRequest.handle(reqVars, requestData);
            ISrvLedger srvLedger = (ISrvLedger)this.factoryAppBeans.lazyGet("ISrvLedger");
            ISrvDatabase srvDatabase = (ISrvDatabase)this.factoryAppBeans.lazyGet("ISrvDatabase");
            ISrvOrm srvOrm = (ISrvOrm)this.factoryAppBeans.lazyGet("ISrvOrm");
            String userName = null;
            if (pReq.getUserPrincipal() != null) {
                userName = pReq.getUserPrincipal().getName();
            }
            HashMap<String, Object> addParam = new HashMap<String, Object>();
            addParam.put("user", userName);
            addParam.put("parameterMap", pReq.getParameterMap());
            ISrvDate srvDate = (ISrvDate)this.factoryAppBeans.lazyGet("ISrvDate");
            Date date1 = srvDate.fromIso8601DateTimeNoTz(pReq.getParameter("date1"), null);
            Date date2 = srvDate.fromIso8601DateTimeNoTz(pReq.getParameter("date2"), null);
            String accId = pReq.getParameter("accId");
            String subaccId = pReq.getParameter("subaccId");
            String subaccName = pReq.getParameter("subaccName");
            if (subaccId != null && subaccId.trim().length() == 0) {
                subaccId = null;
            }
            if (subaccName != null && subaccName.trim().length() == 0) {
                subaccName = null;
            }
            LedgerPrevious ledgerPrevious = null;
            LedgerDetail ledgerDetail = null;
            Account account = null;
            try {
                srvDatabase.setIsAutocommit(false);
                srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                srvDatabase.beginTransaction();
                account = new Account();
                account.setItsId(accId);
                account = srvOrm.retrieveEntity(addParam, account);
                ledgerPrevious = srvLedger.retrievePrevious(addParam, account, date1, subaccId);
                ledgerDetail = srvLedger.retrieveDetail(addParam, account, date1, date2, subaccId, ledgerPrevious);
                srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                srvDatabase.rollBackTransaction();
                throw ex;
            }
            finally {
                srvDatabase.releaseResources();
            }
            String nmRnd = pReq.getParameter("nmRnd");
            String path = this.dirJsp + nmRnd + ".jsp";
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            ISrvI18n srvI18n = (ISrvI18n)this.factoryAppBeans.lazyGet("ISrvI18n");
            pReq.setAttribute("utlJsp", this.factoryAppBeans.lazyGet("UtlJsp"));
            pReq.setAttribute("srvI18n", srvI18n);
            pReq.setAttribute("srvDate", srvDate);
            pReq.setAttribute("account", account);
            pReq.setAttribute("subaccName", subaccName);
            pReq.setAttribute("ledgerPrevious", ledgerPrevious);
            pReq.setAttribute("ledgerDetail", ledgerDetail);
            pReq.setAttribute("date1", date1);
            pReq.setAttribute("date2", date2);
            ISrvAccSettings srvAccSettings = (ISrvAccSettings)this.factoryAppBeans.lazyGet("ISrvAccSettings");
            pReq.setAttribute("accSettings", srvAccSettings.lazyGetAccSettings(addParam));
            rd.include(pReq, pResp);
        }
        catch (Exception e) {
            if (this.factoryAppBeans != null) {
                ILogger logger = null;
                try {
                    logger = (ILogger)this.factoryAppBeans.lazyGet("ILogger");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (logger != null) {
                    logger.error(null, this.getClass(), "WORK", e);
                } else {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
            if (e instanceof ExceptionWithCode) {
                pReq.setAttribute("error_code", ((ExceptionWithCode)e).getCode());
                pReq.setAttribute("short_message", ((ExceptionWithCode)e).getShortMessage());
            } else {
                pReq.setAttribute("error_code", 500);
            }
            pReq.setAttribute("javax.servlet.error.status_code", 500);
            pReq.setAttribute("javax.servlet.error.exception", e);
            pReq.setAttribute("javax.servlet.error.request_uri", pReq.getRequestURI());
            pReq.setAttribute("javax.servlet.error.servlet_name", this.getClass().getCanonicalName());
            pResp.sendError(500);
        }
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final void setFactoryAppBeans(IFactoryAppBeans pFactoryAppBeans) {
        this.factoryAppBeans = pFactoryAppBeans;
    }

    public final String getDirJsp() {
        return this.dirJsp;
    }

    public final void setDirJsp(String pDirJsp) {
        this.dirJsp = pDirJsp;
    }
}

