/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.ajetty;

import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.beigesoft.afactory.IFactoryAppBeans;
import org.beigesoft.ajetty.BootStrapCli;
import org.beigesoft.ajetty.BootStrapEmbeddedHttps;
import org.beigesoft.ajetty.BootStrapEmbeddedHttpsSwing;
import org.beigesoft.ajetty.ExceptionStart;
import org.beigesoft.ajetty.FactoryAppBeansEmbedded;
import org.beigesoft.ajetty.IBootStrapIFace;
import org.beigesoft.ajetty.crypto.CryptoService;
import org.beigesoft.log.ILogger;
import org.beigesoft.log.LoggerFile;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class BootStrapEmbeddedMain {
    private final IFactoryAppBeans factoryAppBeans;
    private final BootStrapEmbeddedHttps bootStrapEmbeddedHttps;
    private ResourceBundle messages;
    private boolean isActionPerforming = false;
    private long lastActionStartDate;
    private Integer ajettyIn;
    private Integer port = 8443;
    private boolean isKeystoreCreated;
    private CryptoService cryptoService;
    private ILogger logger;
    private boolean isDebug = false;
    private KeyStore keyStore;
    private char[] ksPassword;
    private char[] ksPasswordConf;
    private IBootStrapIFace bootStrapIFace;
    private boolean isLastStartFail = false;

    public BootStrapEmbeddedMain() throws ExceptionStart {
        String appDir = null;
        try {
            File jarBoot = new File(BootStrapEmbeddedMain.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            appDir = jarBoot.getParent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (appDir == null) {
            appDir = System.getProperty("user.dir");
        }
        if (this.logger == null) {
            LoggerFile log = new LoggerFile();
            log.setFilePath(appDir + File.separator + "starter");
            log.setIsCloseFileAfterRecord(true);
            this.logger = log;
        }
        try {
            this.messages = ResourceBundle.getBundle("MessagesAjetty");
        }
        catch (Exception e) {
            this.logger.error(null, BootStrapEmbeddedMain.class, "Can't load messages for default locale", e);
            try {
                Locale locale = new Locale("en", "US");
                this.messages = ResourceBundle.getBundle("MessagesAjetty", locale);
            }
            catch (Exception e1) {
                this.logger.error(null, BootStrapEmbeddedMain.class, "Can't load messages for en-US", e1);
            }
        }
        try {
            List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String str : arguments) {
                if (!str.contains("jdwp") && !str.contains("debug")) continue;
                this.isDebug = true;
            }
        }
        catch (Exception e) {
            this.logger.warn(null, BootStrapEmbeddedMain.class, "IS DEBUG CHECKING: ", e);
        }
        try {
            if (this.cryptoService == null) {
                this.setCryptoService(new CryptoService());
            }
            this.factoryAppBeans = new FactoryAppBeansEmbedded();
            String webAppPath = appDir + File.separator + "webapp";
            File webappdir = new File(webAppPath);
            if (!webappdir.exists() || !webappdir.isDirectory()) {
                throw new ExceptionStart("Web app directory not found: " + webAppPath);
            }
            File ksDir = new File(appDir + File.separator + "ks");
            if (!ksDir.exists() && !ksDir.mkdir()) {
                throw new ExceptionStart("Can't create ks directory: " + ksDir);
            }
            File[] lstFl = ksDir.listFiles();
            String nmpref = "ajettykeystore.";
            if (lstFl != null) {
                if (lstFl.length > 1 || lstFl.length == 1 && !lstFl[0].isFile()) {
                    throw new ExceptionStart("KS directory must contains only ks file!!!");
                }
                if (lstFl.length == 1 && lstFl[0].isFile() && lstFl[0].getName().startsWith(nmpref)) {
                    String ajettyInStr = lstFl[0].getName().replace(nmpref, "");
                    this.ajettyIn = Integer.parseInt(ajettyInStr);
                    this.isKeystoreCreated = true;
                }
            }
            this.bootStrapEmbeddedHttps = new BootStrapEmbeddedHttps();
            this.bootStrapEmbeddedHttps.setFactoryAppBeans(this.factoryAppBeans);
            this.bootStrapEmbeddedHttps.setWebAppPath(webAppPath);
            Security.addProvider(new BouncyCastleProvider());
        }
        catch (ExceptionStart e) {
            this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
            throw new ExceptionStart(e);
        }
    }

    public final void stopAjetty() throws ExceptionStart {
        try {
            StopThread stThread = new StopThread();
            stThread.start();
        }
        catch (Exception e) {
            this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
            throw new ExceptionStart(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startAjetty() throws Exception {
        File webappdir = new File(this.bootStrapEmbeddedHttps.getWebAppPath());
        String ksPath = webappdir.getParent() + File.separator + "ks";
        File pks12File = new File(ksPath + File.separator + "ajettykeystore." + this.ajettyIn);
        if (!pks12File.exists()) {
            boolean noMatch = false;
            if (this.ksPassword.length != this.ksPasswordConf.length) {
                noMatch = true;
            } else {
                for (int i = 0; i < this.ksPassword.length; ++i) {
                    if (this.ksPassword[i] == this.ksPasswordConf[i]) continue;
                    noMatch = true;
                    break;
                }
            }
            if (noMatch) {
                this.bootStrapIFace.showError(this.getMsg("PasswordRepeatNoMatch"));
                this.isActionPerforming = false;
                return;
            }
            String isPswStrRez = this.cryptoService.isPasswordStrong(this.ksPassword);
            if (isPswStrRez != null) {
                this.bootStrapIFace.showError(isPswStrRez);
                this.isActionPerforming = false;
                return;
            }
            this.cryptoService.createKeyStoreWithCredentials(pks12File.getParent(), this.ajettyIn, this.ksPassword);
            FileInputStream fis = null;
            Certificate certCa = null;
            PublicKey fileExchPub = null;
            try {
                this.keyStore = KeyStore.getInstance("PKCS12", "BC");
                fis = new FileInputStream(pks12File);
                this.keyStore.load(fis, this.ksPassword);
                this.isKeystoreCreated = true;
                certCa = this.keyStore.getCertificate("AJettyCa" + this.ajettyIn);
                fileExchPub = this.keyStore.getCertificate("AJettyFileExch" + this.ajettyIn).getPublicKey();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        this.logger.error(null, BootStrapEmbeddedMain.class, null, e2);
                    }
                }
            }
            if (certCa != null) {
                File pemFl = new File(pks12File.getParentFile().getParent() + File.separator + "ajetty-ca.pem");
                BufferedWriter pemWriter = null;
                try {
                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(pemFl), Charset.forName("ASCII").newEncoder());
                    pemWriter = new JcaPEMWriter(osw);
                    ((JcaPEMWriter)pemWriter).writeObject(certCa);
                    pemWriter.flush();
                }
                finally {
                    if (pemWriter != null) {
                        try {
                            pemWriter.close();
                        }
                        catch (Exception e2) {
                            this.logger.error(null, BootStrapEmbeddedMain.class, null, e2);
                        }
                    }
                }
            }
            if (fileExchPub != null) {
                File pubFl = new File(pks12File.getParentFile().getParent() + File.separator + "ajetty-file-exch" + this.ajettyIn + ".kpub");
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(pubFl);
                    fos.write(fileExchPub.getEncoded());
                    fos.flush();
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e2) {
                            this.logger.error(null, BootStrapEmbeddedMain.class, null, e2);
                        }
                    }
                }
            }
        } else {
            FileInputStream fis = null;
            try {
                this.keyStore = KeyStore.getInstance("PKCS12", "BC");
                fis = new FileInputStream(pks12File);
                this.keyStore.load(fis, this.ksPassword);
            }
            catch (Exception e) {
                this.keyStore = null;
                this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        this.logger.error(null, BootStrapEmbeddedMain.class, null, e2);
                    }
                }
            }
            if (this.keyStore == null) {
                this.bootStrapIFace.showError(this.getMsg("passwordDoNotMatch"));
                this.isActionPerforming = false;
                this.isLastStartFail = true;
                return;
            }
        }
        this.bootStrapEmbeddedHttps.setHttpsAlias("AJettyHttps" + this.ajettyIn);
        this.bootStrapEmbeddedHttps.setPkcs12File(pks12File);
        this.bootStrapEmbeddedHttps.setPassword(new String(this.ksPassword));
        this.bootStrapEmbeddedHttps.setKeyStore(this.keyStore);
        this.bootStrapEmbeddedHttps.setAjettyIn(this.ajettyIn);
        this.bootStrapEmbeddedHttps.setPort(this.port);
        this.lastActionStartDate = new Date().getTime();
        StartThread stThread = new StartThread();
        stThread.start();
        this.isLastStartFail = false;
    }

    public final void refreshUi() {
        this.bootStrapIFace.refreshUi();
    }

    public static final void main(String[] pArgs) {
        try {
            final BootStrapEmbeddedMain bsem = new BootStrapEmbeddedMain();
            if (pArgs != null && pArgs.length > 0 && "cli".equals(pArgs[0])) {
                BootStrapCli bsc = new BootStrapCli();
                bsc.setMainBootStrap(bsem);
                bsem.setBootStrapIFace(bsc);
                bsc.startInterface();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            BootStrapEmbeddedHttpsSwing bses = null;
                            try {
                                bses = new BootStrapEmbeddedHttpsSwing();
                                bses.setMainBootStrap(bsem);
                                bsem.setBootStrapIFace(bses);
                                bses.startInterface();
                            }
                            catch (Exception e) {
                                if (bses == null) break block2;
                                bses.dispose();
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public final String getMsg(String pKey) {
        try {
            return this.messages.getString(pKey);
        }
        catch (Exception e) {
            return "[" + pKey + "]";
        }
    }

    public final boolean getIsActionPerforming() {
        return this.isActionPerforming;
    }

    public final void setIsActionPerforming(boolean pIsActionPerforming) {
        this.isActionPerforming = pIsActionPerforming;
    }

    public final long getLastActionStartDate() {
        return this.lastActionStartDate;
    }

    public final void setLastActionStartDate(long pLastActionStartDate) {
        this.lastActionStartDate = pLastActionStartDate;
    }

    public final BootStrapEmbeddedHttps getBootStrapEmbeddedHttps() {
        return this.bootStrapEmbeddedHttps;
    }

    public final IFactoryAppBeans getFactoryAppBeans() {
        return this.factoryAppBeans;
    }

    public final ResourceBundle getMessages() {
        return this.messages;
    }

    public final Integer getAjettyIn() {
        return this.ajettyIn;
    }

    public final void setAjettyIn(Integer pAjettyIn) {
        this.ajettyIn = pAjettyIn;
    }

    public final CryptoService getCryptoService() {
        return this.cryptoService;
    }

    public final void setCryptoService(CryptoService pCryptoService) {
        this.cryptoService = pCryptoService;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final boolean getIsDebug() {
        return this.isDebug;
    }

    public final boolean getIsKeystoreCreated() {
        return this.isKeystoreCreated;
    }

    public final Integer getPort() {
        return this.port;
    }

    public final void setPort(Integer pPort) {
        this.port = pPort;
    }

    public final char[] getKsPassword() {
        return this.ksPassword;
    }

    public final void setKsPassword(char[] pKsPassword) {
        this.ksPassword = pKsPassword;
    }

    public final char[] getKsPasswordConf() {
        return this.ksPasswordConf;
    }

    public final void setKsPasswordConf(char[] pKsPasswordConf) {
        this.ksPasswordConf = pKsPasswordConf;
    }

    public final IBootStrapIFace getBootStrapIFace() {
        return this.bootStrapIFace;
    }

    public final void setBootStrapIFace(IBootStrapIFace pBootStrapIFace) {
        this.bootStrapIFace = pBootStrapIFace;
    }

    public final boolean getIsLastStartFail() {
        return this.isLastStartFail;
    }

    public final void setIsLastStartFail(boolean pIsLastStartFail) {
        this.isLastStartFail = pIsLastStartFail;
    }

    private class StopThread
    extends Thread {
        private StopThread() {
        }

        @Override
        public void run() {
            if (BootStrapEmbeddedMain.this.bootStrapEmbeddedHttps.getIsStarted()) {
                try {
                    BootStrapEmbeddedMain.this.bootStrapEmbeddedHttps.stopServer();
                }
                catch (Exception e) {
                    BootStrapEmbeddedMain.this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
                }
            }
            BootStrapEmbeddedMain.this.isActionPerforming = false;
            BootStrapEmbeddedMain.this.refreshUi();
        }
    }

    private class StartThread
    extends Thread {
        private StartThread() {
        }

        @Override
        public void run() {
            if (!BootStrapEmbeddedMain.this.bootStrapEmbeddedHttps.getIsStarted()) {
                try {
                    BootStrapEmbeddedMain.this.bootStrapEmbeddedHttps.startServer();
                }
                catch (Exception e) {
                    BootStrapEmbeddedMain.this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
                }
            }
            BootStrapEmbeddedMain.this.isActionPerforming = false;
            BootStrapEmbeddedMain.this.refreshUi();
        }
    }

    private class CliThread
    extends Thread {
        private CliThread() {
        }

        @Override
        public void run() {
            if (!BootStrapEmbeddedMain.this.bootStrapEmbeddedHttps.getIsStarted()) {
                try {
                    BootStrapEmbeddedMain.this.bootStrapEmbeddedHttps.startServer();
                }
                catch (Exception e) {
                    BootStrapEmbeddedMain.this.logger.error(null, BootStrapEmbeddedMain.class, null, e);
                }
            }
        }
    }
}

