/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.doc.service;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import org.beigesoft.doc.exception.ExceptionBdw;
import org.beigesoft.doc.model.DocImage;
import org.beigesoft.doc.model.DocPage;
import org.beigesoft.doc.model.DocString;
import org.beigesoft.doc.model.DocTable;
import org.beigesoft.doc.model.Document;
import org.beigesoft.doc.model.EAlignHorizontal;
import org.beigesoft.doc.model.EPageOrientation;
import org.beigesoft.doc.model.EPageSize;
import org.beigesoft.doc.model.EWraping;
import org.beigesoft.doc.model.IDerivingElements;
import org.beigesoft.doc.model.IElement;
import org.beigesoft.doc.model.Pagination;
import org.beigesoft.doc.model.TableCell;
import org.beigesoft.doc.model.TableColumn;
import org.beigesoft.doc.model.TableRow;
import org.beigesoft.doc.service.IDeriverElements;
import org.beigesoft.doc.service.IDocumentMaker;
import org.beigesoft.doc.service.IFctDocTable;
import org.beigesoft.doc.service.IFctElement;

public class DocumentMaker<WI>
implements IDocumentMaker<WI> {
    private IFctElement<WI> elementFactory;
    private IFctDocTable<WI> docTableFactory;
    private final CharsetEncoder charsetEncoder = Charset.forName("ISO-8859-1").newEncoder();
    private IDeriverElements<WI, Pagination<WI>> deriverElPagination;

    @Override
    public final void addPage(Document<WI> pDoc) throws Exception {
        DocPage<WI> lpg = pDoc.getPages().get(pDoc.getPages().size() - 1);
        DocPage pg = new DocPage();
        pg.setElements(new ArrayList());
        pg.setWidth(lpg.getWidth());
        pg.setHeight(lpg.getHeight());
        pg.setMarginBottom(lpg.getMarginBottom());
        pg.setMarginTop(lpg.getMarginTop());
        pg.setMarginLeft(lpg.getMarginLeft());
        pg.setMarginRight(lpg.getMarginRight());
        pDoc.getPages().add(pg);
        pDoc.setPageNumber(pDoc.getPages().size());
    }

    @Override
    public final void addPage(Document<WI> pDoc, EPageSize pPageSize, EPageOrientation pPageOrientation) throws Exception {
        if (pPageSize.equals((Object)EPageSize.LETTER)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                this.addPage(pDoc, 8.5, 11.0);
            } else {
                this.addPage(pDoc, 11.0, 8.5);
            }
        } else if (pPageSize.equals((Object)EPageSize.A5)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                this.addPage(pDoc, 148.0, 210.0);
            } else {
                this.addPage(pDoc, 210.0, 148.0);
            }
        } else if (pPageSize.equals((Object)EPageSize.A4)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                this.addPage(pDoc, 210.0, 297.0);
            } else {
                this.addPage(pDoc, 297.0, 210.0);
            }
        } else if (pPageSize.equals((Object)EPageSize.A3)) {
            if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
                this.addPage(pDoc, 297.0, 420.0);
            } else {
                this.addPage(pDoc, 420.0, 297.0);
            }
        } else if (pPageOrientation.equals((Object)EPageOrientation.PORTRAIT)) {
            this.addPage(pDoc, 420.0, 594.0);
        } else {
            this.addPage(pDoc, 594.0, 420.0);
        }
    }

    @Override
    public final void addPage(Document<WI> pDoc, double pWidth, double pHeight) throws Exception {
        DocPage pg = new DocPage();
        pg.setElements(new ArrayList());
        pg.setWidth(pWidth);
        pg.setHeight(pHeight);
        pDoc.getPages().add(pg);
        pDoc.setPageNumber(pDoc.getPages().size());
    }

    @Override
    public final void setPage(Document<WI> pDoc, int pPageNum) throws Exception {
        if (pDoc.getPages().size() < pPageNum) {
            throw new ExceptionBdw("Add page first!");
        }
        pDoc.setPageNumber(pPageNum);
    }

    @Override
    public final void setFont(Document<WI> pDoc, int pFontNum, double pFontSize) throws Exception {
        if (pDoc.getFonts().size() < pFontNum) {
            throw new ExceptionBdw("Add font first!");
        }
        pDoc.setFontNumber(pFontNum);
        pDoc.setFontSize(pFontSize);
    }

    @Override
    public final void setFontSize(Document<WI> pDoc, double pFontSize) throws Exception {
        if (pFontSize <= 0.0 || pFontSize > pDoc.getPages().get(pDoc.getPageNumber() - 1).getWidth() * 0.8) {
            throw new ExceptionBdw("Wrong font size!");
        }
        pDoc.setFontSize(pFontSize);
    }

    @Override
    public final void addString(Document<WI> pDoc, String pString, double pX, double pY) throws Exception {
        if (pDoc.getFonts().size() == 0) {
            throw new ExceptionBdw("Add font first!");
        }
        if (!pDoc.getFonts().get(pDoc.getFontNumber() - 1).getIsUnicoded() && !this.charsetEncoder.canEncode(pString)) {
            throw new ExceptionBdw("This string required unicode font!");
        }
        DocString<WI> dstr = this.elementFactory.createDocString(null);
        dstr.setValue(pString);
        dstr.setFontSize(pDoc.getFontSize());
        dstr.setX1(pX);
        dstr.setY1(pY - dstr.getFontSize());
        dstr.setY2(pY);
        dstr.setFontNumber(pDoc.getFontNumber());
        pDoc.getPages().get(pDoc.getPageNumber() - 1).getElements().add(dstr);
    }

    @Override
    public final DocTable<WI> addDocTable(Document<WI> pDoc, int pColumns, int pRows) throws Exception {
        if (pDoc.getFonts().size() == 0) {
            throw new ExceptionBdw("Add font first!");
        }
        return this.docTableFactory.createDocTable(pDoc, pColumns, pRows);
    }

    @Override
    public final DocTable<WI> addDocTableCustomBorder(Document<WI> pDoc, int pColumns, int pRows) throws Exception {
        if (pDoc.getFonts().size() == 0) {
            throw new ExceptionBdw("Add font first!");
        }
        DocTable<WI> res = this.docTableFactory.createDocTable(pDoc, pColumns, pRows);
        res.setIsThereCellWithCustomBorder(true);
        return res;
    }

    @Override
    public final Pagination<WI> addPagination(Document<WI> pDoc) throws Exception {
        Pagination<WI> paging = new Pagination<WI>();
        paging.setDocument(pDoc);
        paging.setStartPage(pDoc.getPages().get(pDoc.getPageNumber() - 1));
        paging.setDeriverElements(this.deriverElPagination);
        paging.setAlignHorizontal(EAlignHorizontal.RIGHT);
        paging.setFontNumber(pDoc.getFontNumber());
        paging.setFontSize(pDoc.getFontSize());
        pDoc.getDerivingElementsList().add(paging);
        return paging;
    }

    @Override
    public final DocTable<WI> addDocTableNoBorder(Document<WI> pDoc, int pColumns, int pRows) throws Exception {
        if (pDoc.getFonts().size() == 0) {
            throw new ExceptionBdw("Add font first!");
        }
        double bordWas = pDoc.getBorder();
        pDoc.setBorder(0.0);
        DocTable<WI> rez = this.docTableFactory.createDocTable(pDoc, pColumns, pRows);
        pDoc.setBorder(bordWas);
        return rez;
    }

    @Override
    public final void makeDocTableWrapping(DocTable<WI> pTbl) throws Exception {
        pTbl.setWraping(EWraping.WRAP_CONTENT);
        for (TableColumn col : pTbl.getItsColumns()) {
            col.setWraping(EWraping.WRAP_CONTENT);
        }
    }

    @Override
    public final void addRowToDocTable(DocTable<WI> pTbl) throws Exception {
        TableRow rowEnd = pTbl.getItsRows().get(pTbl.getItsRows().size() - 1);
        pTbl.getItsRows().add(new TableRow(rowEnd));
        for (int i = 0; i < pTbl.getItsColumns().size(); ++i) {
            TableCell tcel = new TableCell();
            tcel.setFontNumber(pTbl.getDocument().getFontNumber());
            tcel.setFontSize(pTbl.getDocument().getFontSize());
            tcel.setAlignHorizontal(pTbl.getDocument().getAlignHoriCont());
            tcel.setAlignVertical(pTbl.getDocument().getAlignVertCont());
            pTbl.getItsCells().add(tcel);
        }
    }

    @Override
    public final void deriveElements(Document<WI> pDoc) throws Exception {
        for (DocPage<WI> pg : pDoc.getPages()) {
            HashSet<IElement<WI>> dsToDelSet = new HashSet<IElement<WI>>();
            for (IElement<Object> el : pg.getElements()) {
                if (el.getParent() == null) continue;
                dsToDelSet.add(el);
            }
            for (IElement<Object> el : dsToDelSet) {
                pg.getElements().remove(el);
            }
        }
        for (IDerivingElements de : pDoc.getDerivingElementsList()) {
            de.derive();
        }
    }

    @Override
    public final DocImage<WI> addImage(Document<WI> pDoc, String pPath, double pX, double pY) throws Exception {
        DocImage<WI> dimg = this.elementFactory.createDocImage(null, pPath);
        dimg.setX1(pX);
        dimg.setY1(pY);
        pDoc.getPages().get(pDoc.getPageNumber() - 1).getElements().add(dimg);
        return dimg;
    }

    public final IFctElement<WI> getElementFactory() {
        return this.elementFactory;
    }

    public final void setElementFactory(IFctElement<WI> pElementFactory) {
        this.elementFactory = pElementFactory;
    }

    public final IFctDocTable<WI> getDocTableFactory() {
        return this.docTableFactory;
    }

    public final void setDocTableFactory(IFctDocTable<WI> pDocTableFactory) {
        this.docTableFactory = pDocTableFactory;
    }

    public final CharsetEncoder getCharsetEncoder() {
        return this.charsetEncoder;
    }

    public final IDeriverElements<WI, Pagination<WI>> getDeriverElPagination() {
        return this.deriverElPagination;
    }

    public final void setDeriverElPagination(IDeriverElements<WI, Pagination<WI>> pDeriverElPagination) {
        this.deriverElPagination = pDeriverElPagination;
    }
}

