/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.doc.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.beigesoft.doc.model.EUnitOfMeasure;

public class UomHelper {
    public final double toPoints(double pValue, double pDocDpi, EUnitOfMeasure pUom) {
        double result;
        switch (pUom) {
            case POINT: {
                result = pValue;
                break;
            }
            case INCH: {
                result = pValue * pDocDpi;
                break;
            }
            case CENTIMETRE: {
                result = pValue / 2.54 * pDocDpi;
                break;
            }
            default: {
                result = pValue / 25.4 * pDocDpi;
            }
        }
        return BigDecimal.valueOf(result).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public final double fromPoints(double pValue, double pDocDpi, EUnitOfMeasure pUom) {
        double result;
        switch (pUom) {
            case POINT: {
                result = pValue;
                break;
            }
            case INCH: {
                result = pValue / pDocDpi;
                break;
            }
            case CENTIMETRE: {
                result = pValue * 2.54 / pDocDpi;
                break;
            }
            default: {
                result = pValue * 25.4 / pDocDpi;
            }
        }
        return result;
    }
}

