/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IHasId;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.IFillerObjectsFrom;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;

public class HandlerEntityRequest<RS>
implements IHandlerRequest {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private IFillerObjectsFrom<IRequestData> fillEntityFromReq;
    private IFactoryAppBeansByClass<IFactorySimple<?>> entitiesFactoriesFatory;
    private IFactoryAppBeansByName<IEntityProcessor> entitiesProcessorsFactory;
    private IHolderForClassByName<String> entitiesProcessorsNamesHolder;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;
    private IHolderForClassByName<String> processorsNamesHolder;
    private Map<String, Class<?>> entitiesMap;
    private Integer changingTranIsol = ISrvDatabase.TRANSACTION_READ_COMMITTED;

    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        IFactorySimple<?> entFac;
        String[] actionsArr;
        int detLev = this.logger.getDetailLevel();
        boolean isShowDebMsg = this.logger.getIsShowDebugMessages() && this.logger.getIsShowDebugMessagesFor(this.getClass());
        for (String actionNm : actionsArr = pRequestData.getParameter("nmsAct").split(",")) {
            if (!isShowDebMsg || detLev <= 100) continue;
            this.logger.debug(pReqVars, HandlerEntityRequest.class, "Action: " + actionNm);
        }
        String nmEnt = pRequestData.getParameter("nmEnt");
        Class<?> entityClass = this.entitiesMap.get(nmEnt);
        if (!ISrvDatabase.TRANSACTION_READ_UNCOMMITTED.equals(this.changingTranIsol) && ("entityFolSave".equals(actionsArr[0]) || "entitySave".equals(actionsArr[0]) || "entityDelete".equals(actionsArr[0]) || "entityFolDelete".equals(actionsArr[0]))) {
            IHasId entity = null;
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(this.changingTranIsol);
                this.srvDatabase.beginTransaction();
                entFac = this.entitiesFactoriesFatory.lazyGet(pReqVars, entityClass);
                entity = (IHasId)entFac.create(pReqVars);
                this.fillEntityFromReq.fill(pReqVars, entity, pRequestData);
                String entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionsArr[0]);
                IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pReqVars, entProcNm);
                if (isShowDebMsg && detLev > 100) {
                    this.logger.debug(pReqVars, HandlerEntityRequest.class, "CHANGING transaction use entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                }
                entity = ep.process(pReqVars, entity, pRequestData);
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                this.srvDatabase.rollBackTransaction();
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
            if (actionsArr.length > 1) {
                try {
                    this.srvDatabase.setIsAutocommit(false);
                    this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                    this.srvDatabase.beginTransaction();
                    for (int i = 1; i < actionsArr.length; ++i) {
                        String actionNm = actionsArr[i];
                        if (actionNm.startsWith("entity")) {
                            if (entity == null) {
                                entity = (IHasId)pReqVars.get("nextEntity");
                                if (entity == null) {
                                    throw new ExceptionWithCode(1003, "wrong_request_entity_not_filled");
                                }
                                entityClass = entity.getClass();
                            }
                            String entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionNm);
                            IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pReqVars, entProcNm);
                            if (isShowDebMsg && detLev > 100) {
                                this.logger.debug(pReqVars, HandlerEntityRequest.class, "It's used entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                            }
                            entity = ep.process(pReqVars, entity, pRequestData);
                            continue;
                        }
                        String procNm = this.processorsNamesHolder.getFor(entityClass, actionNm);
                        IProcessor proc = this.processorsFactory.lazyGet(pReqVars, procNm);
                        if (isShowDebMsg && detLev > 100) {
                            this.logger.debug(pReqVars, HandlerEntityRequest.class, "It's used procNm/IProcessor: " + procNm + "/" + proc.getClass());
                        }
                        proc.process(pReqVars, pRequestData);
                    }
                    this.srvDatabase.commitTransaction();
                }
                catch (Exception ex) {
                    this.srvDatabase.rollBackTransaction();
                    throw ex;
                }
                finally {
                    this.srvDatabase.releaseResources();
                }
            }
        } else {
            try {
                this.srvDatabase.setIsAutocommit(false);
                this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                this.srvDatabase.beginTransaction();
                IHasId entity = null;
                if (actionsArr[0].startsWith("entity")) {
                    entFac = this.entitiesFactoriesFatory.lazyGet(pReqVars, entityClass);
                    entity = (IHasId)entFac.create(pReqVars);
                    this.fillEntityFromReq.fill(pReqVars, entity, pRequestData);
                }
                for (String actionNm : actionsArr) {
                    if (actionNm.startsWith("entity")) {
                        if (entity == null) {
                            entity = (IHasId)pReqVars.get("nextEntity");
                            if (entity == null) {
                                throw new ExceptionWithCode(1003, "wrong_request_entity_not_filled");
                            }
                            entityClass = entity.getClass();
                        }
                        String entProcNm = this.entitiesProcessorsNamesHolder.getFor(entityClass, actionNm);
                        IEntityProcessor ep = this.entitiesProcessorsFactory.lazyGet(pReqVars, entProcNm);
                        if (isShowDebMsg && detLev > 100) {
                            this.logger.debug(pReqVars, HandlerEntityRequest.class, "It's used entProcNm/IEntityProcessor: " + entProcNm + "/" + ep.getClass());
                        }
                        entity = ep.process(pReqVars, entity, pRequestData);
                        continue;
                    }
                    String procNm = this.processorsNamesHolder.getFor(entityClass, actionNm);
                    IProcessor proc = this.processorsFactory.lazyGet(pReqVars, procNm);
                    if (isShowDebMsg && detLev > 100) {
                        this.logger.debug(pReqVars, HandlerEntityRequest.class, "It's used procNm/IProcessor: " + procNm + "/" + proc.getClass());
                    }
                    proc.process(pReqVars, pRequestData);
                }
                this.srvDatabase.commitTransaction();
            }
            catch (Exception ex) {
                this.srvDatabase.rollBackTransaction();
                throw ex;
            }
            finally {
                this.srvDatabase.releaseResources();
            }
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IFillerObjectsFrom<IRequestData> getFillEntityFromReq() {
        return this.fillEntityFromReq;
    }

    public final void setFillEntityFromReq(IFillerObjectsFrom<IRequestData> pFillEntityFromReq) {
        this.fillEntityFromReq = pFillEntityFromReq;
    }

    public final IFactoryAppBeansByClass<IFactorySimple<?>> getEntitiesFactoriesFatory() {
        return this.entitiesFactoriesFatory;
    }

    public final void setEntitiesFactoriesFatory(IFactoryAppBeansByClass<IFactorySimple<?>> pEntitiesFactoriesFatory) {
        this.entitiesFactoriesFatory = pEntitiesFactoriesFatory;
    }

    public final IFactoryAppBeansByName<IEntityProcessor> getEntitiesProcessorsFactory() {
        return this.entitiesProcessorsFactory;
    }

    public final void setEntitiesProcessorsFactory(IFactoryAppBeansByName<IEntityProcessor> pEntitiesProcessorsFactory) {
        this.entitiesProcessorsFactory = pEntitiesProcessorsFactory;
    }

    public final IHolderForClassByName<String> getEntitiesProcessorsNamesHolder() {
        return this.entitiesProcessorsNamesHolder;
    }

    public final void setEntitiesProcessorsNamesHolder(IHolderForClassByName<String> pEntitiesProcessorsNamesHolder) {
        this.entitiesProcessorsNamesHolder = pEntitiesProcessorsNamesHolder;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }

    public final IHolderForClassByName<String> getProcessorsNamesHolder() {
        return this.processorsNamesHolder;
    }

    public final void setProcessorsNamesHolder(IHolderForClassByName<String> pProcessorsNamesHolder) {
        this.processorsNamesHolder = pProcessorsNamesHolder;
    }

    public final Map<String, Class<?>> getEntitiesMap() {
        return this.entitiesMap;
    }

    public final void setEntitiesMap(Map<String, Class<?>> pEntitiesMap) {
        this.entitiesMap = pEntitiesMap;
    }

    public final Integer getChangingTranIsol() {
        return this.changingTranIsol;
    }

    public final void setChangingTranIsol(Integer pChangingTranIsol) {
        this.changingTranIsol = pChangingTranIsol;
    }
}

