/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.handler.IHndlFileReportReq;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.CsvColumn;
import org.beigesoft.persistable.CsvMethod;
import org.beigesoft.service.ICsvDataRetriever;
import org.beigesoft.service.ICsvWriter;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class HndlCsvWriter<RS>
implements IHndlFileReportReq {
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private ICsvWriter csvWriter;
    private Map<String, ICsvDataRetriever> retrievers;

    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData, OutputStream pSous) throws Exception {
        String optimisticQuantityStr;
        String csvMethodIdStr = pRequestData.getParameter("csvMethod");
        Long csvMethodId = Long.parseLong(csvMethodIdStr);
        String priceCategoryIdStr = pRequestData.getParameter("priceCategory");
        Long priceCategoryId = Long.parseLong(priceCategoryIdStr);
        pReqVars.put("priceCategoryId", priceCategoryId);
        String unavailablePriceStr = pRequestData.getParameter("unavailablePrice");
        if (unavailablePriceStr != null && !"".equals(unavailablePriceStr)) {
            BigDecimal unavailablePrice = new BigDecimal(unavailablePriceStr);
            pReqVars.put("unavailablePrice", unavailablePrice);
        }
        if ((optimisticQuantityStr = pRequestData.getParameter("optimisticQuantity")) != null && !"".equals(optimisticQuantityStr)) {
            BigDecimal optimisticQuantity = new BigDecimal(optimisticQuantityStr);
            pReqVars.put("optimisticQuantity", optimisticQuantity);
        }
        CsvMethod csvMethod = null;
        List<List<Object>> data = null;
        ICsvDataRetriever ret = null;
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            csvMethod = this.getSrvOrm().retrieveEntityById(pReqVars, CsvMethod.class, csvMethodId);
            List<CsvColumn> cols = this.getSrvOrm().retrieveListWithConditions(pReqVars, CsvColumn.class, "where ITSOWNER=" + csvMethod.getItsId());
            csvMethod.setColumns(cols);
            ret = this.retrievers.get(csvMethod.getRetrieverName());
            if (ret == null) {
                throw new ExceptionWithCode(1003, "Can't find retriever " + csvMethod.getRetrieverName());
            }
            data = ret.retrieveData(pReqVars);
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
        if (data != null) {
            this.csvWriter.write(pReqVars, data, csvMethod, pSous);
        }
    }

    public final Map<String, ICsvDataRetriever> getRetrievers() {
        return this.retrievers;
    }

    public final void setRetrievers(Map<String, ICsvDataRetriever> pRetrievers) {
        this.retrievers = pRetrievers;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final ICsvWriter getCsvWriter() {
        return this.csvWriter;
    }

    public final void setCsvWriter(ICsvWriter pCsvWriter) {
        this.csvWriter = pCsvWriter;
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }
}

