/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.beigesoft.handler.IHandlerRequestDch;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.DecimalGroupSeparator;
import org.beigesoft.persistable.DecimalSeparator;
import org.beigesoft.persistable.LangPreferences;
import org.beigesoft.persistable.Languages;
import org.beigesoft.service.ISrvDatabase;
import org.beigesoft.service.ISrvOrm;

public class HndlI18nRequest<RS>
implements IHandlerRequestDch {
    private ILogger logger;
    private ISrvDatabase<RS> srvDatabase;
    private ISrvOrm<RS> srvOrm;
    private List<LangPreferences> langPreferences;
    private List<Languages> languages;
    private List<DecimalSeparator> decimalSeparators;
    private List<DecimalGroupSeparator> decimalGroupSeparators;
    private IHandlerRequestDch additionalI18nReqHndl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        List<DecimalGroupSeparator> dgssTmp;
        List<DecimalSeparator> dssTmp;
        List<Languages> lgsTmp;
        List<LangPreferences> lpfsTmp;
        boolean isFirstReq = false;
        HndlI18nRequest hndlI18nRequest = this;
        synchronized (hndlI18nRequest) {
            if (this.langPreferences == null) {
                try {
                    isFirstReq = true;
                    this.logger.info(null, HndlI18nRequest.class, "Refreshing I18N data...");
                    this.srvDatabase.setIsAutocommit(false);
                    this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
                    this.srvDatabase.beginTransaction();
                    List<LangPreferences> lpfs = this.srvOrm.retrieveList(pReqVars, LangPreferences.class);
                    List<Languages> lgs = this.srvOrm.retrieveList(pReqVars, Languages.class);
                    List<DecimalSeparator> dss = this.srvOrm.retrieveList(pReqVars, DecimalSeparator.class);
                    List<DecimalGroupSeparator> dgss = this.srvOrm.retrieveList(pReqVars, DecimalGroupSeparator.class);
                    this.srvDatabase.commitTransaction();
                    this.decimalGroupSeparators = dgss;
                    this.decimalSeparators = dss;
                    this.languages = lgs;
                    this.langPreferences = lpfs;
                }
                catch (Exception ex) {
                    if (!this.srvDatabase.getIsAutocommit()) {
                        this.srvDatabase.rollBackTransaction();
                    }
                    throw ex;
                }
                finally {
                    this.srvDatabase.releaseResources();
                }
            }
            lpfsTmp = this.langPreferences;
            lgsTmp = this.languages;
            dssTmp = this.decimalSeparators;
            dgssTmp = this.decimalGroupSeparators;
        }
        LangPreferences lpf = this.revealLangPreferences(pRequestData, lgsTmp, dssTmp, dgssTmp, lpfsTmp, isFirstReq);
        String langDef = null;
        for (LangPreferences lpft : lpfsTmp) {
            if (!lpft.getIsDefault().booleanValue()) continue;
            langDef = lpft.getLang().getItsId();
            break;
        }
        if (lpfsTmp.size() == 0 || langDef == null) {
            this.logger.error(null, HndlI18nRequest.class, "There is no default languages preferences!");
            pReqVars.put("lang", "en");
            pReqVars.put("langDef", "en");
            pReqVars.put("localeCurrent", new Locale("en", "US"));
            pReqVars.put("dseparator", ".");
            pReqVars.put("dgseparator", ",");
            pReqVars.put("digitsInGroup", 3);
            return;
        }
        pReqVars.put("lang", lpf.getLang().getItsId());
        pReqVars.put("langDef", langDef);
        Locale locCurr = pRequestData.getLocale().getLanguage().equals(lpf.getLang().getItsId()) ? pRequestData.getLocale() : new Locale(lpf.getLang().getItsId());
        pReqVars.put("localeCurrent", locCurr);
        pReqVars.put("dseparator", lpf.getDecimalSep().getItsId());
        pReqVars.put("digitsInGroup", lpf.getDigitsInGroup());
        String dseparatorv = lpf.getDecimalSep().getItsId();
        if ("space".equals(dseparatorv)) {
            dseparatorv = " ";
        }
        pReqVars.put("dseparatorv", dseparatorv);
        pReqVars.put("dgseparator", lpf.getDecimalGroupSep().getItsId());
        String dgseparatorv = lpf.getDecimalGroupSep().getItsId();
        if ("space".equals(dgseparatorv)) {
            dgseparatorv = " ";
        }
        pReqVars.put("dgseparatorv", dgseparatorv);
        pReqVars.put("languages", lgsTmp);
        pReqVars.put("decimalSeparators", dssTmp);
        pReqVars.put("decimalGroupSeparators", dgssTmp);
        if (this.additionalI18nReqHndl != null) {
            this.additionalI18nReqHndl.handle(pReqVars, pRequestData);
        } else {
            pReqVars.put("quantityPrecision", 2);
            pReqVars.put("pricePrecision", 2);
            pReqVars.put("costPrecision", 2);
            pReqVars.put("RSmRound", "S");
            pReqVars.put("RSisUsePrecision0", Boolean.TRUE);
            pReqVars.put("RSisUsePrecision1", Boolean.TRUE);
            pReqVars.put("RSisUsePrecision2", Boolean.TRUE);
            pReqVars.put("RSisUsePrecision3", Boolean.TRUE);
            pReqVars.put("RSisUsePrecision4", Boolean.TRUE);
        }
    }

    public final LangPreferences revealLangPreferences(IRequestData pRequestData, List<Languages> pLangs, List<DecimalSeparator> pDecSeps, List<DecimalGroupSeparator> pDecGrSeps, List<LangPreferences> pLangPrefs, boolean pIsFirstReq) throws Exception {
        int detLev = this.logger.getDetailLevel();
        boolean isShowDebMsg = this.logger.getIsShowDebugMessages() && this.logger.getIsShowDebugMessagesFor(this.getClass());
        LangPreferences lpf = null;
        boolean needSetCookie = false;
        String lang = pRequestData.getParameter("lang");
        String dseparator = pRequestData.getParameter("dseparator");
        String dgseparator = pRequestData.getParameter("dgseparator");
        String digitsInGroup = pRequestData.getParameter("digitsInGroup");
        if (pIsFirstReq || isShowDebMsg && detLev > 60000) {
            this.logger.debug(null, HndlI18nRequest.class, "Request's lang/dseparator/dgseparator/digitsInGroup: " + lang + "/" + dseparator + "/" + dgseparator + "/" + digitsInGroup);
        }
        if (lang == null || lang.length() == 0 || dseparator == null || dseparator.length() == 0 || dgseparator == null || dgseparator.length() == 0 || digitsInGroup == null || digitsInGroup.length() == 0) {
            lang = null;
            dseparator = null;
            dgseparator = null;
            digitsInGroup = null;
        } else {
            needSetCookie = true;
        }
        if (dgseparator == null && dseparator == null && lang == null) {
            lang = pRequestData.getCookieValue("lang");
            dseparator = pRequestData.getCookieValue("dseparator");
            dgseparator = pRequestData.getCookieValue("dgseparator");
            digitsInGroup = pRequestData.getCookieValue("digitsInGroup");
            if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                this.logger.debug(null, HndlI18nRequest.class, "Client's cookie lang/dseparator/dgseparator/digitsInGroup: " + lang + "/" + dseparator + "/" + dgseparator + "/" + digitsInGroup);
            }
        }
        if (dgseparator != null && dseparator != null && lang != null && digitsInGroup != null) {
            if (dgseparator.equals(dseparator)) {
                if (pIsFirstReq || isShowDebMsg) {
                    this.logger.debug(null, HndlI18nRequest.class, "Separators are same!! dseparator/dgseparator: " + dseparator);
                }
            } else {
                lpf = new LangPreferences();
                lpf.setDigitsInGroup(Integer.parseInt(digitsInGroup));
                for (Languages ln : pLangs) {
                    if (!ln.getItsId().equals(lang)) continue;
                    lpf.setLang(ln);
                    break;
                }
                if (lpf.getLang() == null) {
                    lpf = null;
                } else {
                    for (DecimalSeparator ds : pDecSeps) {
                        if (!ds.getItsId().equals(dseparator)) continue;
                        lpf.setDecimalSep(ds);
                        break;
                    }
                    if (lpf.getDecimalSep() == null) {
                        lpf = null;
                    } else {
                        for (DecimalGroupSeparator dgs : pDecGrSeps) {
                            if (!dgs.getItsId().equals(dgseparator)) continue;
                            lpf.setDecimalGroupSep(dgs);
                            break;
                        }
                        if (lpf.getDecimalGroupSep() == null) {
                            lpf = null;
                        }
                    }
                }
            }
        }
        if (lpf == null) {
            String ccountry = null;
            String clang = null;
            if (pRequestData.getLocale() != null) {
                ccountry = pRequestData.getLocale().getCountry();
                clang = pRequestData.getLocale().getLanguage();
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "Client prefers lang/country: " + clang + "/" + ccountry);
                }
            }
            LangPreferences lpfMf = null;
            LangPreferences lpfMl = null;
            LangPreferences lpfDef = null;
            for (LangPreferences lpft : pLangPrefs) {
                if (lpft.getCountry().getItsId().equals(ccountry) && lpft.getLang().getItsId().equals(clang)) {
                    lpfMf = lpft;
                    break;
                }
                if (lpft.getLang().getItsId().equals(clang)) {
                    lpfMl = lpft;
                }
                if (lpft.getIsDefault().booleanValue()) {
                    lpfDef = lpft;
                    continue;
                }
                if (lpfDef != null) continue;
                lpfDef = lpft;
            }
            if (lpfMf != null) {
                lpf = lpfMf;
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "Full match lang/dseparator/dgseparator/digitsInGroup: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId() + "/" + lpf.getDigitsInGroup());
                }
            } else if (lpfMl != null) {
                lpf = lpfMl;
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "Lang match lang/dseparator/dgseparator/digitsInGroup: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId() + "/" + lpf.getDigitsInGroup());
                }
            } else {
                lpf = lpfDef;
                if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                    this.logger.debug(null, HndlI18nRequest.class, "No match, default lang/dseparator/dgseparator/digitsInGroup: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId() + "/" + lpf.getDigitsInGroup());
                }
            }
            needSetCookie = true;
        }
        if (needSetCookie) {
            pRequestData.setCookieValue("digitsInGroup", lpf.getDigitsInGroup().toString());
            pRequestData.setCookieValue("lang", lpf.getLang().getItsId());
            pRequestData.setCookieValue("dseparator", lpf.getDecimalSep().getItsId());
            pRequestData.setCookieValue("dgseparator", lpf.getDecimalGroupSep().getItsId());
            if (pIsFirstReq || isShowDebMsg && detLev > 10000) {
                this.logger.debug(null, HndlI18nRequest.class, "Cookie is set lang/dseparator/dgseparator: " + lpf.getLang().getItsId() + "/" + lpf.getDecimalSep().getItsId() + "/" + lpf.getDecimalGroupSep().getItsId());
            }
        }
        return lpf;
    }

    @Override
    public final synchronized void handleDataChanged() throws Exception {
        this.langPreferences = null;
        this.languages = null;
        this.decimalSeparators = null;
        this.decimalGroupSeparators = null;
        this.logger.info(null, HndlI18nRequest.class, "I18N changes are handled.");
        if (this.additionalI18nReqHndl != null) {
            this.additionalI18nReqHndl.handleDataChanged();
        }
    }

    public final synchronized ILogger getLogger() {
        return this.logger;
    }

    public final synchronized void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final synchronized ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final synchronized void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final synchronized ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final synchronized void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IHandlerRequestDch getAdditionalI18nReqHndl() {
        return this.additionalI18nReqHndl;
    }

    public final void setAdditionalI18nReqHndl(IHandlerRequestDch pAdditionalI18nReqHndl) {
        this.additionalI18nReqHndl = pAdditionalI18nReqHndl;
    }
}

