/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.handler;

import java.util.Map;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IProcessor;
import org.beigesoft.service.ISrvDatabase;

public class TransactionalRequestHandler<RS>
implements IHandlerRequest {
    private ISrvDatabase<RS> srvDatabase;
    private IFactoryAppBeansByName<IProcessor> processorsFactory;

    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        try {
            String processorName = pRequestData.getParameter("nmPrc");
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            IProcessor proc = this.processorsFactory.lazyGet(pReqVars, processorName);
            proc.process(pReqVars, pRequestData);
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            if (!this.srvDatabase.getIsAutocommit()) {
                this.srvDatabase.rollBackTransaction();
            }
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final IFactoryAppBeansByName<IProcessor> getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final void setProcessorsFactory(IFactoryAppBeansByName<IProcessor> pProcessorsFactory) {
        this.processorsFactory = pProcessorsFactory;
    }
}

