/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import org.beigesoft.log.ALogger;

public abstract class ALoggerFile
extends ALogger {
    private String filePath;
    private File currentFile;
    private Integer fileMaxSize = 0x100000;
    private OutputStreamWriter writer;
    private long lastWriteTime;
    private long maxIdleTime = 3000L;
    private int logsCount;
    private int maxLogsCountToClose = 300;
    private Boolean isCloseFileAfterRecord = false;
    private CloserFile closerFile;

    @Override
    public final synchronized void info(Map<String, Object> pAddParam, Class<?> pClazz, String pMsg) {
        this.makeRecord(this.getDateFormat().format(new Date()) + " INFO " + pClazz.getSimpleName() + " - " + pMsg + this.getLineSeparator());
    }

    @Override
    public final synchronized void error(Map<String, Object> pAddParam, Class<?> pClazz, String pMsg) {
        this.makeRecord(this.getDateFormat().format(new Date()) + " ERROR " + pClazz.getSimpleName() + " - " + pMsg + this.getLineSeparator());
    }

    @Override
    public final synchronized void error(Map<String, Object> pAddParam, Class<?> pClazz, String pMsg, Throwable pThrown) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDateFormat().format(new Date()) + " ERROR " + pClazz.getSimpleName() + " - " + pMsg);
        this.exceptionToString(sb, pThrown);
        this.makeRecord(sb.toString());
    }

    @Override
    public final synchronized void warn(Map<String, Object> pAddParam, Class<?> pClazz, String pMsg) {
        this.makeRecord(this.getDateFormat().format(new Date()) + " WARN " + pClazz.getSimpleName() + " - " + pMsg + this.getLineSeparator());
    }

    @Override
    public final synchronized void warn(Map<String, Object> pAddParam, Class<?> pClazz, String pMsg, Throwable pThrown) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDateFormat().format(new Date()) + " WARN " + pClazz.getSimpleName() + " - " + pMsg);
        this.exceptionToString(sb, pThrown);
        this.makeRecord(sb.toString());
    }

    protected final synchronized void finalize() throws Throwable {
        if (this.closerFile != null) {
            this.closerFile.setIsNeedToRun(false);
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final synchronized void makeRecord(String pMsg) {
        if (this.isCloseFileAfterRecord.booleanValue()) {
            try {
                this.lazyGetWriter().write(pMsg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        this.writer = null;
                    }
                }
            }
        } else {
            if (this.writer != null && this.logsCount > this.maxLogsCountToClose) {
                this.logsCount = 0;
                try {
                    this.writer.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.writer = null;
                }
            }
            try {
                this.lazyGetWriter().write(pMsg);
                ++this.logsCount;
                this.writer.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.lastWriteTime = new Date().getTime();
    }

    public final synchronized OutputStreamWriter lazyGetWriter() {
        try {
            if (this.writer == null) {
                File f1;
                File f = new File(this.getFilePath() + "0.log");
                if (f.exists() && f.length() >= (long)this.fileMaxSize.intValue() && (!(f1 = new File(this.getFilePath() + "1.log")).exists() || f1.length() < (long)this.fileMaxSize.intValue())) {
                    f = f1;
                }
                boolean isAppend = f.exists();
                this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f, isAppend), Charset.forName("UTF-8").newEncoder());
                this.currentFile = f;
                if (!this.isCloseFileAfterRecord.booleanValue() && this.closerFile == null) {
                    this.closerFile = new CloserFile();
                    this.closerFile.start();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.writer;
    }

    public final synchronized void setIsNeedToRun(boolean pIsNeedToRun) {
        if (this.closerFile != null) {
            this.closerFile.setIsNeedToRun(pIsNeedToRun);
        }
    }

    public final synchronized void setIsCloseFileAfterRecord(Boolean pIsCloseFileAfterRecord) {
        this.isCloseFileAfterRecord = pIsCloseFileAfterRecord;
    }

    public final synchronized OutputStreamWriter getWriter() {
        return this.writer;
    }

    public final synchronized String getFilePath() {
        return this.filePath;
    }

    public final synchronized File getCurrentFile() {
        return this.currentFile;
    }

    public final synchronized void setFilePath(String pFilePath) {
        this.filePath = pFilePath;
    }

    public final synchronized Integer getFileMaxSize() {
        return this.fileMaxSize;
    }

    public final synchronized void setFileMaxSize(Integer pFileMaxSize) {
        this.fileMaxSize = pFileMaxSize;
    }

    public final synchronized long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public final synchronized long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public final synchronized void setMaxIdleTime(long pMaxIdleTime) {
        this.maxIdleTime = pMaxIdleTime;
    }

    public final synchronized Boolean getIsCloseFileAfterRecord() {
        return this.isCloseFileAfterRecord;
    }

    public final synchronized CloserFile getCloserFile() {
        return this.closerFile;
    }

    public final synchronized void setCloserFile(CloserFile pCloserFile) {
        this.closerFile = pCloserFile;
    }

    public final synchronized int getLogsCount() {
        return this.logsCount;
    }

    public final synchronized int getMaxLogsCountToClose() {
        return this.maxLogsCountToClose;
    }

    public final synchronized void setMaxLogsCountToClose(int pMaxLogsCountToClose) {
        this.maxLogsCountToClose = pMaxLogsCountToClose;
    }

    private class CloserFile
    extends Thread {
        private boolean isNeedToRun = true;

        private CloserFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            while (this.isNeedToRun) {
                try {
                    long currTime = new Date().getTime();
                    ALoggerFile aLoggerFile = ALoggerFile.this;
                    synchronized (aLoggerFile) {
                        if (ALoggerFile.this.getWriter() != null && (currTime - ALoggerFile.this.lastWriteTime > ALoggerFile.this.maxIdleTime || ALoggerFile.this.currentFile.length() > (long)ALoggerFile.this.fileMaxSize.intValue())) {
                            try {
                                ALoggerFile.this.getWriter().close();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                ALoggerFile.this.logsCount = 0;
                                ALoggerFile.this.writer = null;
                                ALoggerFile.this.currentFile = null;
                            }
                        }
                    }
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public final void setIsNeedToRun(boolean pIsNeedToRun) {
            this.isNeedToRun = pIsNeedToRun;
        }
    }
}

