/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.model;

import java.util.HashMap;
import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;

public class ColumnsValues {
    private String[] idColumnsNames;
    private final Map<String, Integer> integersMap = new HashMap<String, Integer>();
    private final Map<String, Long> longsMap = new HashMap<String, Long>();
    private final Map<String, Float> floatsMap = new HashMap<String, Float>();
    private final Map<String, Double> doublesMap = new HashMap<String, Double>();
    private final Map<String, String> stringsMap = new HashMap<String, String>();

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        for (Map.Entry<String, Integer> entry : this.integersMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        for (Map.Entry<String, Number> entry : this.longsMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        for (Map.Entry<String, Number> entry : this.floatsMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        for (Map.Entry<String, Number> entry : this.doublesMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.stringsMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey() + "=" + (String)entry.getValue());
        }
        return sb.toString();
    }

    public final void put(String pName, Integer pValue) {
        this.integersMap.put(pName, pValue);
    }

    public final void put(String pName, Long pValue) {
        this.longsMap.put(pName, pValue);
    }

    public final void put(String pName, Float pValue) {
        this.floatsMap.put(pName, pValue);
    }

    public final void put(String pName, Double pValue) {
        this.doublesMap.put(pName, pValue);
    }

    public final void put(String pName, String pValue) {
        this.stringsMap.put(pName, pValue);
    }

    public final Integer getInteger(String pName) {
        return this.integersMap.get(pName);
    }

    public final Long getLong(String pName) {
        return this.longsMap.get(pName);
    }

    public final Float getFloat(String pName) {
        return this.floatsMap.get(pName);
    }

    public final Double getDouble(String pName) {
        return this.doublesMap.get(pName);
    }

    public final String getString(String pName) {
        return this.stringsMap.get(pName);
    }

    public final String evalSqlValue(String pName) throws ExceptionWithCode {
        Object value = this.evalObjectValue(pName);
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public final Object evalObjectValue(String pName) throws ExceptionWithCode {
        for (String key : this.integersMap.keySet()) {
            if (!key.equals(pName)) continue;
            return this.integersMap.get(pName);
        }
        for (String key : this.longsMap.keySet()) {
            if (!key.equals(pName)) continue;
            return this.longsMap.get(pName);
        }
        for (String key : this.floatsMap.keySet()) {
            if (!key.equals(pName)) continue;
            return this.floatsMap.get(pName);
        }
        for (String key : this.doublesMap.keySet()) {
            if (!key.equals(pName)) continue;
            return this.doublesMap.get(pName);
        }
        for (String key : this.stringsMap.keySet()) {
            if (!key.equals(pName)) continue;
            String value = this.stringsMap.get(pName);
            if (value == null) {
                return null;
            }
            return "'" + value + "'";
        }
        String msg = "Value not found for column name " + pName;
        throw new ExceptionWithCode(1001, msg);
    }

    public final boolean ifContains(String pName) {
        for (String key : this.integersMap.keySet()) {
            if (!key.equals(pName)) continue;
            return true;
        }
        for (String key : this.longsMap.keySet()) {
            if (!key.equals(pName)) continue;
            return true;
        }
        for (String key : this.floatsMap.keySet()) {
            if (!key.equals(pName)) continue;
            return true;
        }
        for (String key : this.doublesMap.keySet()) {
            if (!key.equals(pName)) continue;
            return true;
        }
        for (String key : this.stringsMap.keySet()) {
            if (!key.equals(pName)) continue;
            return true;
        }
        return false;
    }

    public final void remove(String pName) {
        for (String key : this.integersMap.keySet()) {
            if (!key.equals(pName)) continue;
            this.integersMap.remove(pName);
            return;
        }
        for (String key : this.longsMap.keySet()) {
            if (!key.equals(pName)) continue;
            this.longsMap.remove(pName);
            return;
        }
        for (String key : this.floatsMap.keySet()) {
            if (!key.equals(pName)) continue;
            this.floatsMap.remove(pName);
            return;
        }
        for (String key : this.doublesMap.keySet()) {
            if (!key.equals(pName)) continue;
            this.doublesMap.remove(pName);
            return;
        }
        for (String key : this.stringsMap.keySet()) {
            if (!key.equals(pName)) continue;
            this.stringsMap.remove(pName);
            return;
        }
    }

    public final String[] getIdColumnsNames() {
        return this.idColumnsNames;
    }

    public final void setIdColumnsNames(String[] pIdColumnsNames) {
        this.idColumnsNames = pIdColumnsNames;
    }

    public final Map<String, Integer> getIntegersMap() {
        return this.integersMap;
    }

    public final Map<String, Long> getLongsMap() {
        return this.longsMap;
    }

    public final Map<String, Float> getFloatsMap() {
        return this.floatsMap;
    }

    public final Map<String, Double> getDoublesMap() {
        return this.doublesMap;
    }

    public final Map<String, String> getStringsMap() {
        return this.stringsMap;
    }
}

