/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.converter;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beigesoft.converter.IConverterByName;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactorySimple;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.model.IRecordSet;
import org.beigesoft.orm.model.TableSql;
import org.beigesoft.service.IFillerObjectFields;
import org.beigesoft.service.IFillerObjectsFrom;

public class CnvBnRsToEntity<RS>
implements IConverterByName<IRecordSet<RS>, Object> {
    private Map<String, TableSql> tablesMap;
    private IFactoryAppBeansByClass<IFactorySimple<?>> entitiesFactoriesFatory;
    private IFactoryAppBeansByClass<IFillerObjectFields<?>> fillersFieldsFactory;
    private IHolderForClassByName<Field> fieldsRapiHolder;
    private IFillerObjectsFrom<IRecordSet<RS>> fillerObjectsFromRs;

    @Override
    public final Object convert(Map<String, Object> pAddParam, IRecordSet<RS> pFrom, String pName) throws Exception {
        Class fieldClass = (Class)pAddParam.get("fieldClass");
        Class entityClass = (Class)pAddParam.get("entityClass");
        List foreignFieldNms = (List)pAddParam.get("foreignFieldNms");
        List currentLevel = (List)pAddParam.get("currentLevel");
        List deepLevel = (List)pAddParam.get("deepLevel");
        currentLevel.set(0, (Integer)currentLevel.get(0) + 1);
        Object entity = this.convertOnlyId(pAddParam, pFrom, pName, fieldClass, entityClass, currentLevel, deepLevel, foreignFieldNms);
        if (entity != null && (Integer)deepLevel.get(deepLevel.size() - 1) != 1 && (Integer)currentLevel.get(currentLevel.size() - 1) <= (Integer)deepLevel.get(deepLevel.size() - 1)) {
            if (currentLevel.size() > 1) {
                currentLevel.set(currentLevel.size() - 1, (Integer)currentLevel.get(currentLevel.size() - 1) + 1);
            }
            this.fillerObjectsFromRs.fill(pAddParam, entity, pFrom);
            if (currentLevel.size() > 1) {
                currentLevel.set(currentLevel.size() - 1, (Integer)currentLevel.get(currentLevel.size() - 1) - 1);
            }
        }
        if (currentLevel.size() > 1 && (Integer)currentLevel.get(currentLevel.size() - 1) == 1) {
            currentLevel.remove(currentLevel.size() - 1);
            deepLevel.remove(deepLevel.size() - 1);
        }
        foreignFieldNms.remove(foreignFieldNms.size() - 1);
        currentLevel.set(0, (Integer)currentLevel.get(0) - 1);
        return entity;
    }

    public final Object convertOnlyId(Map<String, Object> pAddParam, IRecordSet<RS> pFrom, String pName, Class pFieldClass, Class pEntityClass, List<Integer> pCurrentLevel, List<Integer> pDeepLevel, List<String> pForeignFieldNms) throws Exception {
        HashMap<String, Object> idNmValMap = new HashMap<String, Object>();
        TableSql tableSql = this.tablesMap.get(pFieldClass.getSimpleName());
        for (String idFldNm : tableSql.getIdColumnsNames()) {
            Object idVal;
            String columnAlias;
            Field rapiFld = this.fieldsRapiHolder.getFor(pFieldClass, idFldNm);
            if (pDeepLevel.get(pDeepLevel.size() - 1) == 1 || pCurrentLevel.get(pCurrentLevel.size() - 1) > pDeepLevel.get(pDeepLevel.size() - 1)) {
                if (pCurrentLevel.get(0) == 2) {
                    columnAlias = tableSql.getIdColumnsNames().length > 1 ? idFldNm.toUpperCase() : pName.toUpperCase();
                } else {
                    int pos = pCurrentLevel.get(pCurrentLevel.size() - 1) > pDeepLevel.get(pDeepLevel.size() - 1) || pDeepLevel.get(pDeepLevel.size() - 1) == 1 ? 2 : 1;
                    String currForeignFieldNm = pForeignFieldNms.get(pForeignFieldNms.size() - pos);
                    String tableAlias = currForeignFieldNm.toUpperCase();
                    columnAlias = tableSql.getIdColumnsNames().length > 1 ? tableAlias + idFldNm.toUpperCase() : tableAlias + pName.toUpperCase();
                }
            } else {
                columnAlias = pName.toUpperCase() + idFldNm.toUpperCase();
            }
            if (tableSql.getFieldsMap().get(idFldNm).getForeignEntity() != null) {
                TableSql tableSqlFr = this.tablesMap.get(rapiFld.getType().getSimpleName());
                if (tableSqlFr.getIdColumnsNames().length > 1 || tableSqlFr.getFieldsMap().get(tableSqlFr.getIdColumnsNames()[0]).getForeignEntity() != null) {
                    String msg = "There is no rule to fill foreign2 ID - " + rapiFld.getType();
                    throw new ExceptionWithCode(1000, msg);
                }
                Field rapiFldFr = this.fieldsRapiHolder.getFor(rapiFld.getType(), tableSqlFr.getIdFieldName());
                Object idEntFr = this.getSimpleId(rapiFldFr.getType(), pFrom, columnAlias);
                if (idEntFr != null) {
                    IFactorySimple<?> facEnFr = this.entitiesFactoriesFatory.lazyGet(pAddParam, rapiFld.getType());
                    idVal = facEnFr.create(pAddParam);
                    IFillerObjectFields<?> filler = this.fillersFieldsFactory.lazyGet(pAddParam, rapiFld.getType());
                    filler.fill(pAddParam, idVal, idEntFr, tableSqlFr.getIdColumnsNames()[0]);
                } else {
                    idVal = null;
                }
            } else {
                idVal = this.getSimpleId(rapiFld.getType(), pFrom, columnAlias);
            }
            if (idVal == null) continue;
            idNmValMap.put(idFldNm, idVal);
        }
        if (idNmValMap.size() > 0) {
            IFactorySimple<?> facEn = this.entitiesFactoriesFatory.lazyGet(pAddParam, pFieldClass);
            Object entity = facEn.create(pAddParam);
            IFillerObjectFields<?> filler = this.fillersFieldsFactory.lazyGet(pAddParam, pFieldClass);
            for (Map.Entry entry : idNmValMap.entrySet()) {
                filler.fill(pAddParam, entity, entry.getValue(), (String)entry.getKey());
            }
            return entity;
        }
        return null;
    }

    public final Object getSimpleId(Class<?> pFieldType, IRecordSet<RS> pFrom, String pColumnAlias) throws Exception {
        if (Integer.class == pFieldType) {
            return pFrom.getInteger(pColumnAlias);
        }
        if (Long.class == pFieldType) {
            return pFrom.getLong(pColumnAlias);
        }
        if (String.class == pFieldType) {
            return pFrom.getString(pColumnAlias);
        }
        String msg = "There is no rule to get column ID-able " + pColumnAlias + " of " + pFieldType;
        throw new ExceptionWithCode(1000, msg);
    }

    public final Map<String, TableSql> getTablesMap() {
        return this.tablesMap;
    }

    public final void setTablesMap(Map<String, TableSql> pTablesMap) {
        this.tablesMap = pTablesMap;
    }

    public final IFactoryAppBeansByClass<IFactorySimple<?>> getEntitiesFactoriesFatory() {
        return this.entitiesFactoriesFatory;
    }

    public final void setEntitiesFactoriesFatory(IFactoryAppBeansByClass<IFactorySimple<?>> pEntitiesFactoriesFatory) {
        this.entitiesFactoriesFatory = pEntitiesFactoriesFatory;
    }

    public final IFactoryAppBeansByClass<IFillerObjectFields<?>> getFillersFieldsFactory() {
        return this.fillersFieldsFactory;
    }

    public final void setFillersFieldsFactory(IFactoryAppBeansByClass<IFillerObjectFields<?>> pFillersFieldsFactory) {
        this.fillersFieldsFactory = pFillersFieldsFactory;
    }

    public final IHolderForClassByName<Field> getFieldsRapiHolder() {
        return this.fieldsRapiHolder;
    }

    public final void setFieldsRapiHolder(IHolderForClassByName<Field> pFieldsRapiHolder) {
        this.fieldsRapiHolder = pFieldsRapiHolder;
    }

    public final IFillerObjectsFrom<IRecordSet<RS>> getFillerObjectsFromRs() {
        return this.fillerObjectsFromRs;
    }

    public final void setFillerObjectsFromRs(IFillerObjectsFrom<IRecordSet<RS>> pFillerObjectsFromRs) {
        this.fillerObjectsFromRs = pFillerObjectsFromRs;
    }
}

