/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.converter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.beigesoft.converter.IConverterIntoByName;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.model.ColumnsValues;
import org.beigesoft.orm.model.TableSql;

public class CnvIbnEntitiesToCv
implements IConverterIntoByName<Object, ColumnsValues> {
    private Map<String, TableSql> tablesMap;
    private IHolderForClassByName<Field> fieldsRapiHolder;
    private IHolderForClassByName<Method> gettersRapiHolder;

    @Override
    public final void convert(Map<String, Object> pAddParam, Object pFrom, ColumnsValues pTo, String pName) throws Exception {
        Class fromClass = (Class)pAddParam.get("fromClass");
        TableSql foreignTable = this.tablesMap.get(fromClass.getSimpleName());
        if (foreignTable.getIdColumnsNames().length == 1) {
            Method getter;
            Field field = this.fieldsRapiHolder.getFor(fromClass, foreignTable.getIdColumnsNames()[0]);
            if (!this.tryToPutIdable(field, getter = this.gettersRapiHolder.getFor(fromClass, foreignTable.getIdColumnsNames()[0]), pFrom, pTo, pName)) {
                TableSql idForeignTable;
                String idForeignEntityNm = foreignTable.getFieldsMap().get(foreignTable.getIdColumnsNames()[0]).getForeignEntity();
                boolean isSolved = false;
                if (idForeignEntityNm != null && (idForeignTable = this.tablesMap.get(idForeignEntityNm)).getIdColumnsNames().length == 1) {
                    Method getterId;
                    Object idObject = getter.invoke(pFrom, new Object[0]);
                    Field fieldId = this.fieldsRapiHolder.getFor(field.getType(), idForeignTable.getIdColumnsNames()[0]);
                    if (this.tryToPutIdable(fieldId, getterId = this.gettersRapiHolder.getFor(field.getType(), idForeignTable.getIdColumnsNames()[0]), idObject, pTo, pName)) {
                        isSolved = true;
                    }
                }
                if (!isSolved) {
                    String msg = "There is no rule to fill column foreign id value from field " + pName + " of " + field.getType() + " in " + pFrom;
                    throw new ExceptionWithCode(1000, msg);
                }
            }
        } else {
            for (String idFldNm : foreignTable.getIdColumnsNames()) {
                Object idVal;
                Method getter = this.gettersRapiHolder.getFor(fromClass, idFldNm);
                Field field = this.fieldsRapiHolder.getFor(fromClass, idFldNm);
                if (this.tryToPutIdable(field, getter, pFrom, pTo, idFldNm)) continue;
                TableSql foreignIdTable = this.tablesMap.get(field.getType().getSimpleName());
                if (foreignIdTable == null || foreignIdTable.getIdColumnsNames().length > 1) {
                    String msg = "There is no rule to fill column foreign id value from field " + pName + " of " + field.getType() + " in " + pFrom;
                    throw new ExceptionWithCode(1000, msg);
                }
                Method getterId = this.gettersRapiHolder.getFor(field.getType(), foreignIdTable.getIdColumnsNames()[0]);
                Field fieldId = this.fieldsRapiHolder.getFor(field.getType(), foreignIdTable.getIdColumnsNames()[0]);
                if (this.tryToPutIdable(fieldId, getterId, idVal = pFrom == null ? null : getter.invoke(pFrom, new Object[0]), pTo, foreignIdTable.getIdColumnsNames()[0])) continue;
                String msg = "Can't fill FCID 2L: " + foreignIdTable.getIdColumnsNames()[0] + " of " + fieldId.getType() + " in " + idVal;
                throw new ExceptionWithCode(1000, msg);
            }
        }
    }

    public final boolean tryToPutIdable(Field pField, Method pGetter, Object pFrom, ColumnsValues pTo, String pName) throws Exception {
        if (Integer.class == pField.getType()) {
            Integer val = pFrom == null ? null : (Integer)pGetter.invoke(pFrom, new Object[0]);
            pTo.put(pName, val);
            return true;
        }
        if (Long.class == pField.getType()) {
            Long val = pFrom == null ? null : (Long)pGetter.invoke(pFrom, new Object[0]);
            pTo.put(pName, val);
            return true;
        }
        if (String.class == pField.getType()) {
            String val = pFrom == null ? null : (String)pGetter.invoke(pFrom, new Object[0]);
            pTo.put(pName, val);
            return true;
        }
        return false;
    }

    public final Map<String, TableSql> getTablesMap() {
        return this.tablesMap;
    }

    public final void setTablesMap(Map<String, TableSql> pTablesMap) {
        this.tablesMap = pTablesMap;
    }

    public final IHolderForClassByName<Field> getFieldsRapiHolder() {
        return this.fieldsRapiHolder;
    }

    public final void setFieldsRapiHolder(IHolderForClassByName<Field> pFieldsRapiHolder) {
        this.fieldsRapiHolder = pFieldsRapiHolder;
    }

    public final IHolderForClassByName<Method> getGettersRapiHolder() {
        return this.gettersRapiHolder;
    }

    public final void setGettersRapiHolder(IHolderForClassByName<Method> pGettersRapiHolder) {
        this.gettersRapiHolder = pGettersRapiHolder;
    }
}

