/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.handler;

import java.util.Map;
import org.beigesoft.handler.IHandlerRequest;
import org.beigesoft.model.IRequestData;
import org.beigesoft.orm.service.ASrvOrm;
import org.beigesoft.persistable.DatabaseInfo;
import org.beigesoft.service.ISrvDatabase;

public class HandlerAbout<RS>
implements IHandlerRequest {
    private ISrvDatabase<RS> srvDatabase;
    private ASrvOrm<RS> srvOrm;

    @Override
    public final void handle(Map<String, Object> pReqVars, IRequestData pRequestData) throws Exception {
        try {
            this.srvDatabase.setIsAutocommit(false);
            this.srvDatabase.setTransactionIsolation(ISrvDatabase.TRANSACTION_READ_UNCOMMITTED);
            this.srvDatabase.beginTransaction();
            DatabaseInfo databaseInfo = this.getSrvOrm().retrieveEntityWithConditions(pReqVars, DatabaseInfo.class, "");
            pRequestData.setAttribute("databaseInfo", databaseInfo);
            pRequestData.setAttribute("appVersion", this.getSrvOrm().getMngSettings().getAppSettings().get("appVersion"));
            this.srvDatabase.commitTransaction();
        }
        catch (Exception ex) {
            this.srvDatabase.rollBackTransaction();
            throw ex;
        }
        finally {
            this.srvDatabase.releaseResources();
        }
    }

    public final ISrvDatabase<RS> getSrvDatabase() {
        return this.srvDatabase;
    }

    public final void setSrvDatabase(ISrvDatabase<RS> pSrvDatabase) {
        this.srvDatabase = pSrvDatabase;
    }

    public final ASrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ASrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }
}

