/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.processor;

import java.util.Map;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.model.IRequestData;
import org.beigesoft.persistable.Eattachment;
import org.beigesoft.persistable.EmailIntegerProperty;
import org.beigesoft.persistable.EmailMsg;
import org.beigesoft.persistable.EmailStringProperty;
import org.beigesoft.persistable.Erecipient;
import org.beigesoft.service.IEntityProcessor;
import org.beigesoft.service.IMailSender;
import org.beigesoft.service.ISrvOrm;

public class PrcEmailMsgSave<RS>
implements IEntityProcessor<EmailMsg, Long> {
    private ISrvOrm<RS> srvOrm;
    private IMailSender emailSender;

    @Override
    public final EmailMsg process(Map<String, Object> pAddParam, EmailMsg pEntity, IRequestData pRequestData) throws Exception {
        if (pEntity.getIsNew().booleanValue()) {
            this.srvOrm.insertEntity(pAddParam, pEntity);
            pEntity.setIsNew(false);
        } else {
            if (pEntity.getIsSent().booleanValue()) {
                throw new ExceptionWithCode(1003, "can_not_change_sent_email");
            }
            boolean isNeedSend = false;
            if (pRequestData.getParameter("actionAdd") != null) {
                isNeedSend = true;
            }
            if (isNeedSend) {
                Erecipient erec = new Erecipient();
                erec.setItsOwner(pEntity);
                pEntity.setErecipients(this.getSrvOrm().retrieveListForField(pAddParam, erec, "itsOwner"));
                if (pEntity.getErecipients().size() == 0) {
                    throw new ExceptionWithCode(1003, "choose_recipient");
                }
                pEntity.setEmailConnect(this.srvOrm.retrieveEntity(pAddParam, pEntity.getEmailConnect()));
                EmailStringProperty emStrProp = new EmailStringProperty();
                emStrProp.setItsOwner(pEntity.getEmailConnect());
                pEntity.getEmailConnect().setStringProperties(this.getSrvOrm().retrieveListForField(pAddParam, emStrProp, "itsOwner"));
                EmailIntegerProperty emIntProp = new EmailIntegerProperty();
                emIntProp.setItsOwner(pEntity.getEmailConnect());
                pEntity.getEmailConnect().setIntegerProperties(this.getSrvOrm().retrieveListForField(pAddParam, emIntProp, "itsOwner"));
                Eattachment eattach = new Eattachment();
                eattach.setItsOwner(pEntity);
                pEntity.setEattachments(this.getSrvOrm().retrieveListForField(pAddParam, eattach, "itsOwner"));
                this.getEmailSender().openConnection(pAddParam, pEntity.getEmailConnect());
                this.getEmailSender().sendEmail(pAddParam, pEntity);
                this.getEmailSender().closeConnection(pAddParam, pEntity.getEmailConnect());
                pEntity.setIsSent(true);
            }
            this.srvOrm.updateEntity(pAddParam, pEntity);
        }
        return pEntity;
    }

    public final ISrvOrm<RS> getSrvOrm() {
        return this.srvOrm;
    }

    public final void setSrvOrm(ISrvOrm<RS> pSrvOrm) {
        this.srvOrm = pSrvOrm;
    }

    public final IMailSender getEmailSender() {
        return this.emailSender;
    }

    public final void setEmailSender(IMailSender pEmailSender) {
        this.emailSender = pEmailSender;
    }
}

