/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.orm.service;

import java.nio.charset.Charset;
import java.util.Map;
import org.beigesoft.converter.IConverterToFromString;
import org.beigesoft.exception.ExceptionWithCode;
import org.beigesoft.factory.IFactoryAppBeansByClass;
import org.beigesoft.factory.IFactoryAppBeansByName;
import org.beigesoft.holder.IHolderForClassByName;
import org.beigesoft.log.ILogger;
import org.beigesoft.model.IRequestData;
import org.beigesoft.service.IFillerObjectFields;
import org.beigesoft.service.IFillerObjectsFrom;

public class FillEntityFromReq
implements IFillerObjectsFrom<IRequestData> {
    private ILogger logger;
    private IFactoryAppBeansByClass<IFillerObjectFields<?>> fillersFieldsFactory;
    private IFactoryAppBeansByName<IConverterToFromString<?>> convertersFieldsFatory;
    private IHolderForClassByName<String> fieldConverterNamesHolder;

    @Override
    public final <T> void fill(Map<String, Object> pAddParam, T pEntity, IRequestData pReq) throws Exception {
        boolean isShowDbMsg = this.logger.getIsShowDebugMessagesFor(this.getClass());
        int dbgDetLev = this.logger.getDetailLevel();
        if (isShowDbMsg && dbgDetLev > 2) {
            this.logger.debug(null, FillEntityFromReq.class, "Default charset = " + Charset.defaultCharset());
        }
        IFillerObjectFields<?> filler = this.fillersFieldsFactory.lazyGet(pAddParam, pEntity.getClass());
        for (String fieldName : filler.getFieldsNames()) {
            try {
                IConverterToFromString<?> conv;
                Object fieldVal;
                String valStr = pReq.getParameter(pEntity.getClass().getSimpleName() + "." + fieldName);
                if (valStr == null) continue;
                String convName = this.fieldConverterNamesHolder.getFor(pEntity.getClass(), fieldName);
                if (isShowDbMsg && dbgDetLev > 32000) {
                    this.logger.debug(null, FillEntityFromReq.class, "Try fill field/inClass/converterName/value: " + fieldName + "/" + pEntity.getClass().getCanonicalName() + "/" + convName + "/" + valStr);
                }
                if ((fieldVal = (conv = this.convertersFieldsFatory.lazyGet(pAddParam, convName)).fromString(pAddParam, valStr)) != null && isShowDbMsg && dbgDetLev > 32000) {
                    this.logger.debug(null, FillEntityFromReq.class, "Converted fieldClass/toString: " + fieldVal.getClass().getCanonicalName() + "/" + fieldVal);
                }
                filler.fill(pAddParam, pEntity, fieldVal, fieldName);
            }
            catch (Exception ex) {
                String msg = "Can't fill field/class: " + fieldName + "/" + pEntity.getClass().getCanonicalName();
                throw new ExceptionWithCode(1001, msg, ex);
            }
        }
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger pLogger) {
        this.logger = pLogger;
    }

    public final IFactoryAppBeansByClass<IFillerObjectFields<?>> getFillersFieldsFactory() {
        return this.fillersFieldsFactory;
    }

    public final void setFillersFieldsFactory(IFactoryAppBeansByClass<IFillerObjectFields<?>> pFillersFieldsFactory) {
        this.fillersFieldsFactory = pFillersFieldsFactory;
    }

    public final IFactoryAppBeansByName<IConverterToFromString<?>> getConvertersFieldsFatory() {
        return this.convertersFieldsFatory;
    }

    public final void setConvertersFieldsFatory(IFactoryAppBeansByName<IConverterToFromString<?>> pConvertersFieldsFatory) {
        this.convertersFieldsFatory = pConvertersFieldsFatory;
    }

    public final IHolderForClassByName<String> getFieldConverterNamesHolder() {
        return this.fieldConverterNamesHolder;
    }

    public final void setFieldConverterNamesHolder(IHolderForClassByName<String> pFieldConverterNamesHolder) {
        this.fieldConverterNamesHolder = pFieldConverterNamesHolder;
    }
}

