/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.beigesoft.pdf.model.APdfObject;
import org.beigesoft.pdf.model.APdfStream;
import org.beigesoft.pdf.service.IWriterPdfObject;
import org.beigesoft.pdf.service.PdfWriteHelper;
import org.beigesoft.zlib.IZLibStreamer;

public abstract class AWriterPdfStream<T extends APdfStream<O>, O extends APdfStream>
implements IWriterPdfObject<T> {
    private PdfWriteHelper writeHelper;
    private IZLibStreamer zLibStreamer;

    public abstract void writeToBuffer(T var1, OutputStream var2) throws Exception;

    @Override
    public final int write(T pPdfObj, OutputStream pOut) throws Exception {
        byte[] cont;
        ((APdfStream)pPdfObj).getBuffer().reset();
        this.writeToBuffer(pPdfObj, pOut);
        if (!((APdfStream)pPdfObj).getIsCompressed().booleanValue()) {
            cont = ((APdfStream)pPdfObj).getBuffer().toByteArray();
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(((APdfStream)pPdfObj).getBuffer().toByteArray());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.zLibStreamer.compress(null, is, os);
            cont = os.toByteArray();
        }
        int bytesWritten = 0;
        byte[] btsNumSp = (((APdfObject)pPdfObj).getNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsNumSp, pOut);
        byte[] btsGenNumSp = (((APdfObject)pPdfObj).getGenNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsGenNumSp, pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartObj(), pOut);
        if (((APdfStream)pPdfObj).getIsCompressed().booleanValue()) {
            bytesWritten += this.getWriteHelper().writeBytes("/Filter /FlateDecode\n".getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        String startStr = "/Length " + cont.length;
        bytesWritten += this.getWriteHelper().writeBytes(startStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndDictLf(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartStreamLf(), pOut);
        bytesWritten += this.getWriteHelper().writeBytes(cont, pOut);
        return bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndStreamObjLf(), pOut);
    }

    public final PdfWriteHelper getWriteHelper() {
        return this.writeHelper;
    }

    public final void setWriteHelper(PdfWriteHelper pWriteHelper) {
        this.writeHelper = pWriteHelper;
    }

    public final IZLibStreamer getZLibStreamer() {
        return this.zLibStreamer;
    }

    public final void setZLibStreamer(IZLibStreamer pZLibStreamer) {
        this.zLibStreamer = pZLibStreamer;
    }
}

