/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.util.Map;
import org.beigesoft.doc.service.IEvalCharWidth;
import org.beigesoft.pdf.exception.ExceptionPdfWr;
import org.beigesoft.ttf.model.TtfFont;

public class EvalCharWidth
implements IEvalCharWidth {
    private Map<String, TtfFont> ttfFonts;

    @Override
    public final double eval(char pSource, String pFntNm, double pFntSize) throws Exception {
        TtfFont ttf = this.ttfFonts.get(pFntNm);
        if (ttf == null) {
            throw new ExceptionPdfWr("Metrics of standard 14 fonts not yet implemented!!!");
        }
        Character gid = ttf.getCmap().getUniToCid().get(Character.valueOf(pSource));
        if (gid == null) {
            throw new ExceptionPdfWr("Can't find GID for char/uni: " + pSource + "/" + pSource);
        }
        double wdp = ttf.getHmtx().getWidthForGid(gid.charValue());
        double upe = ttf.getHead().getUnitsPerEm();
        return pFntSize * wdp / upe;
    }

    public final Map<String, TtfFont> getTtfFonts() {
        return this.ttfFonts;
    }

    public final void setTtfFonts(Map<String, TtfFont> pTtfFonts) {
        this.ttfFonts = pTtfFonts;
    }
}

