/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.beigesoft.doc.model.DocImage;
import org.beigesoft.doc.service.IElementWriter;
import org.beigesoft.doc.service.UomHelper;
import org.beigesoft.pdf.model.EGraphicState;
import org.beigesoft.pdf.model.ETextState;
import org.beigesoft.pdf.model.HasPdfContent;
import org.beigesoft.pdf.model.PdfContent;
import org.beigesoft.pdf.model.PdfImage;
import org.beigesoft.pdf.service.PdfWriteHelper;

public class ImageWriter
implements IElementWriter<DocImage<HasPdfContent>, HasPdfContent> {
    private PdfWriteHelper writeHelper;
    private UomHelper uomHelper;

    @Override
    public final void write(DocImage<HasPdfContent> pImg, HasPdfContent pWi) throws Exception {
        String img;
        PdfContent wi = pWi.getPdfContent();
        if (wi.getTextState().equals((Object)ETextState.STARTED)) {
            wi.getBuffer().write("ET\n".getBytes(this.getWriteHelper().getAscii()));
            wi.setTextState(ETextState.ENDED);
            wi.setX(null);
            wi.setY(null);
        }
        if (wi.getGraphicState().equals((Object)EGraphicState.STARTED)) {
            wi.getBuffer().write("S\n".getBytes(this.getWriteHelper().getAscii()));
            wi.setGraphicState(EGraphicState.ENDED);
        }
        BigDecimal wd = BigDecimal.valueOf((double)pImg.getImage().getWidth() * pImg.getScale()).setScale(2, RoundingMode.HALF_UP);
        BigDecimal ht = BigDecimal.valueOf((double)pImg.getImage().getHeight() * pImg.getScale()).setScale(2, RoundingMode.HALF_UP);
        double imgX1d = this.uomHelper.toPoints(pImg.getX1(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        BigDecimal imgX1 = BigDecimal.valueOf(imgX1d).setScale(2, RoundingMode.HALF_UP);
        double pageHeight = this.uomHelper.toPoints(wi.getPage().getHeight(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double imgUY1d = this.uomHelper.toPoints(pImg.getY1(), wi.getDocument().getMainDoc().getResolutionDpi(), wi.getDocument().getMainDoc().getUnitOfMeasure());
        double imgY1d = pageHeight - imgUY1d - ht.doubleValue();
        BigDecimal imgY1 = BigDecimal.valueOf(imgY1d).setScale(2, RoundingMode.HALF_UP);
        int imgNum = 1;
        for (PdfImage pdfImage : wi.getDocument().getImages()) {
            if (pdfImage.getDocImage().equals(pImg)) break;
            ++imgNum;
        }
        if (pImg.getRotateDegrees() > 0.001) {
            double rad = Math.toRadians(pImg.getRotateDegrees());
            BigDecimal cosr = BigDecimal.valueOf(Math.cos(rad)).setScale(4, RoundingMode.HALF_UP);
            BigDecimal sinr = BigDecimal.valueOf(Math.sin(rad)).setScale(4, RoundingMode.HALF_UP);
            BigDecimal sinrn = sinr.negate();
            img = "q\n 1 0 0 1 " + imgX1 + " " + imgY1 + " cm\n" + cosr.toString() + " " + sinr + " " + sinrn + " " + cosr + "  0 0 cm\n" + wd.toString() + " 0 0 " + ht + " 0 0 cm\n/Im" + imgNum + " Do\nQ\n";
        } else {
            img = "q\n" + wd + " 0 0 " + ht + " " + imgX1 + " " + imgY1 + " cm\n/Im" + imgNum + " Do\nQ\n";
        }
        wi.getBuffer().write(img.getBytes(this.getWriteHelper().getAscii()));
    }

    public final PdfWriteHelper getWriteHelper() {
        return this.writeHelper;
    }

    public final void setWriteHelper(PdfWriteHelper pWriteHelper) {
        this.writeHelper = pWriteHelper;
    }

    public final UomHelper getUomHelper() {
        return this.uomHelper;
    }

    public final void setUomHelper(UomHelper pUomHelper) {
        this.uomHelper = pUomHelper;
    }
}

