/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;

public class PdfWriteHelper {
    private final Charset ascii = Charset.forName("ISO-8859-1");
    private final byte[] startObj = "obj\n<<".getBytes(this.ascii);
    private final byte[] endObjLf = ">>\nendobj\n".getBytes(this.ascii);
    private final String pdfVersion10 = "%PDF-1.0\n";
    private final String pdfVersion11 = "%PDF-1.1\n";
    private final String pdfVersion12 = "%PDF-1.2\n";
    private final String pdfVersion13 = "%PDF-1.3\n";
    private final String pdfVersion14 = "%PDF-1.4\n";
    private final String pdfVersion15 = "%PDF-1.5\n";
    private final String pdfVersion16 = "%PDF-1.6\n";
    private final String pdfVersion17 = "%PDF-1.7\n";
    private final byte[] headBinarySign = new byte[]{37, -128, -127, -126, -125, 10};
    private final byte[] comment = new byte[]{37};
    private final byte[] lf = new byte[]{10};
    private final byte[] eof = "%%EOF".getBytes(this.ascii);
    private final byte[] trailerStart = "trailer\n<</Size ".getBytes(this.ascii);
    private final byte[] startxrefLf = "startxref\n".getBytes(this.ascii);
    private final byte[] xrefLf = "xref\n".getBytes(this.ascii);
    private final byte[] xref1EntryLf = "0000000000 65535 f\n".getBytes(this.ascii);
    private final char[] escLeParentheses = new char[]{'\\', '('};
    private final char[] escRiParentheses = new char[]{'\\', ')'};
    private final char[] escBackSlash = new char[]{'\\', '\\'};
    private final byte[] endDictLf = ">>\n".getBytes(this.ascii);
    private final byte[] endArrLf = "]\n".getBytes(this.ascii);
    private final byte[] startStreamLf = "stream\n".getBytes(this.ascii);
    private final byte[] startWarray = "/W [ ".getBytes(this.ascii);
    private final byte[] endStreamObjLf = "endstream\nendobj\n".getBytes(this.ascii);

    public final String dateToString(Date pDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(pDate);
        String yearStr = String.valueOf(cal.get(1));
        String monthStr = String.format("%02d", cal.get(2) + 1);
        String dayStr = String.format("%02d", cal.get(5));
        String hourStr = String.format("%02d", cal.get(11));
        String minuteStr = String.format("%02d", cal.get(12));
        long zoneOffset = cal.get(15);
        String plusMinus = zoneOffset > 0L ? "+" : "-";
        long hourDelta = zoneOffset / 3600000L;
        long minuteDelta = zoneOffset % 3600000L / 60000L;
        String hourDeltaStr = String.format("%02d", hourDelta);
        String minuteDeltaStr = String.format("%02d", minuteDelta);
        return "D:" + yearStr + monthStr + dayStr + hourStr + minuteStr + plusMinus + hourDeltaStr + "'" + minuteDeltaStr;
    }

    public final String escapePdf(String pSource) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pSource.length(); ++i) {
            char ch = pSource.charAt(i);
            char[] escaped = this.pdfEscape(ch);
            if (escaped != null) {
                sb.append(escaped);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public final char[] pdfEscape(char pChar) {
        if (pChar == '(') {
            return this.escLeParentheses;
        }
        if (pChar == ')') {
            return this.escRiParentheses;
        }
        if (pChar == '\\') {
            return this.escBackSlash;
        }
        return null;
    }

    public final int writeBytes(byte[] pBytes, OutputStream pOut) throws Exception {
        pOut.write(pBytes);
        return pBytes.length;
    }

    public final Charset getAscii() {
        return this.ascii;
    }

    public final byte[] getStartObj() {
        return this.startObj;
    }

    public final byte[] getEndObjLf() {
        return this.endObjLf;
    }

    public final String getPdfVersion10() {
        return this.pdfVersion10;
    }

    public final String getPdfVersion11() {
        return this.pdfVersion11;
    }

    public final String getPdfVersion12() {
        return this.pdfVersion12;
    }

    public final String getPdfVersion13() {
        return this.pdfVersion13;
    }

    public final String getPdfVersion14() {
        return this.pdfVersion14;
    }

    public final String getPdfVersion15() {
        return this.pdfVersion15;
    }

    public final String getPdfVersion16() {
        return this.pdfVersion16;
    }

    public final String getPdfVersion17() {
        return this.pdfVersion17;
    }

    public final byte[] getHeadBinarySign() {
        return this.headBinarySign;
    }

    public final byte[] getComment() {
        return this.comment;
    }

    public final byte[] getLf() {
        return this.lf;
    }

    public final byte[] getEof() {
        return this.eof;
    }

    public final byte[] getTrailerStart() {
        return this.trailerStart;
    }

    public final byte[] getStartxrefLf() {
        return this.startxrefLf;
    }

    public final byte[] getXrefLf() {
        return this.xrefLf;
    }

    public final byte[] getXref1EntryLf() {
        return this.xref1EntryLf;
    }

    public final char[] getEscLeParentheses() {
        return this.escLeParentheses;
    }

    public final char[] getEscRiParentheses() {
        return this.escRiParentheses;
    }

    public final char[] getEscBackSlash() {
        return this.escBackSlash;
    }

    public final byte[] getEndDictLf() {
        return this.endDictLf;
    }

    public final byte[] getEndArrLf() {
        return this.endArrLf;
    }

    public final byte[] getStartStreamLf() {
        return this.startStreamLf;
    }

    public final byte[] getEndStreamObjLf() {
        return this.endStreamObjLf;
    }

    public final byte[] getStartWarray() {
        return this.startWarray;
    }
}

