/*
 * Decompiled with CFR 0.152.
 */
package org.beigesoft.pdf.service;

import java.io.OutputStream;
import org.beigesoft.pdf.model.PdfInfo;
import org.beigesoft.pdf.service.AWriterPdfObject;

public class WriterPdfInfo
extends AWriterPdfObject<PdfInfo> {
    @Override
    public final int write(PdfInfo pPdfObj, OutputStream pOut) throws Exception {
        int bytesWritten = 0;
        byte[] btsNumSp = (pPdfObj.getNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsNumSp, pOut);
        byte[] btsGenNumSp = (pPdfObj.getGenNumber().toString() + " ").getBytes(this.getWriteHelper().getAscii());
        bytesWritten += this.getWriteHelper().writeBytes(btsGenNumSp, pOut);
        bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getStartObj(), pOut);
        String creatorStr = "/Creator (" + this.getWriteHelper().escapePdf(pPdfObj.getCreator()) + ")\n";
        bytesWritten += this.getWriteHelper().writeBytes(creatorStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        if (pPdfObj.getProducer() != null) {
            String producerStr = "/Producer (" + this.getWriteHelper().escapePdf(pPdfObj.getProducer()) + ")\n";
            bytesWritten += this.getWriteHelper().writeBytes(producerStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        if (pPdfObj.getTitle() != null) {
            String titleStr = "/Title (" + this.getWriteHelper().escapePdf(pPdfObj.getTitle()) + ")\n";
            bytesWritten += this.getWriteHelper().writeBytes(titleStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        if (pPdfObj.getAuthor() != null) {
            String authorStr = "/Author (" + this.getWriteHelper().escapePdf(pPdfObj.getAuthor()) + ")\n";
            bytesWritten += this.getWriteHelper().writeBytes(authorStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        if (pPdfObj.getSubject() != null) {
            String subjectStr = "/Subject (" + this.getWriteHelper().escapePdf(pPdfObj.getSubject()) + ")\n";
            bytesWritten += this.getWriteHelper().writeBytes(subjectStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        if (pPdfObj.getKeywords() != null) {
            String keywordsStr = "/Keywords (" + this.getWriteHelper().escapePdf(pPdfObj.getKeywords()) + ")\n";
            bytesWritten += this.getWriteHelper().writeBytes(keywordsStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        if (pPdfObj.getCreationDate() != null) {
            String creationDateStr = "/CreationDate (" + this.getWriteHelper().dateToString(pPdfObj.getCreationDate()) + ")\n";
            bytesWritten += this.getWriteHelper().writeBytes(creationDateStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        if (pPdfObj.getModDate() != null) {
            String modDateStr = "/ModDate (" + this.getWriteHelper().dateToString(pPdfObj.getModDate()) + ")";
            bytesWritten += this.getWriteHelper().writeBytes(modDateStr.getBytes(this.getWriteHelper().getAscii()), pOut);
        }
        return bytesWritten += this.getWriteHelper().writeBytes(this.getWriteHelper().getEndObjLf(), pOut);
    }
}

